/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.identifier;

import android.content.Context;
import android.content.ServiceConnection;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.ads.identifier.zza;
import com.google.android.gms.ads.identifier.zzb;
import com.google.android.gms.common.BlockingServiceConnection;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.annotation.KeepForSdkWithMembers;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads_identifier.zzf;
import java.io.IOException;
import java.util.HashMap;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;

@ParametersAreNonnullByDefault
@KeepForSdk
public class AdvertisingIdClient {
    @GuardedBy(value="this")
    @Nullable
    BlockingServiceConnection zza;
    @GuardedBy(value="this")
    @Nullable
    zzf zzb;
    @GuardedBy(value="this")
    boolean zzc;
    final Object zzd;
    @GuardedBy(value="mAutoDisconnectTaskLock")
    @Nullable
    zzb zze;
    @GuardedBy(value="this")
    private final Context zzg;
    final long zzf;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    @RecentlyNonNull
    public static Info getAdvertisingIdInfo(@RecentlyNonNull Context context) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        Throwable throwable2;
        AdvertisingIdClient advertisingIdClient;
        block5: {
            long l;
            Object object;
            advertisingIdClient = new AdvertisingIdClient((Context)object, -1L, true, false);
            try {
                l = SystemClock.elapsedRealtime();
                advertisingIdClient.zzb(false);
                object = advertisingIdClient.zzd(-1);
                long l2 = SystemClock.elapsedRealtime();
                l = l2 - l;
            }
            catch (Throwable throwable2) {
                break block5;
            }
            {
                advertisingIdClient.zzc((Info)object, true, 0.0f, l, "", null);
                advertisingIdClient.zza();
                return object;
            }
        }
        try {}
        catch (Throwable throwable3) {
            advertisingIdClient.zza();
            throw throwable3;
        }
        advertisingIdClient.zzc(null, true, 0.0f, -1L, "", throwable2);
        throw throwable2;
    }

    @KeepForSdk
    @RecentlyNonNull
    public Info getInfo() throws IOException {
        return this.zzd(-1);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public AdvertisingIdClient(@RecentlyNonNull Context context) {
        this((Context)var1_1, 30000L, false, false);
        void var1_1;
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    public AdvertisingIdClient(@RecentlyNonNull Context context, long l, boolean bl, boolean bl2) {
        Object object;
        this.zzd = object = new Object();
        Preconditions.checkNotNull((Object)context);
        if (bl) {
            Context context2 = context.getApplicationContext();
            if (context2 != null) {
                context = context2;
            }
            this.zzg = context;
        } else {
            this.zzg = context;
        }
        this.zzc = false;
        this.zzf = l;
    }

    protected final void finalize() throws Throwable {
        this.zza();
        super.finalize();
    }

    @KeepForSdk
    @ShowFirstParty
    public static void setShouldSkipGmsCoreVersionCheck(boolean bl) {
    }

    @KeepForSdk
    public void start() throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        this.zzb(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @KeepForSdk
    public static boolean getIsAdIdFakeForDebugLogging(@RecentlyNonNull Context context) throws IOException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        RemoteException remoteException2;
        block19: {
            boolean bl;
            AdvertisingIdClient advertisingIdClient;
            block18: {
                boolean bl2;
                Context context2;
                advertisingIdClient = new AdvertisingIdClient(context2, -1L, false, false);
                advertisingIdClient.zzb(false);
                Preconditions.checkNotMainThread((String)"Calling this from your main thread can lead to deadlock");
                // MONITORENTER : advertisingIdClient
                bl = advertisingIdClient.zzc;
                if (bl) break block18;
                Object object = advertisingIdClient.zzd;
                Object object2 = advertisingIdClient.zze;
                if (object2 == null || !(bl2 = ((zzb)object2).zzb)) {
                    object2 = new IOException("AdvertisingIdClient is not connected.");
                    throw object2;
                }
                // MONITOREXIT : object
                try {
                    advertisingIdClient.zzb(false);
                    bl = advertisingIdClient.zzc;
                    if (!bl) break block19;
                }
                catch (Exception exception) {
                    IOException iOException = new IOException("AdvertisingIdClient cannot reconnect.", exception);
                    throw iOException;
                }
            }
            Preconditions.checkNotNull((Object)advertisingIdClient.zza);
            Preconditions.checkNotNull((Object)advertisingIdClient.zzb);
            try {
                bl = advertisingIdClient.zzb.zzd();
                // MONITOREXIT : advertisingIdClient
            }
            catch (RemoteException remoteException2) {}
            try {
                advertisingIdClient.zze();
                return bl;
            }
            finally {
                advertisingIdClient.zza();
            }
        }
        IOException iOException = new IOException("AdvertisingIdClient cannot reconnect.");
        throw iOException;
        Log.i((String)"AdvertisingIdClient", (String)"GMS remote exception ", (Throwable)remoteException2);
        IOException iOException2 = new IOException("Remote exception");
        throw iOException2;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Info zzd(int n) throws IOException {
        Preconditions.checkNotMainThread((String)"Calling this from your main thread can lead to deadlock");
        synchronized (this) {
            n = this.zzc ? 1 : 0;
            if (n == 0) {
                Object object = this.zzd;
                synchronized (object) {
                    boolean bl;
                    Object object2 = this.zze;
                    if (object2 == null || !(bl = ((zzb)object2).zzb)) {
                        object2 = new IOException("AdvertisingIdClient is not connected.");
                        throw object2;
                    }
                }
                this.zzb(false);
                n = this.zzc ? 1 : 0;
                if (n == 0) {
                    IOException iOException = new IOException("AdvertisingIdClient cannot reconnect.");
                    throw iOException;
                }
            }
            Preconditions.checkNotNull((Object)this.zza);
            Preconditions.checkNotNull((Object)this.zzb);
            try {
                Info info = new Info(this.zzb.zzc(), this.zzb.zze(true));
                // MONITOREXIT @DISABLED, blocks:[4, 8] lbl24 : MonitorExitStatement: MONITOREXIT : this
                this.zze();
                return info;
            }
            catch (RemoteException remoteException) {}
            catch (Exception exception) {
                IOException iOException = new IOException("AdvertisingIdClient cannot reconnect.", exception);
                throw iOException;
            }
            Log.i((String)"AdvertisingIdClient", (String)"GMS remote exception ", (Throwable)remoteException);
            IOException iOException = new IOException("Remote exception");
            throw iOException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zza() {
        Preconditions.checkNotMainThread((String)"Calling this from your main thread can lead to deadlock");
        synchronized (this) {
            Context context = this.zzg;
            if (context == null || (context = this.zza) == null) {
                return;
            }
            try {
                boolean bl = this.zzc;
                if (bl) {
                    ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
                    Context context2 = this.zzg;
                    BlockingServiceConnection blockingServiceConnection = this.zza;
                    connectionTracker.unbindService(context2, (ServiceConnection)blockingServiceConnection);
                }
            }
            catch (Throwable throwable) {
                Log.i((String)"AdvertisingIdClient", (String)"AdvertisingIdClient unbindService failed.", (Throwable)throwable);
            }
            this.zzc = false;
            this.zzb = null;
            this.zza = null;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zze() {
        Object object = this.zzd;
        synchronized (object) {
            long l;
            zzb zzb2 = this.zze;
            if (zzb2 != null) {
                zzb2.zza.countDown();
                try {
                    this.zze.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            if ((l = this.zzf) > 0L) {
                this.zze = zzb2 = new zzb(this, l);
            }
            return;
        }
    }

    /*
     * Exception decompiling
     */
    @VisibleForTesting
    protected final void zzb(boolean var1_1) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 8[TRYBLOCK] [14 : 167->179)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    final boolean zzc(@Nullable Info object, boolean bl, float f, long l, String string, @Nullable Throwable throwable) {
        if (Math.random() > 0.0) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("app_context", "1");
        if (object != null) {
            String string2 = true != ((Info)object).isLimitAdTrackingEnabled() ? "0" : "1";
            hashMap.put("limit_ad_tracking", string2);
            object = ((Info)object).getId();
            if (object != null) {
                hashMap.put("ad_id_size", Integer.toString(((String)object).length()));
            }
        }
        if (throwable != null) {
            hashMap.put("error", throwable.getClass().getName());
        }
        hashMap.put("tag", "AdvertisingIdClient");
        hashMap.put("time_spent", Long.toString(l));
        object = new zza(this, hashMap);
        ((Thread)object).start();
        return true;
    }

    @KeepForSdkWithMembers
    public static final class Info {
        @Nullable
        private final String zza;
        private final boolean zzb;

        @RecentlyNullable
        public String getId() {
            return this.zza;
        }

        @RecentlyNonNull
        public String toString() {
            String string = this.zza;
            boolean bl = this.zzb;
            String string2 = String.valueOf(string);
            int n = string2.length();
            StringBuilder stringBuilder = new StringBuilder(n + 7);
            stringBuilder.append("{");
            stringBuilder.append(string);
            stringBuilder.append("}");
            stringBuilder.append(bl);
            return stringBuilder.toString();
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public Info(@Nullable String advertisingId, boolean limitAdTrackingEnabled) {
            void var2_2;
            void var1_1;
            this.zza = var1_1;
            this.zzb = var2_2;
        }

        public boolean isLimitAdTrackingEnabled() {
            return this.zzb;
        }
    }
}

