/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.view.View;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAdView;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.ads.mediation.MediationNativeAdapter;
import com.google.android.gms.ads.mediation.MediationNativeListener;
import com.google.android.gms.ads.mediation.NativeAppInstallAdMapper;
import com.google.android.gms.ads.mediation.NativeContentAdMapper;
import com.google.android.gms.ads.mediation.NativeMediationAdRequest;
import com.google.android.gms.ads.reward.RewardItem;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdAdapter;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdListener;
import com.google.android.gms.internal.zzdx;
import com.google.android.gms.internal.zzel;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzqf;
import com.google.android.gms.internal.zzrj;
import java.util.Date;
import java.util.Set;

@zzme
public abstract class AbstractAdViewAdapter
implements MediationBannerAdapter,
MediationNativeAdapter,
MediationRewardedVideoAdAdapter,
zzrj {
    public static final String AD_UNIT_ID_PARAMETER = "pubid";
    protected AdView zzcD;
    protected InterstitialAd zzcE;
    private AdLoader zzcF;
    private Context zzcG;
    private InterstitialAd zzcH;
    private MediationRewardedVideoAdListener zzcI;
    final RewardedVideoAdListener zzcJ = new RewardedVideoAdListener(){

        @Override
        public void onRewardedVideoAdLoaded() {
            AbstractAdViewAdapter.this.zzcI.onAdLoaded(AbstractAdViewAdapter.this);
        }

        @Override
        public void onRewardedVideoAdOpened() {
            AbstractAdViewAdapter.this.zzcI.onAdOpened(AbstractAdViewAdapter.this);
        }

        @Override
        public void onRewardedVideoStarted() {
            AbstractAdViewAdapter.this.zzcI.onVideoStarted(AbstractAdViewAdapter.this);
        }

        @Override
        public void onRewardedVideoAdClosed() {
            AbstractAdViewAdapter.this.zzcI.onAdClosed(AbstractAdViewAdapter.this);
            AbstractAdViewAdapter.this.zzcH = null;
        }

        @Override
        public void onRewarded(RewardItem rewardItem) {
            AbstractAdViewAdapter.this.zzcI.onRewarded(AbstractAdViewAdapter.this, rewardItem);
        }

        @Override
        public void onRewardedVideoAdLeftApplication() {
            AbstractAdViewAdapter.this.zzcI.onAdLeftApplication(AbstractAdViewAdapter.this);
        }

        @Override
        public void onRewardedVideoAdFailedToLoad(int n) {
            AbstractAdViewAdapter.this.zzcI.onAdFailedToLoad(AbstractAdViewAdapter.this, n);
        }
    };

    protected abstract Bundle zza(Bundle var1, Bundle var2);

    AdRequest zza(Context context, MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle2) {
        String string;
        Location location;
        Set<String> set;
        int n;
        AdRequest.Builder builder = new AdRequest.Builder();
        Date date = mediationAdRequest.getBirthday();
        if (date != null) {
            builder.setBirthday(date);
        }
        if ((n = mediationAdRequest.getGender()) != 0) {
            builder.setGender(n);
        }
        if ((set = mediationAdRequest.getKeywords()) != null) {
            location = set.iterator();
            while (location.hasNext()) {
                string = (String)location.next();
                builder.addKeyword(string);
            }
        }
        if ((location = mediationAdRequest.getLocation()) != null) {
            builder.setLocation(location);
        }
        if (mediationAdRequest.isTesting()) {
            builder.addTestDevice(zzel.zzeT().zzad(context));
        }
        if (mediationAdRequest.taggedForChildDirectedTreatment() != -1) {
            builder.tagForChildDirectedTreatment(mediationAdRequest.taggedForChildDirectedTreatment() == 1);
        }
        builder.setIsDesignedForFamilies(mediationAdRequest.isDesignedForFamilies());
        string = this.zza(bundle, bundle2);
        builder.addNetworkExtrasBundle(AdMobAdapter.class, (Bundle)string);
        return builder.build();
    }

    @Override
    public void onDestroy() {
        if (this.zzcD != null) {
            this.zzcD.destroy();
            this.zzcD = null;
        }
        if (this.zzcE != null) {
            this.zzcE = null;
        }
        if (this.zzcF != null) {
            this.zzcF = null;
        }
        if (this.zzcH != null) {
            this.zzcH = null;
        }
    }

    @Override
    public void onPause() {
        if (this.zzcD != null) {
            this.zzcD.pause();
        }
    }

    @Override
    public void onResume() {
        if (this.zzcD != null) {
            this.zzcD.resume();
        }
    }

    public String getAdUnitId(Bundle bundle) {
        return bundle.getString(AD_UNIT_ID_PARAMETER);
    }

    @Override
    public void requestBannerAd(Context context, MediationBannerListener mediationBannerListener, Bundle bundle, AdSize adSize, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zzcD = new AdView(context);
        this.zzcD.setAdSize(new AdSize(adSize.getWidth(), adSize.getHeight()));
        this.zzcD.setAdUnitId(this.getAdUnitId(bundle));
        this.zzcD.setAdListener(new zzc(this, mediationBannerListener));
        this.zzcD.loadAd(this.zza(context, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public View getBannerView() {
        return this.zzcD;
    }

    @Override
    public void requestInterstitialAd(Context context, MediationInterstitialListener mediationInterstitialListener, Bundle bundle, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zzcE = new InterstitialAd(context);
        this.zzcE.setAdUnitId(this.getAdUnitId(bundle));
        this.zzcE.setAdListener(new zzd(this, mediationInterstitialListener));
        this.zzcE.loadAd(this.zza(context, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public void showInterstitial() {
        this.zzcE.show();
    }

    @Override
    public Bundle getInterstitialAdapterInfo() {
        return new MediationAdapter.zza().zzam(1).zzmm();
    }

    @Override
    public void requestNativeAd(Context context, MediationNativeListener mediationNativeListener, Bundle bundle, NativeMediationAdRequest nativeMediationAdRequest, Bundle bundle2) {
        zze zze2 = new zze(this, mediationNativeListener);
        AdLoader.Builder builder = this.zza(context, bundle.getString(AD_UNIT_ID_PARAMETER)).withAdListener(zze2);
        NativeAdOptions nativeAdOptions = nativeMediationAdRequest.getNativeAdOptions();
        if (nativeAdOptions != null) {
            builder.withNativeAdOptions(nativeAdOptions);
        }
        if (nativeMediationAdRequest.isAppInstallAdRequested()) {
            builder.forAppInstallAd(zze2);
        }
        if (nativeMediationAdRequest.isContentAdRequested()) {
            builder.forContentAd(zze2);
        }
        this.zzcF = builder.build();
        this.zzcF.loadAd(this.zza(context, nativeMediationAdRequest, bundle2, bundle));
    }

    AdLoader.Builder zza(Context context, String string) {
        return new AdLoader.Builder(context, string);
    }

    @Override
    public void initialize(Context context, MediationAdRequest mediationAdRequest, String string, MediationRewardedVideoAdListener mediationRewardedVideoAdListener, Bundle bundle, Bundle bundle2) {
        this.zzcG = context.getApplicationContext();
        this.zzcI = mediationRewardedVideoAdListener;
        this.zzcI.onInitializationSucceeded(this);
    }

    @Override
    public void loadAd(MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle2) {
        if (this.zzcG == null || this.zzcI == null) {
            zzqf.e("AdMobAdapter.loadAd called before initialize.");
            return;
        }
        this.zzcH = new InterstitialAd(this.zzcG);
        this.zzcH.zzd(true);
        this.zzcH.setAdUnitId(this.getAdUnitId(bundle));
        this.zzcH.setRewardedVideoAdListener(this.zzcJ);
        this.zzcH.loadAd(this.zza(this.zzcG, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public void showVideo() {
        this.zzcH.show();
    }

    @Override
    public boolean isInitialized() {
        return this.zzcI != null;
    }

    static class zzb
    extends NativeContentAdMapper {
        private final NativeContentAd zzcM;

        public zzb(NativeContentAd nativeContentAd) {
            this.zzcM = nativeContentAd;
            this.setHeadline(nativeContentAd.getHeadline().toString());
            this.setImages(nativeContentAd.getImages());
            this.setBody(nativeContentAd.getBody().toString());
            if (nativeContentAd.getLogo() != null) {
                this.setLogo(nativeContentAd.getLogo());
            }
            this.setCallToAction(nativeContentAd.getCallToAction().toString());
            this.setAdvertiser(nativeContentAd.getAdvertiser().toString());
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
            this.zza(nativeContentAd.getVideoController());
        }

        @Override
        public void trackView(View view) {
            if (view instanceof NativeAdView) {
                ((NativeAdView)view).setNativeAd(this.zzcM);
            }
        }
    }

    static class zza
    extends NativeAppInstallAdMapper {
        private final NativeAppInstallAd zzcL;

        public zza(NativeAppInstallAd nativeAppInstallAd) {
            this.zzcL = nativeAppInstallAd;
            this.setHeadline(nativeAppInstallAd.getHeadline().toString());
            this.setImages(nativeAppInstallAd.getImages());
            this.setBody(nativeAppInstallAd.getBody().toString());
            this.setIcon(nativeAppInstallAd.getIcon());
            this.setCallToAction(nativeAppInstallAd.getCallToAction().toString());
            if (nativeAppInstallAd.getStarRating() != null) {
                this.setStarRating(nativeAppInstallAd.getStarRating());
            }
            if (nativeAppInstallAd.getStore() != null) {
                this.setStore(nativeAppInstallAd.getStore().toString());
            }
            if (nativeAppInstallAd.getPrice() != null) {
                this.setPrice(nativeAppInstallAd.getPrice().toString());
            }
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
            this.zza(nativeAppInstallAd.getVideoController());
        }

        @Override
        public void trackView(View view) {
            if (view instanceof NativeAdView) {
                ((NativeAdView)view).setNativeAd(this.zzcL);
            }
        }
    }

    static final class zze
    extends AdListener
    implements NativeAppInstallAd.OnAppInstallAdLoadedListener,
    NativeContentAd.OnContentAdLoadedListener,
    zzdx {
        final AbstractAdViewAdapter zzcN;
        final MediationNativeListener zzcQ;

        public zze(AbstractAdViewAdapter abstractAdViewAdapter, MediationNativeListener mediationNativeListener) {
            this.zzcN = abstractAdViewAdapter;
            this.zzcQ = mediationNativeListener;
        }

        @Override
        public void onAdLoaded() {
        }

        @Override
        public void onAdFailedToLoad(int n) {
            this.zzcQ.onAdFailedToLoad(this.zzcN, n);
        }

        @Override
        public void onAdOpened() {
            this.zzcQ.onAdOpened(this.zzcN);
        }

        @Override
        public void onAdClosed() {
            this.zzcQ.onAdClosed(this.zzcN);
        }

        @Override
        public void onAdLeftApplication() {
            this.zzcQ.onAdLeftApplication(this.zzcN);
        }

        @Override
        public void onAdClicked() {
            this.zzcQ.onAdClicked(this.zzcN);
        }

        @Override
        public void onAppInstallAdLoaded(NativeAppInstallAd nativeAppInstallAd) {
            this.zzcQ.onAdLoaded(this.zzcN, new zza(nativeAppInstallAd));
        }

        @Override
        public void onContentAdLoaded(NativeContentAd nativeContentAd) {
            this.zzcQ.onAdLoaded(this.zzcN, new zzb(nativeContentAd));
        }
    }

    static final class zzd
    extends AdListener
    implements zzdx {
        final AbstractAdViewAdapter zzcN;
        final MediationInterstitialListener zzcP;

        public zzd(AbstractAdViewAdapter abstractAdViewAdapter, MediationInterstitialListener mediationInterstitialListener) {
            this.zzcN = abstractAdViewAdapter;
            this.zzcP = mediationInterstitialListener;
        }

        @Override
        public void onAdLoaded() {
            this.zzcP.onAdLoaded(this.zzcN);
        }

        @Override
        public void onAdFailedToLoad(int n) {
            this.zzcP.onAdFailedToLoad(this.zzcN, n);
        }

        @Override
        public void onAdOpened() {
            this.zzcP.onAdOpened(this.zzcN);
        }

        @Override
        public void onAdClosed() {
            this.zzcP.onAdClosed(this.zzcN);
        }

        @Override
        public void onAdLeftApplication() {
            this.zzcP.onAdLeftApplication(this.zzcN);
        }

        @Override
        public void onAdClicked() {
            this.zzcP.onAdClicked(this.zzcN);
        }
    }

    static final class zzc
    extends AdListener
    implements zzdx {
        final AbstractAdViewAdapter zzcN;
        final MediationBannerListener zzcO;

        public zzc(AbstractAdViewAdapter abstractAdViewAdapter, MediationBannerListener mediationBannerListener) {
            this.zzcN = abstractAdViewAdapter;
            this.zzcO = mediationBannerListener;
        }

        @Override
        public void onAdLoaded() {
            this.zzcO.onAdLoaded(this.zzcN);
        }

        @Override
        public void onAdFailedToLoad(int n) {
            this.zzcO.onAdFailedToLoad(this.zzcN, n);
        }

        @Override
        public void onAdOpened() {
            this.zzcO.onAdOpened(this.zzcN);
        }

        @Override
        public void onAdClosed() {
            this.zzcO.onAdClosed(this.zzcN);
        }

        @Override
        public void onAdLeftApplication() {
            this.zzcO.onAdLeftApplication(this.zzcN);
        }

        @Override
        public void onAdClicked() {
            this.zzcO.onAdClicked(this.zzcN);
        }
    }
}

