/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.doubleclick;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.NetworkExtras;
import com.google.android.gms.ads.mediation.customevent.CustomEvent;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzfe;
import java.util.Date;
import java.util.List;
import java.util.Set;

public final class PublisherAdRequest {
    public static final int ERROR_CODE_INTERNAL_ERROR = 0;
    public static final int ERROR_CODE_INVALID_REQUEST = 1;
    public static final int ERROR_CODE_NETWORK_ERROR = 2;
    public static final int ERROR_CODE_NO_FILL = 3;
    public static final int GENDER_UNKNOWN = 0;
    public static final int GENDER_MALE = 1;
    public static final int GENDER_FEMALE = 2;
    public static final String DEVICE_ID_EMULATOR = "B3EEABB8EE11C2BE770B684D95219ECB";
    private final zzfe zzrz;

    private PublisherAdRequest(Builder builder) {
        this.zzrz = new zzfe(builder.zzrA);
    }

    public Date getBirthday() {
        return this.zzrz.getBirthday();
    }

    public String getContentUrl() {
        return this.zzrz.getContentUrl();
    }

    public int getGender() {
        return this.zzrz.getGender();
    }

    public Set<String> getKeywords() {
        return this.zzrz.getKeywords();
    }

    public Location getLocation() {
        return this.zzrz.getLocation();
    }

    public boolean getManualImpressionsEnabled() {
        return this.zzrz.getManualImpressionsEnabled();
    }

    @Deprecated
    public <T extends NetworkExtras> T getNetworkExtras(Class<T> clazz) {
        return this.zzrz.getNetworkExtras(clazz);
    }

    public <T extends MediationAdapter> Bundle getNetworkExtrasBundle(Class<T> clazz) {
        return this.zzrz.getNetworkExtrasBundle(clazz);
    }

    public <T extends CustomEvent> Bundle getCustomEventExtrasBundle(Class<T> clazz) {
        return this.zzrz.getCustomEventExtrasBundle(clazz);
    }

    public String getPublisherProvidedId() {
        return this.zzrz.getPublisherProvidedId();
    }

    public boolean isTestDevice(Context context) {
        return this.zzrz.isTestDevice(context);
    }

    public Bundle getCustomTargeting() {
        return this.zzrz.getCustomTargeting();
    }

    public static void updateCorrelator() {
    }

    public zzfe zzbp() {
        return this.zzrz;
    }

    public static final class Builder {
        private final zzfe.zza zzrA = new zzfe.zza();

        public Builder addKeyword(String string) {
            this.zzrA.zzL(string);
            return this;
        }

        public Builder addNetworkExtras(NetworkExtras networkExtras) {
            this.zzrA.zza(networkExtras);
            return this;
        }

        public Builder addNetworkExtrasBundle(Class<? extends MediationAdapter> clazz, Bundle bundle) {
            this.zzrA.zza(clazz, bundle);
            return this;
        }

        public Builder addCustomEventExtrasBundle(Class<? extends CustomEvent> clazz, Bundle bundle) {
            this.zzrA.zzb(clazz, bundle);
            return this;
        }

        public Builder addTestDevice(String string) {
            this.zzrA.zzM(string);
            return this;
        }

        public PublisherAdRequest build() {
            return new PublisherAdRequest(this);
        }

        public Builder setBirthday(Date date) {
            this.zzrA.zza(date);
            return this;
        }

        public Builder setContentUrl(String string) {
            zzac.zzb((Object)string, (Object)"Content URL must be non-null.");
            zzac.zzh((String)string, (Object)"Content URL must be non-empty.");
            zzac.zzb((string.length() <= 512 ? 1 : 0) != 0, (String)"Content URL must not exceed %d in length.  Provided length was %d.", (Object[])new Object[]{512, string.length()});
            this.zzrA.zzO(string);
            return this;
        }

        public Builder setGender(int n) {
            this.zzrA.zzy(n);
            return this;
        }

        public Builder setLocation(Location location) {
            this.zzrA.zzb(location);
            return this;
        }

        @Deprecated
        public Builder setManualImpressionsEnabled(boolean bl) {
            this.zzrA.setManualImpressionsEnabled(bl);
            return this;
        }

        public Builder setPublisherProvidedId(String string) {
            this.zzrA.zzP(string);
            return this;
        }

        public Builder setRequestAgent(String string) {
            this.zzrA.zzQ(string);
            return this;
        }

        public Builder tagForChildDirectedTreatment(boolean bl) {
            this.zzrA.zzn(bl);
            return this;
        }

        public Builder addCustomTargeting(String string, String string2) {
            this.zzrA.zzf(string, string2);
            return this;
        }

        public Builder addCustomTargeting(String string, List<String> list) {
            if (list != null) {
                this.zzrA.zzf(string, TextUtils.join((CharSequence)",", list));
            }
            return this;
        }

        public Builder addCategoryExclusion(String string) {
            this.zzrA.zzR(string);
            return this;
        }

        public Builder setIsDesignedForFamilies(boolean bl) {
            this.zzrA.zzo(bl);
            return this;
        }
    }
}

