/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.widget.FrameLayout;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.internal.zzea;
import com.google.android.gms.internal.zzeb;
import com.google.android.gms.internal.zzeg;
import com.google.android.gms.internal.zzel;
import com.google.android.gms.internal.zzer;
import com.google.android.gms.internal.zzet;
import com.google.android.gms.internal.zzew;
import com.google.android.gms.internal.zzey;
import com.google.android.gms.internal.zzfj;
import com.google.android.gms.internal.zzfk;
import com.google.android.gms.internal.zzfl;
import com.google.android.gms.internal.zzfm;
import com.google.android.gms.internal.zzfn;
import com.google.android.gms.internal.zzfo;
import com.google.android.gms.internal.zzhh;
import com.google.android.gms.internal.zzht;
import com.google.android.gms.internal.zzka;
import com.google.android.gms.internal.zzky;
import com.google.android.gms.internal.zzkz;
import com.google.android.gms.internal.zzlf;
import com.google.android.gms.internal.zzlk;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zznu;
import com.google.android.gms.internal.zzny;
import com.google.android.gms.internal.zzqf;

@zzme
public class zzek {
    private zzew zzzG;
    private final Object zzrJ = new Object();
    private final zzeb zzzH;
    private final zzea zzzI;
    private final zzfj zzzJ;
    private final zzht zzzK;
    private final zzny zzzL;
    private final zzlk zzzM;
    private final zzky zzzN;

    public zzek(zzeb zzeb2, zzea zzea2, zzfj zzfj2, zzht zzht2, zzny zzny2, zzlk zzlk2, zzky zzky2) {
        this.zzzH = zzeb2;
        this.zzzI = zzea2;
        this.zzzJ = zzfj2;
        this.zzzK = zzht2;
        this.zzzL = zzny2;
        this.zzzM = zzlk2;
        this.zzzN = zzky2;
    }

    @Nullable
    private static zzew zzeG() {
        try {
            Object obj = zzek.class.getClassLoader().loadClass("com.google.android.gms.ads.internal.ClientApi").newInstance();
            if (!(obj instanceof IBinder)) {
                zzqf.zzbh("ClientApi class is not an instance of IBinder");
                return null;
            }
            return zzew.zza.asInterface((IBinder)obj);
        }
        catch (Exception exception) {
            zzqf.zzc("Failed to instantiate ClientApi class.", exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private zzew zzeH() {
        Object object = this.zzrJ;
        synchronized (object) {
            if (this.zzzG == null) {
                this.zzzG = zzek.zzeG();
            }
            return this.zzzG;
        }
    }

    @VisibleForTesting
    <T> T zza(Context context, boolean bl, zza<T> zza2) {
        T t;
        if (!bl && !zzel.zzeT().zzaf(context)) {
            zzqf.zzbf("Google Play Services is not available");
            bl = true;
        }
        if (bl) {
            t = zza2.zzeQ();
            if (t == null) {
                t = zza2.zzeR();
            }
        } else {
            t = zza2.zzeR();
            if (t == null) {
                t = zza2.zzeQ();
            }
        }
        return t;
    }

    private void zzc(Context context, String string) {
        Bundle bundle = new Bundle();
        bundle.putString("action", "no_ads_fallback");
        bundle.putString("flow", string);
        zzel.zzeT().zza(context, null, "gmob-apps", bundle, true);
    }

    public zzet zza(final Context context, final zzeg zzeg2, final String string, final zzka zzka2) {
        return this.zza(context, false, new zza<zzet>(){

            public zzet zza(zzew zzew2) throws RemoteException {
                return zzew2.createBannerAdManager(zzd.zzA((Object)context), zzeg2, string, zzka2, 10260000);
            }

            public zzet zzeI() {
                zzet zzet2 = zzek.this.zzzH.zza(context, zzeg2, string, zzka2, 1);
                if (zzet2 != null) {
                    return zzet2;
                }
                zzek.this.zzc(context, "banner");
                return new zzfl();
            }

            @Override
            public /* synthetic */ Object zzeJ() throws RemoteException {
                return this.zzeI();
            }

            @Override
            public /* synthetic */ Object zzb(zzew zzew2) throws RemoteException {
                return this.zza(zzew2);
            }
        });
    }

    public zzet zza(final Context context, final zzeg zzeg2, final String string) {
        return this.zza(context, false, new zza<zzet>(){

            public zzet zza(zzew zzew2) throws RemoteException {
                return zzew2.createSearchAdManager(zzd.zzA((Object)context), zzeg2, string, 10260000);
            }

            public zzet zzeI() {
                zzet zzet2 = zzek.this.zzzH.zza(context, zzeg2, string, null, 3);
                if (zzet2 != null) {
                    return zzet2;
                }
                zzek.this.zzc(context, "search");
                return new zzfl();
            }

            @Override
            public /* synthetic */ Object zzeJ() throws RemoteException {
                return this.zzeI();
            }

            @Override
            public /* synthetic */ Object zzb(zzew zzew2) throws RemoteException {
                return this.zza(zzew2);
            }
        });
    }

    public zzet zzb(final Context context, final zzeg zzeg2, final String string, final zzka zzka2) {
        return this.zza(context, false, new zza<zzet>(){

            public zzet zza(zzew zzew2) throws RemoteException {
                return zzew2.createInterstitialAdManager(zzd.zzA((Object)context), zzeg2, string, zzka2, 10260000);
            }

            public zzet zzeI() {
                zzet zzet2 = zzek.this.zzzH.zza(context, zzeg2, string, zzka2, 2);
                if (zzet2 != null) {
                    return zzet2;
                }
                zzek.this.zzc(context, "interstitial");
                return new zzfl();
            }

            @Override
            public /* synthetic */ Object zzeJ() throws RemoteException {
                return this.zzeI();
            }

            @Override
            public /* synthetic */ Object zzb(zzew zzew2) throws RemoteException {
                return this.zza(zzew2);
            }
        });
    }

    public zzer zzb(final Context context, final String string, final zzka zzka2) {
        return this.zza(context, false, new zza<zzer>(){

            public zzer zzc(zzew zzew2) throws RemoteException {
                return zzew2.createAdLoaderBuilder(zzd.zzA((Object)context), string, zzka2, 10260000);
            }

            public zzer zzeK() {
                zzer zzer2 = zzek.this.zzzI.zza(context, string, zzka2);
                if (zzer2 != null) {
                    return zzer2;
                }
                zzek.this.zzc(context, "native_ad");
                return new zzfk();
            }

            @Override
            public /* synthetic */ Object zzeJ() throws RemoteException {
                return this.zzeK();
            }

            @Override
            public /* synthetic */ Object zzb(zzew zzew2) throws RemoteException {
                return this.zzc(zzew2);
            }
        });
    }

    public zzey zzl(final Context context) {
        return this.zza(context, false, new zza<zzey>(){

            public zzey zzd(zzew zzew2) throws RemoteException {
                return zzew2.getMobileAdsSettingsManagerWithClientJarVersion(zzd.zzA((Object)context), 10260000);
            }

            public zzey zzeL() {
                zzey zzey2 = zzek.this.zzzJ.zzm(context);
                if (zzey2 != null) {
                    return zzey2;
                }
                zzek.this.zzc(context, "mobile_ads_settings");
                return new zzfm();
            }

            @Override
            public /* synthetic */ Object zzeJ() throws RemoteException {
                return this.zzeL();
            }

            @Override
            public /* synthetic */ Object zzb(zzew zzew2) throws RemoteException {
                return this.zzd(zzew2);
            }
        });
    }

    public zzhh zza(final Context context, final FrameLayout frameLayout, final FrameLayout frameLayout2) {
        return this.zza(context, false, new zza<zzhh>(){

            public zzhh zze(zzew zzew2) throws RemoteException {
                return zzew2.createNativeAdViewDelegate(zzd.zzA((Object)frameLayout), zzd.zzA((Object)frameLayout2));
            }

            public zzhh zzeM() {
                zzhh zzhh2 = zzek.this.zzzK.zzb(context, frameLayout, frameLayout2);
                if (zzhh2 != null) {
                    return zzhh2;
                }
                zzek.this.zzc(context, "native_ad_view_delegate");
                return new zzfn();
            }

            @Override
            public /* synthetic */ Object zzeJ() throws RemoteException {
                return this.zzeM();
            }

            @Override
            public /* synthetic */ Object zzb(zzew zzew2) throws RemoteException {
                return this.zze(zzew2);
            }
        });
    }

    public zznu zza(final Context context, final zzka zzka2) {
        return this.zza(context, false, new zza<zznu>(){

            public zznu zzf(zzew zzew2) throws RemoteException {
                return zzew2.createRewardedVideoAd(zzd.zzA((Object)context), zzka2, 10260000);
            }

            public zznu zzeN() {
                zznu zznu2 = zzek.this.zzzL.zzb(context, zzka2);
                if (zznu2 != null) {
                    return zznu2;
                }
                zzek.this.zzc(context, "rewarded_video");
                return new zzfo();
            }

            @Override
            public /* synthetic */ Object zzeJ() throws RemoteException {
                return this.zzeN();
            }

            @Override
            public /* synthetic */ Object zzb(zzew zzew2) throws RemoteException {
                return this.zzf(zzew2);
            }
        });
    }

    @Nullable
    public zzlf zzb(final Activity activity) {
        boolean bl = zzek.zza(activity, "com.google.android.gms.ads.internal.purchase.useClientJar");
        return this.zza((Context)activity, bl, new zza<zzlf>(){

            public zzlf zzg(zzew zzew2) throws RemoteException {
                return zzew2.createInAppPurchaseManager(zzd.zzA((Object)activity));
            }

            public zzlf zzeO() {
                zzlf zzlf2 = zzek.this.zzzM.zzg(activity);
                if (zzlf2 != null) {
                    return zzlf2;
                }
                zzek.this.zzc((Context)activity, "iap");
                return null;
            }

            @Override
            public /* synthetic */ Object zzeJ() throws RemoteException {
                return this.zzeO();
            }

            @Override
            public /* synthetic */ Object zzb(zzew zzew2) throws RemoteException {
                return this.zzg(zzew2);
            }
        });
    }

    @Nullable
    public zzkz zzc(final Activity activity) {
        boolean bl = zzek.zza(activity, "com.google.android.gms.ads.internal.overlay.useClientJar");
        return this.zza((Context)activity, bl, new zza<zzkz>(){

            public zzkz zzh(zzew zzew2) throws RemoteException {
                return zzew2.createAdOverlay(zzd.zzA((Object)activity));
            }

            public zzkz zzeP() {
                zzkz zzkz2 = zzek.this.zzzN.zzf(activity);
                if (zzkz2 != null) {
                    return zzkz2;
                }
                zzek.this.zzc((Context)activity, "ad_overlay");
                return null;
            }

            @Override
            public /* synthetic */ Object zzeJ() throws RemoteException {
                return this.zzeP();
            }

            @Override
            public /* synthetic */ Object zzb(zzew zzew2) throws RemoteException {
                return this.zzh(zzew2);
            }
        });
    }

    private static boolean zza(Activity activity, String string) {
        Intent intent = activity.getIntent();
        if (!intent.hasExtra(string)) {
            zzqf.e("useClientJar flag not found in activity intent extras.");
            return false;
        }
        return intent.getBooleanExtra(string, false);
    }

    @VisibleForTesting
    abstract class zza<T> {
        zza() {
        }

        @Nullable
        protected abstract T zzb(zzew var1) throws RemoteException;

        @Nullable
        protected abstract T zzeJ() throws RemoteException;

        @Nullable
        protected final T zzeQ() {
            zzew zzew2 = zzek.this.zzeH();
            if (zzew2 == null) {
                zzqf.zzbh("ClientApi class cannot be loaded.");
                return null;
            }
            try {
                return this.zzb(zzew2);
            }
            catch (RemoteException remoteException) {
                zzqf.zzc("Cannot invoke local loader using ClientApi class", remoteException);
                return null;
            }
        }

        @Nullable
        protected final T zzeR() {
            try {
                return this.zzeJ();
            }
            catch (RemoteException remoteException) {
                zzqf.zzc("Cannot invoke remote loader", remoteException);
                return null;
            }
        }
    }
}

