/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.RemoteException;
import com.google.ads.mediation.AdUrlAdapter;
import com.google.ads.mediation.MediationServerParameters;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.ads.mediation.customevent.CustomEventAdapter;
import com.google.ads.mediation.customevent.CustomEventServerParameters;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.NetworkExtras;
import com.google.android.gms.ads.mediation.customevent.CustomEvent;
import com.google.android.gms.ads.mediation.customevent.CustomEventExtras;
import com.google.android.gms.internal.zzka;
import com.google.android.gms.internal.zzkb;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzkm;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzqf;
import java.util.Map;

@zzme
public final class zzjz
extends zzka.zza {
    private Map<Class<? extends NetworkExtras>, NetworkExtras> zzLA;

    @Override
    public zzkb zzas(String string) throws RemoteException {
        return this.zzau(string);
    }

    @Override
    public boolean zzat(String string) throws RemoteException {
        try {
            Class<?> clazz = Class.forName(string, false, zzjz.class.getClassLoader());
            return CustomEvent.class.isAssignableFrom(clazz);
        }
        catch (Throwable throwable) {
            zzqf.zzbh(new StringBuilder(80 + String.valueOf(string).length()).append("Could not load custom event implementation class: ").append(string).append(", assuming old implementation.").toString());
            return false;
        }
    }

    public void zzi(Map<Class<? extends NetworkExtras>, NetworkExtras> map) {
        this.zzLA = map;
    }

    private <NETWORK_EXTRAS extends com.google.ads.mediation.NetworkExtras, SERVER_PARAMETERS extends MediationServerParameters> zzkb zzau(String string) throws RemoteException {
        try {
            Class<?> clazz = Class.forName(string, false, zzjz.class.getClassLoader());
            if (com.google.ads.mediation.MediationAdapter.class.isAssignableFrom(clazz)) {
                com.google.ads.mediation.MediationAdapter mediationAdapter = (com.google.ads.mediation.MediationAdapter)clazz.newInstance();
                com.google.ads.mediation.NetworkExtras networkExtras = (com.google.ads.mediation.NetworkExtras)this.zzLA.get(mediationAdapter.getAdditionalParametersType());
                return new zzkm(mediationAdapter, networkExtras);
            }
            if (MediationAdapter.class.isAssignableFrom(clazz)) {
                MediationAdapter mediationAdapter = (MediationAdapter)clazz.newInstance();
                return new zzkh(mediationAdapter);
            }
            zzqf.zzbh(new StringBuilder(64 + String.valueOf(string).length()).append("Could not instantiate mediation adapter: ").append(string).append(" (not a valid adapter).").toString());
            throw new RemoteException();
        }
        catch (Throwable throwable) {
            return this.zzav(string);
        }
    }

    private zzkb zzav(String string) throws RemoteException {
        try {
            zzqf.zzbf("Reflection failed, retrying using direct instantiation");
            if ("com.google.ads.mediation.admob.AdMobAdapter".equals(string)) {
                return new zzkh(new AdMobAdapter());
            }
            if ("com.google.ads.mediation.AdUrlAdapter".equals(string)) {
                return new zzkh(new AdUrlAdapter());
            }
            if ("com.google.android.gms.ads.mediation.customevent.CustomEventAdapter".equals(string)) {
                return new zzkh(new com.google.android.gms.ads.mediation.customevent.CustomEventAdapter());
            }
            if ("com.google.ads.mediation.customevent.CustomEventAdapter".equals(string)) {
                CustomEventAdapter customEventAdapter = new CustomEventAdapter();
                CustomEventExtras customEventExtras = (CustomEventExtras)this.zzLA.get(customEventAdapter.getAdditionalParametersType());
                return new zzkm<CustomEventExtras, CustomEventServerParameters>(customEventAdapter, customEventExtras);
            }
        }
        catch (Throwable throwable) {
            zzqf.zzc(new StringBuilder(43 + String.valueOf(string).length()).append("Could not instantiate mediation adapter: ").append(string).append(". ").toString(), throwable);
        }
        throw new RemoteException();
    }
}

