/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.doubleclick.PublisherAdView;
import com.google.android.gms.ads.doubleclick.PublisherInterstitialAd;
import com.google.android.gms.ads.search.SearchAdView;
import com.google.android.gms.common.util.zzt;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzeg;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzqf;
import com.google.android.gms.internal.zzqg;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.StringTokenizer;

@zzme
public class zzqe {
    public static final Handler zzYP = new Handler(Looper.getMainLooper());
    private static final String zzYQ = AdView.class.getName();
    private static final String zzYR = InterstitialAd.class.getName();
    private static final String zzYS = PublisherAdView.class.getName();
    private static final String zzYT = PublisherInterstitialAd.class.getName();
    private static final String zzYU = SearchAdView.class.getName();
    private static final String zzYV = AdLoader.class.getName();

    public void zza(boolean bl, HttpURLConnection httpURLConnection, @Nullable String string) {
        httpURLConnection.setConnectTimeout(60000);
        httpURLConnection.setInstanceFollowRedirects(bl);
        httpURLConnection.setReadTimeout(60000);
        if (string != null) {
            httpURLConnection.setRequestProperty("User-Agent", string);
        }
        httpURLConnection.setUseCaches(false);
    }

    public int zzb(Context context, int n) {
        return this.zza(context.getResources().getDisplayMetrics(), n);
    }

    public int zza(DisplayMetrics displayMetrics, int n) {
        return (int)TypedValue.applyDimension((int)1, (float)n, (DisplayMetrics)displayMetrics);
    }

    public int zzc(Context context, int n) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getMetrics(displayMetrics);
        return this.zzb(displayMetrics, n);
    }

    public int zzb(DisplayMetrics displayMetrics, int n) {
        return Math.round((float)n / displayMetrics.density);
    }

    public void zza(ViewGroup viewGroup, zzeg zzeg2, String string, String string2) {
        zzqf.zzbh(string2);
        this.zza(viewGroup, zzeg2, string, -65536, -16777216);
    }

    public void zza(ViewGroup viewGroup, zzeg zzeg2, String string) {
        this.zza(viewGroup, zzeg2, string, -16777216, -1);
    }

    private void zza(ViewGroup viewGroup, zzeg zzeg2, String string, int n, int n2) {
        if (viewGroup.getChildCount() != 0) {
            return;
        }
        Context context = viewGroup.getContext();
        TextView textView = new TextView(context);
        textView.setGravity(17);
        textView.setText((CharSequence)string);
        textView.setTextColor(n);
        textView.setBackgroundColor(n2);
        FrameLayout frameLayout = new FrameLayout(context);
        frameLayout.setBackgroundColor(n);
        int n3 = this.zzb(context, 3);
        frameLayout.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(zzeg2.widthPixels - n3, zzeg2.heightPixels - n3, 17));
        viewGroup.addView((View)frameLayout, zzeg2.widthPixels, zzeg2.heightPixels);
    }

    public String zzad(Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        String string = contentResolver == null ? null : Settings.Secure.getString((ContentResolver)contentResolver, (String)"android_id");
        return this.zzbe(string == null || this.zzli() ? "emulator" : string);
    }

    @Nullable
    public String zzae(Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        return contentResolver == null ? null : Settings.Secure.getString((ContentResolver)contentResolver, (String)"android_id");
    }

    public boolean zzli() {
        return Build.DEVICE.startsWith("generic");
    }

    public boolean zzlj() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public String zzbe(String string) {
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                messageDigest.update(string.getBytes());
                return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest()));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                continue;
            }
        }
        return null;
    }

    public boolean zzaf(Context context) {
        return 0 == zze.zzuY().isGooglePlayServicesAvailable(context);
    }

    public boolean zzag(Context context) {
        int n = zze.zzuY().isGooglePlayServicesAvailable(context);
        return n == 0 || n == 2;
    }

    public boolean zzah(Context context) {
        if (context.getResources().getConfiguration().orientation != 2) {
            return false;
        }
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return (int)((float)displayMetrics.heightPixels / displayMetrics.density) < 600;
    }

    @TargetApi(value=17)
    public boolean zzai(Context context) {
        int n;
        int n2;
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        if (zzt.zzzj()) {
            display.getRealMetrics(displayMetrics);
            n2 = displayMetrics.heightPixels;
            n = displayMetrics.widthPixels;
        } else {
            try {
                n2 = (Integer)Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)display, new Object[0]);
                n = (Integer)Display.class.getMethod("getRawWidth", new Class[0]).invoke((Object)display, new Object[0]);
            }
            catch (Exception exception) {
                return false;
            }
        }
        display.getMetrics(displayMetrics);
        int n3 = displayMetrics.heightPixels;
        int n4 = displayMetrics.widthPixels;
        return n3 == n2 && n4 == n;
    }

    public int zzaj(Context context) {
        int n = context.getResources().getIdentifier("navigation_bar_width", "dimen", "android");
        if (n > 0) {
            return context.getResources().getDimensionPixelSize(n);
        }
        return 0;
    }

    @Nullable
    public String zza(StackTraceElement[] stackTraceElementArray, String string) {
        String string2 = null;
        int n = 0;
        while (n + 1 < stackTraceElementArray.length) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n];
            String string3 = stackTraceElement.getClassName();
            String string4 = stackTraceElement.getMethodName();
            if ("loadAd".equalsIgnoreCase(string4) && (zzYQ.equalsIgnoreCase(string3) || zzYR.equalsIgnoreCase(string3) || zzYS.equalsIgnoreCase(string3) || zzYT.equalsIgnoreCase(string3) || zzYU.equalsIgnoreCase(string3) || zzYV.equalsIgnoreCase(string3))) {
                string2 = stackTraceElementArray[n + 1].getClassName();
                break;
            }
            ++n;
        }
        if (string != null) {
            String string5 = this.zzb(string, ".", 3);
            if (string2 != null && !string2.contains(string5)) {
                return string2;
            }
        }
        return null;
    }

    String zzb(String string, String string2, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        StringBuilder stringBuilder = new StringBuilder();
        if (n-- > 0 && stringTokenizer.hasMoreElements()) {
            stringBuilder.append(stringTokenizer.nextToken());
        } else {
            return string;
        }
        while (n-- > 0 && stringTokenizer.hasMoreElements()) {
            stringBuilder.append(".").append(stringTokenizer.nextToken());
        }
        return stringBuilder.toString();
    }

    public void zza(Context context, @Nullable String string, String string2, Bundle bundle, boolean bl) {
        this.zza(context, string, string2, bundle, bl, new zza(this){

            @Override
            public void zzu(final String string) {
                new Thread(this){

                    @Override
                    public void run() {
                        new zzqg().zzu(string);
                    }
                }.start();
            }
        });
    }

    public void zza(Context context, @Nullable String string, String string2, Bundle bundle, boolean bl, zza zza2) {
        Context context2;
        if (bl) {
            context2 = context.getApplicationContext();
            if (context2 == null) {
                context2 = context;
            }
            bundle.putString("os", Build.VERSION.RELEASE);
            bundle.putString("api", String.valueOf(Build.VERSION.SDK_INT));
            bundle.putString("appid", context2.getPackageName());
            if (string == null) {
                int n = zze.zzuY().zzaC(context);
                string = new StringBuilder(23).append(n).append(".").append(10260000).toString();
            }
            bundle.putString("js", string);
        }
        context2 = new Uri.Builder().scheme("https").path("//pagead2.googlesyndication.com/pagead/gen_204").appendQueryParameter("id", string2);
        for (String string3 : bundle.keySet()) {
            context2.appendQueryParameter(string3, bundle.getString(string3));
        }
        zza2.zzu(context2.toString());
    }

    public static interface zza {
        public void zzu(String var1);
    }
}

