/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.NetworkExtras;
import com.google.android.gms.ads.mediation.customevent.CustomEvent;
import com.google.android.gms.ads.zza;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.internal.zzla;
import com.google.android.gms.internal.zzlb;
import java.util.Date;
import java.util.Set;

public final class AdRequest {
    public static final int ERROR_CODE_INTERNAL_ERROR = 0;
    public static final int ERROR_CODE_INVALID_REQUEST = 1;
    public static final int ERROR_CODE_NETWORK_ERROR = 2;
    public static final int ERROR_CODE_NO_FILL = 3;
    public static final int GENDER_UNKNOWN = 0;
    public static final int GENDER_MALE = 1;
    public static final int GENDER_FEMALE = 2;
    public static final int MAX_CONTENT_URL_LENGTH = 512;
    public static final String DEVICE_ID_EMULATOR = "B3EEABB8EE11C2BE770B684D95219ECB";
    private final zzla zzrW;

    private AdRequest(Builder builder) {
        this.zzrW = new zzla(builder.zzrX);
    }

    public final Date getBirthday() {
        return this.zzrW.getBirthday();
    }

    public final String getContentUrl() {
        return this.zzrW.getContentUrl();
    }

    public final int getGender() {
        return this.zzrW.getGender();
    }

    public final Set<String> getKeywords() {
        return this.zzrW.getKeywords();
    }

    public final Location getLocation() {
        return this.zzrW.getLocation();
    }

    @Deprecated
    public final <T extends NetworkExtras> T getNetworkExtras(Class<T> clazz) {
        return this.zzrW.getNetworkExtras(clazz);
    }

    public final <T extends MediationAdapter> Bundle getNetworkExtrasBundle(Class<T> clazz) {
        return this.zzrW.getNetworkExtrasBundle(clazz);
    }

    public final <T extends CustomEvent> Bundle getCustomEventExtrasBundle(Class<T> clazz) {
        return this.zzrW.getCustomEventExtrasBundle(clazz);
    }

    public final boolean isTestDevice(Context context) {
        return this.zzrW.isTestDevice(context);
    }

    public final zzla zzaa() {
        return this.zzrW;
    }

    /* synthetic */ AdRequest(Builder builder, zza zza2) {
        this(builder);
    }

    public static final class Builder {
        private final zzlb zzrX = new zzlb();

        public Builder() {
            this.zzrX.zzE(AdRequest.DEVICE_ID_EMULATOR);
        }

        public final Builder addKeyword(String string) {
            this.zzrX.zzD(string);
            return this;
        }

        public final Builder addNetworkExtras(NetworkExtras networkExtras) {
            this.zzrX.zza(networkExtras);
            return this;
        }

        public final Builder addNetworkExtrasBundle(Class<? extends MediationAdapter> clazz, Bundle bundle) {
            this.zzrX.zza(clazz, bundle);
            if (clazz.equals(AdMobAdapter.class) && bundle.getBoolean("_emulatorLiveAds")) {
                this.zzrX.zzF(AdRequest.DEVICE_ID_EMULATOR);
            }
            return this;
        }

        public final Builder addCustomEventExtrasBundle(Class<? extends CustomEvent> clazz, Bundle bundle) {
            this.zzrX.zzb(clazz, bundle);
            return this;
        }

        public final Builder addTestDevice(String string) {
            this.zzrX.zzE(string);
            return this;
        }

        public final AdRequest build() {
            return new AdRequest(this, null);
        }

        public final Builder setBirthday(Date date) {
            this.zzrX.zza(date);
            return this;
        }

        public final Builder setContentUrl(String string) {
            zzbr.zzb((Object)string, (Object)"Content URL must be non-null.");
            zzbr.zzh((String)string, (Object)"Content URL must be non-empty.");
            zzbr.zzb((string.length() <= 512 ? 1 : 0) != 0, (String)"Content URL must not exceed %d in length.  Provided length was %d.", (Object[])new Object[]{512, string.length()});
            this.zzrX.zzG(string);
            return this;
        }

        public final Builder setGender(int n) {
            this.zzrX.zzk(n);
            return this;
        }

        public final Builder setLocation(Location location) {
            this.zzrX.zzb(location);
            return this;
        }

        public final Builder setRequestAgent(String string) {
            this.zzrX.zzI(string);
            return this;
        }

        public final Builder tagForChildDirectedTreatment(boolean bl) {
            this.zzrX.zzh(bl);
            return this;
        }

        public final Builder setIsDesignedForFamilies(boolean bl) {
            this.zzrX.zzi(bl);
            return this;
        }
    }
}

