/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzako;
import com.google.android.gms.internal.zzim;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzio;
import com.google.android.gms.internal.zziu;
import com.google.android.gms.internal.zziv;
import com.google.android.gms.internal.zzix;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zziz;
import com.google.android.gms.internal.zzja;
import com.google.android.gms.internal.zzjb;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzjk;
import com.google.android.gms.internal.zzjz;
import com.google.android.gms.internal.zzks;
import com.google.android.gms.internal.zzla;
import com.google.android.gms.internal.zzld;
import com.google.android.gms.internal.zzlx;
import com.google.android.gms.internal.zznk;
import com.google.android.gms.internal.zzwc;
import java.util.concurrent.atomic.AtomicBoolean;

@zzaaz
public final class zzlc {
    private final zzwc zzBe = new zzwc();
    private final zziu zzrT;
    private final AtomicBoolean zzBf;
    private final VideoController zzBg = new VideoController();
    private zzjk zzBh = new zzld(this);
    private zzim zzzO;
    private AdListener zzzP;
    private AdSize[] zzAB;
    private AppEventListener zzsz;
    private Correlator zzBi;
    private zzjz zzBj;
    private OnCustomRenderedAdLoadedListener zzBk;
    private VideoOptions zzsu;
    private String zztY;
    private ViewGroup zzBl;
    private int zzBm;
    private boolean zzsx;

    public zzlc(ViewGroup viewGroup) {
        this(viewGroup, null, false, zziu.zzAu, 0);
    }

    public zzlc(ViewGroup viewGroup, int n) {
        this(viewGroup, null, false, zziu.zzAu, n);
    }

    public zzlc(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl) {
        this(viewGroup, attributeSet, bl, zziu.zzAu, 0);
    }

    public zzlc(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, int n) {
        this(viewGroup, attributeSet, false, zziu.zzAu, n);
    }

    private zzlc(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zziu zziu2, zzjz zzjz2, int n) {
        this.zzBl = viewGroup;
        this.zzrT = zziu2;
        this.zzBj = null;
        this.zzBf = new AtomicBoolean(false);
        this.zzBm = n;
        if (attributeSet != null) {
            Context context = viewGroup.getContext();
            try {
                zziy zziy2 = new zziy(context, attributeSet);
                this.zzAB = zziy2.zzg(bl);
                this.zztY = zziy2.getAdUnitId();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzji.zzdr().zza(viewGroup, new zziv(context, AdSize.BANNER), illegalArgumentException.getMessage(), illegalArgumentException.getMessage());
                return;
            }
            if (viewGroup.isInEditMode()) {
                boolean bl2;
                int n2 = this.zzBm;
                AdSize adSize = this.zzAB[0];
                Context context2 = context;
                zziv zziv2 = new zziv(context2, adSize);
                new zziv(context2, adSize).zzAA = bl2 = zzlc.zzl(n2);
                zzji.zzdr().zza(viewGroup, zziv2, "Ads by Google");
            }
        }
    }

    private zzlc(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zziu zziu2, int n) {
        this(viewGroup, attributeSet, bl, zziu2, null, n);
    }

    public final void destroy() {
        try {
            if (this.zzBj != null) {
                this.zzBj.destroy();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzako.zzc("Failed to destroy AdView.", remoteException);
            return;
        }
    }

    public final AdListener getAdListener() {
        return this.zzzP;
    }

    public final AdSize getAdSize() {
        try {
            zziv zziv2;
            if (this.zzBj != null && (zziv2 = this.zzBj.zzal()) != null) {
                return zziv2.zzdk();
            }
        }
        catch (RemoteException remoteException) {
            zzako.zzc("Failed to get the current AdSize.", remoteException);
        }
        if (this.zzAB != null) {
            return this.zzAB[0];
        }
        return null;
    }

    public final AdSize[] getAdSizes() {
        return this.zzAB;
    }

    public final String getAdUnitId() {
        if (this.zztY == null && this.zzBj != null) {
            try {
                this.zztY = this.zzBj.getAdUnitId();
            }
            catch (RemoteException remoteException) {
                zzako.zzc("Failed to get ad unit id.", remoteException);
            }
        }
        return this.zztY;
    }

    public final AppEventListener getAppEventListener() {
        return this.zzsz;
    }

    public final OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzBk;
    }

    public final void zza(zzla zzla2) {
        try {
            if (this.zzBj == null) {
                zzjz zzjz2;
                zziv zziv2;
                zzlc zzlc2 = this;
                if ((zzlc2.zzAB == null || zzlc2.zztY == null) && zzlc2.zzBj == null) {
                    throw new IllegalStateException("The ad size and ad unit ID must be set before loadAd is called.");
                }
                zzlc zzlc3 = zzlc2;
                Context context = zzlc3.zzBl.getContext();
                Object object = zziv2 = zzlc.zza(context, zzlc3.zzAB, zzlc3.zzBm);
                if ("search_v2".equals(object.zzAv)) {
                    String string = zzlc3.zztY;
                    zziv zziv3 = zziv2;
                    Context context2 = context;
                    object = zzji.zzds();
                    zzjz2 = zziz.zza(context2, false, new zzjb((zziz)object, context2, zziv3, string));
                } else {
                    zzwc zzwc2 = zzlc3.zzBe;
                    String string = zzlc3.zztY;
                    zziv zziv4 = zziv2;
                    Context context3 = context;
                    object = zzji.zzds();
                    zzjz2 = zziz.zza(context3, false, new zzja((zziz)object, context3, zziv4, string, zzwc2));
                }
                zzlc2.zzBj = zzjz2;
                zzlc2.zzBj.zza(new zzio(zzlc2.zzBh));
                if (zzlc2.zzzO != null) {
                    zzlc2.zzBj.zza(new zzin(zzlc2.zzzO));
                }
                if (zzlc2.zzsz != null) {
                    zzlc2.zzBj.zza(new zzix(zzlc2.zzsz));
                }
                if (zzlc2.zzBk != null) {
                    zzlc2.zzBj.zza(new zznk(zzlc2.zzBk));
                }
                if (zzlc2.zzBi != null) {
                    zzlc2.zzBj.zza(zzlc2.zzBi.zzab());
                }
                if (zzlc2.zzsu != null) {
                    zzlc2.zzBj.zza(new zzlx(zzlc2.zzsu));
                }
                zzlc2.zzBj.setManualImpressionsEnabled(zzlc2.zzsx);
                zzlc zzlc4 = zzlc2;
                try {
                    IObjectWrapper iObjectWrapper = zzlc4.zzBj.zzak();
                    if (iObjectWrapper != null) {
                        zzlc4.zzBl.addView((View)zzn.zzE((IObjectWrapper)iObjectWrapper));
                    }
                }
                catch (RemoteException remoteException) {
                    zzako.zzc("Failed to get an ad frame.", remoteException);
                }
            }
            if (this.zzBj.zza(zziu.zza(this.zzBl.getContext(), zzla2))) {
                this.zzBe.zzg(zzla2.zzdy());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzako.zzc("Failed to load ad.", remoteException);
            return;
        }
    }

    public final void pause() {
        try {
            if (this.zzBj != null) {
                this.zzBj.pause();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzako.zzc("Failed to call pause.", remoteException);
            return;
        }
    }

    public final void recordManualImpression() {
        if (this.zzBf.getAndSet(true)) {
            return;
        }
        try {
            if (this.zzBj != null) {
                this.zzBj.zzan();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzako.zzc("Failed to record impression.", remoteException);
            return;
        }
    }

    public final void resume() {
        try {
            if (this.zzBj != null) {
                this.zzBj.resume();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzako.zzc("Failed to call resume.", remoteException);
            return;
        }
    }

    public final void setAdListener(AdListener adListener) {
        this.zzzP = adListener;
        this.zzBh.zza(adListener);
    }

    public final void zza(zzim zzim2) {
        try {
            this.zzzO = zzim2;
            if (this.zzBj != null) {
                this.zzBj.zza(zzim2 != null ? new zzin(zzim2) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzako.zzc("Failed to set the AdClickListener.", remoteException);
            return;
        }
    }

    public final void setAdSizes(AdSize ... adSizeArray) {
        if (this.zzAB != null) {
            throw new IllegalStateException("The ad size can only be set once on AdView.");
        }
        this.zza(adSizeArray);
    }

    public final void zza(AdSize ... adSizeArray) {
        this.zzAB = adSizeArray;
        try {
            if (this.zzBj != null) {
                this.zzBj.zza(zzlc.zza(this.zzBl.getContext(), this.zzAB, this.zzBm));
            }
        }
        catch (RemoteException remoteException) {
            zzako.zzc("Failed to set the ad size.", remoteException);
        }
        this.zzBl.requestLayout();
    }

    public final void setAdUnitId(String string) {
        if (this.zztY != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on AdView.");
        }
        this.zztY = string;
    }

    public final void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzsz = appEventListener;
            if (this.zzBj != null) {
                this.zzBj.zza(appEventListener != null ? new zzix(appEventListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzako.zzc("Failed to set the AppEventListener.", remoteException);
            return;
        }
    }

    public final void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        this.zzBk = onCustomRenderedAdLoadedListener;
        try {
            if (this.zzBj != null) {
                this.zzBj.zza(onCustomRenderedAdLoadedListener != null ? new zznk(onCustomRenderedAdLoadedListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzako.zzc("Failed to set the onCustomRenderedAdLoadedListener.", remoteException);
            return;
        }
    }

    public final void setManualImpressionsEnabled(boolean bl) {
        this.zzsx = bl;
        try {
            if (this.zzBj != null) {
                this.zzBj.setManualImpressionsEnabled(this.zzsx);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzako.zzc("Failed to set manual impressions.", remoteException);
            return;
        }
    }

    public final void setCorrelator(Correlator correlator) {
        this.zzBi = correlator;
        try {
            if (this.zzBj != null) {
                this.zzBj.zza(this.zzBi == null ? null : this.zzBi.zzab());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzako.zzc("Failed to set correlator.", remoteException);
            return;
        }
    }

    public final String getMediationAdapterClassName() {
        try {
            if (this.zzBj != null) {
                return this.zzBj.zzaH();
            }
        }
        catch (RemoteException remoteException) {
            zzako.zzc("Failed to get the mediation adapter class name.", remoteException);
        }
        return null;
    }

    public final boolean isLoading() {
        try {
            if (this.zzBj != null) {
                return this.zzBj.isLoading();
            }
        }
        catch (RemoteException remoteException) {
            zzako.zzc("Failed to check if ad is loading.", remoteException);
        }
        return false;
    }

    public final VideoController getVideoController() {
        return this.zzBg;
    }

    public final zzks zzad() {
        if (this.zzBj == null) {
            return null;
        }
        try {
            return this.zzBj.getVideoController();
        }
        catch (RemoteException remoteException) {
            zzako.zzc("Failed to retrieve VideoController.", remoteException);
            return null;
        }
    }

    public final void setVideoOptions(VideoOptions videoOptions) {
        this.zzsu = videoOptions;
        try {
            if (this.zzBj != null) {
                this.zzBj.zza(videoOptions == null ? null : new zzlx(videoOptions));
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzako.zzc("Failed to set video options.", remoteException);
            return;
        }
    }

    public final VideoOptions getVideoOptions() {
        return this.zzsu;
    }

    public final boolean zza(zzjz zzjz2) {
        IObjectWrapper iObjectWrapper;
        if (zzjz2 == null) {
            return false;
        }
        try {
            iObjectWrapper = zzjz2.zzak();
        }
        catch (RemoteException remoteException) {
            zzako.zzc("Failed to get an ad frame.", remoteException);
            return false;
        }
        if (iObjectWrapper == null) {
            return false;
        }
        if (((View)zzn.zzE((IObjectWrapper)iObjectWrapper)).getParent() != null) {
            return false;
        }
        this.zzBl.addView((View)zzn.zzE((IObjectWrapper)iObjectWrapper));
        this.zzBj = zzjz2;
        return true;
    }

    private static zziv zza(Context context, AdSize[] adSizeArray, int n) {
        boolean bl;
        zziv zziv2 = new zziv(context, adSizeArray);
        new zziv(context, adSizeArray).zzAA = bl = zzlc.zzl(n);
        return zziv2;
    }

    private static boolean zzl(int n) {
        return n == 1;
    }

    static /* synthetic */ VideoController zza(zzlc zzlc2) {
        return zzlc2.zzBg;
    }
}

