/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.ads.doubleclick.PublisherInterstitialAd;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzaeu;
import com.google.android.gms.internal.zzako;
import com.google.android.gms.internal.zzim;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzio;
import com.google.android.gms.internal.zziu;
import com.google.android.gms.internal.zziv;
import com.google.android.gms.internal.zzix;
import com.google.android.gms.internal.zziz;
import com.google.android.gms.internal.zzjc;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzjz;
import com.google.android.gms.internal.zzla;
import com.google.android.gms.internal.zznk;
import com.google.android.gms.internal.zzwc;

@zzaaz
public final class zzle {
    private final zzwc zzBe = new zzwc();
    private final Context mContext;
    private final zziu zzrT;
    private AdListener zzzP;
    private zzim zzzO;
    private zzjz zzBj;
    private String zztY;
    private AppEventListener zzsz;
    private PublisherInterstitialAd zzBo;
    private OnCustomRenderedAdLoadedListener zzBk;
    private Correlator zzBi;
    private RewardedVideoAdListener zzcV;
    private boolean zzBp;
    private boolean zzum;

    public zzle(Context context) {
        this(context, zziu.zzAu, null);
    }

    public zzle(Context context, PublisherInterstitialAd publisherInterstitialAd) {
        this(context, zziu.zzAu, publisherInterstitialAd);
    }

    private zzle(Context context, zziu zziu2, PublisherInterstitialAd publisherInterstitialAd) {
        this.mContext = context;
        this.zzrT = zziu2;
        this.zzBo = publisherInterstitialAd;
    }

    public final AdListener getAdListener() {
        return this.zzzP;
    }

    public final String getAdUnitId() {
        return this.zztY;
    }

    public final AppEventListener getAppEventListener() {
        return this.zzsz;
    }

    public final OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzBk;
    }

    public final boolean isLoaded() {
        try {
            if (this.zzBj == null) {
                return false;
            }
            return this.zzBj.isReady();
        }
        catch (RemoteException remoteException) {
            zzako.zzc("Failed to check if ad is ready.", remoteException);
            return false;
        }
    }

    public final boolean isLoading() {
        try {
            if (this.zzBj == null) {
                return false;
            }
            return this.zzBj.isLoading();
        }
        catch (RemoteException remoteException) {
            zzako.zzc("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    public final void zza(zzla zzla2) {
        try {
            if (this.zzBj == null) {
                String string = "loadAd";
                zzle zzle2 = this;
                if (zzle2.zztY == null) {
                    zzle2.zzK(string);
                }
                zziv zziv2 = zzle2.zzBp ? zziv.zzdj() : new zziv();
                zzwc zzwc2 = zzle2.zzBe;
                String string2 = zzle2.zztY;
                zziv zziv3 = zziv2;
                Context context = zzle2.mContext;
                zziz zziz2 = zzji.zzds();
                zzle2.zzBj = zziz.zza(context, false, new zzjc(zziz2, context, zziv3, string2, zzwc2));
                if (zzle2.zzzP != null) {
                    zzle2.zzBj.zza(new zzio(zzle2.zzzP));
                }
                if (zzle2.zzzO != null) {
                    zzle2.zzBj.zza(new zzin(zzle2.zzzO));
                }
                if (zzle2.zzsz != null) {
                    zzle2.zzBj.zza(new zzix(zzle2.zzsz));
                }
                if (zzle2.zzBk != null) {
                    zzle2.zzBj.zza(new zznk(zzle2.zzBk));
                }
                if (zzle2.zzBi != null) {
                    zzle2.zzBj.zza(zzle2.zzBi.zzab());
                }
                if (zzle2.zzcV != null) {
                    zzle2.zzBj.zza(new zzaeu(zzle2.zzcV));
                }
                zzle2.zzBj.setImmersiveMode(zzle2.zzum);
            }
            if (this.zzBj.zza(zziu.zza(this.mContext, zzla2))) {
                this.zzBe.zzg(zzla2.zzdy());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzako.zzc("Failed to load ad.", remoteException);
            return;
        }
    }

    public final void setAdListener(AdListener adListener) {
        try {
            this.zzzP = adListener;
            if (this.zzBj != null) {
                this.zzBj.zza(adListener != null ? new zzio(adListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzako.zzc("Failed to set the AdListener.", remoteException);
            return;
        }
    }

    public final void zza(zzim zzim2) {
        try {
            this.zzzO = zzim2;
            if (this.zzBj != null) {
                this.zzBj.zza(zzim2 != null ? new zzin(zzim2) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzako.zzc("Failed to set the AdClickListener.", remoteException);
            return;
        }
    }

    public final void setAdUnitId(String string) {
        if (this.zztY != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on InterstitialAd.");
        }
        this.zztY = string;
    }

    public final void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzsz = appEventListener;
            if (this.zzBj != null) {
                this.zzBj.zza(appEventListener != null ? new zzix(appEventListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzako.zzc("Failed to set the AppEventListener.", remoteException);
            return;
        }
    }

    public final void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        try {
            this.zzBk = onCustomRenderedAdLoadedListener;
            if (this.zzBj != null) {
                this.zzBj.zza(onCustomRenderedAdLoadedListener != null ? new zznk(onCustomRenderedAdLoadedListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzako.zzc("Failed to set the OnCustomRenderedAdLoadedListener.", remoteException);
            return;
        }
    }

    public final void setCorrelator(Correlator correlator) {
        this.zzBi = correlator;
        try {
            if (this.zzBj != null) {
                this.zzBj.zza(this.zzBi == null ? null : this.zzBi.zzab());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzako.zzc("Failed to set correlator.", remoteException);
            return;
        }
    }

    public final void setRewardedVideoAdListener(RewardedVideoAdListener rewardedVideoAdListener) {
        try {
            this.zzcV = rewardedVideoAdListener;
            if (this.zzBj != null) {
                this.zzBj.zza(rewardedVideoAdListener != null ? new zzaeu(rewardedVideoAdListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzako.zzc("Failed to set the AdListener.", remoteException);
            return;
        }
    }

    public final void zza(boolean bl) {
        this.zzBp = true;
    }

    public final String getMediationAdapterClassName() {
        try {
            if (this.zzBj != null) {
                return this.zzBj.zzaH();
            }
        }
        catch (RemoteException remoteException) {
            zzako.zzc("Failed to get the mediation adapter class name.", remoteException);
        }
        return null;
    }

    public final void show() {
        try {
            this.zzK("show");
            this.zzBj.showInterstitial();
            return;
        }
        catch (RemoteException remoteException) {
            zzako.zzc("Failed to show interstitial.", remoteException);
            return;
        }
    }

    public final void setImmersiveMode(boolean bl) {
        try {
            this.zzum = bl;
            if (this.zzBj != null) {
                this.zzBj.setImmersiveMode(bl);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzako.zzc("Failed to set immersive mode", remoteException);
            return;
        }
    }

    private final void zzK(String string) {
        if (this.zzBj == null) {
            throw new IllegalStateException(new StringBuilder(63 + String.valueOf(string).length()).append("The ad unit ID must be set on InterstitialAd before ").append(string).append(" is called.").toString());
        }
    }
}

