/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.widget.FrameLayout;
import com.google.android.gms.internal.zzadh;
import com.google.android.gms.internal.zzaiy;
import com.google.android.gms.internal.zzajc;
import com.google.android.gms.internal.zzip;
import com.google.android.gms.internal.zziq;
import com.google.android.gms.internal.zzjd;
import com.google.android.gms.internal.zzjf;
import com.google.android.gms.internal.zzjh;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzju;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzki;
import com.google.android.gms.internal.zzli;
import com.google.android.gms.internal.zzow;
import com.google.android.gms.internal.zzqc;
import com.google.android.gms.internal.zzuq;
import com.google.android.gms.internal.zzww;
import com.google.android.gms.internal.zzwx;
import com.google.android.gms.internal.zzzn;

@zzzn
public class zziz {
    private zzkh zzAz;
    private final Object mLock = new Object();
    private final zziq zzAA;
    private final zzip zzAB;
    private final zzli zzAC;
    private final zzqc zzAD;
    private final zzadh zzAE;
    private final zzww zzAF;

    public zziz(zziq zziq2, zzip zzip2, zzli zzli2, zzqc zzqc2, zzadh zzadh2, zzww zzww2) {
        this.zzAA = zziq2;
        this.zzAB = zzip2;
        this.zzAC = zzli2;
        this.zzAD = zzqc2;
        this.zzAE = zzadh2;
        this.zzAF = zzww2;
    }

    @Nullable
    private static zzkh zzdm() {
        try {
            Object obj = zziz.class.getClassLoader().loadClass("com.google.android.gms.ads.internal.ClientApi").newInstance();
            if (!(obj instanceof IBinder)) {
                zzajc.zzaT("ClientApi class is not an instance of IBinder");
                return null;
            }
            return zzki.asInterface((IBinder)obj);
        }
        catch (Exception exception) {
            zzajc.zzc("Failed to instantiate ClientApi class.", exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private final zzkh zzdn() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzAz == null) {
                this.zzAz = zziz.zzdm();
            }
            return this.zzAz;
        }
    }

    @VisibleForTesting
    static <T> T zza(Context context, boolean bl, zza<T> zza2) {
        T t;
        if (!bl) {
            zzji.zzds();
            if (!zzaiy.zzX(context)) {
                zzajc.zzaC("Google Play Services is not available");
                bl = true;
            }
        }
        zzji.zzds();
        int n = zzaiy.zzQ(context);
        zzji.zzds();
        if (n > zzaiy.zzP(context)) {
            bl = true;
        }
        if (bl) {
            t = zza2.zzdp();
            if (t == null) {
                t = zza2.zzdq();
            }
        } else {
            t = zza2.zzdq();
            if (t == null) {
                t = zza2.zzdp();
            }
        }
        return t;
    }

    private static void zzb(Context context, String string) {
        Bundle bundle = new Bundle();
        bundle.putString("action", "no_ads_fallback");
        bundle.putString("flow", string);
        zzji.zzds().zza(context, null, "gmob-apps", bundle, true);
    }

    public final zzju zzb(Context context, String string, zzuq zzuq2) {
        return zziz.zza(context, false, new zzjd(this, context, string, zzuq2));
    }

    public final zzow zza(Context context, FrameLayout frameLayout, FrameLayout frameLayout2) {
        return zziz.zza(context, false, new zzjf(this, frameLayout, frameLayout2, context));
    }

    @Nullable
    public final zzwx zzb(Activity activity) {
        boolean bl;
        String string = "com.google.android.gms.ads.internal.overlay.useClientJar";
        Intent intent = activity.getIntent();
        if (!intent.hasExtra(string)) {
            zzajc.e("useClientJar flag not found in activity intent extras.");
            bl = false;
        } else {
            bl = intent.getBooleanExtra(string, false);
        }
        boolean bl2 = bl;
        return zziz.zza((Context)activity, bl2, new zzjh(this, activity));
    }

    static /* synthetic */ zziq zzb(zziz zziz2) {
        return zziz2.zzAA;
    }

    static /* synthetic */ void zza(zziz zziz2, Context context, String string) {
        zziz.zzb(context, string);
    }

    static /* synthetic */ zzip zzc(zziz zziz2) {
        return zziz2.zzAB;
    }

    static /* synthetic */ zzli zzd(zziz zziz2) {
        return zziz2.zzAC;
    }

    static /* synthetic */ zzqc zze(zziz zziz2) {
        return zziz2.zzAD;
    }

    static /* synthetic */ zzadh zzf(zziz zziz2) {
        return zziz2.zzAE;
    }

    static /* synthetic */ zzww zzg(zziz zziz2) {
        return zziz2.zzAF;
    }

    @VisibleForTesting
    abstract class zza<T> {
        private /* synthetic */ zziz zzAI;

        zza(zziz zziz2) {
            this.zzAI = zziz2;
        }

        @Nullable
        protected abstract T zza(zzkh var1) throws RemoteException;

        @Nullable
        protected abstract T zzdo() throws RemoteException;

        @Nullable
        protected final T zzdp() {
            zzkh zzkh2 = this.zzAI.zzdn();
            if (zzkh2 == null) {
                zzajc.zzaT("ClientApi class cannot be loaded.");
                return null;
            }
            try {
                return this.zza(zzkh2);
            }
            catch (RemoteException remoteException) {
                zzajc.zzc("Cannot invoke local loader using ClientApi class", remoteException);
                return null;
            }
        }

        @Nullable
        protected final T zzdq() {
            try {
                return this.zzdo();
            }
            catch (RemoteException remoteException) {
                zzajc.zzc("Cannot invoke remote loader", remoteException);
                return null;
            }
        }
    }
}

