/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.formats;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.ads.formats.AdChoicesView;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzajc;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzow;

public class NativeAdView
extends FrameLayout {
    private final FrameLayout zzss;
    private final zzow zzst;

    public NativeAdView(Context context) {
        super(context);
        this.zzss = this.zzc(context);
        this.zzst = this.zzah();
    }

    public NativeAdView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.zzss = this.zzc(context);
        this.zzst = this.zzah();
    }

    public NativeAdView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.zzss = this.zzc(context);
        this.zzst = this.zzah();
    }

    @TargetApi(value=21)
    public NativeAdView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.zzss = this.zzc(context);
        this.zzst = this.zzah();
    }

    public void setAdChoicesView(AdChoicesView adChoicesView) {
        this.zza("1098", (View)adChoicesView);
    }

    public AdChoicesView getAdChoicesView() {
        View view = this.zzp("1098");
        if (view instanceof AdChoicesView) {
            return (AdChoicesView)view;
        }
        return null;
    }

    protected final void zza(String string, View view) {
        try {
            this.zzst.zzd(string, zzn.zzw((Object)view));
            return;
        }
        catch (RemoteException remoteException) {
            zzajc.zzb("Unable to call setAssetView on delegate", remoteException);
            return;
        }
    }

    protected final View zzp(String string) {
        try {
            IObjectWrapper iObjectWrapper = this.zzst.zzL(string);
            if (iObjectWrapper != null) {
                return (View)zzn.zzE((IObjectWrapper)iObjectWrapper);
            }
        }
        catch (RemoteException remoteException) {
            zzajc.zzb("Unable to call getAssetView on delegate", remoteException);
        }
        return null;
    }

    public void setNativeAd(NativeAd nativeAd) {
        try {
            this.zzst.zze((IObjectWrapper)nativeAd.zzag());
            return;
        }
        catch (RemoteException remoteException) {
            zzajc.zzb("Unable to call setNativeAd on delegate", remoteException);
            return;
        }
    }

    public void destroy() {
        try {
            this.zzst.destroy();
            return;
        }
        catch (RemoteException remoteException) {
            zzajc.zzb("Unable to destroy native ad view", remoteException);
            return;
        }
    }

    private final FrameLayout zzc(Context context) {
        Context context2 = context;
        FrameLayout frameLayout = new FrameLayout(context2);
        frameLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView((View)frameLayout);
        return frameLayout;
    }

    private final zzow zzah() {
        zzbo.zzb((Object)this.zzss, (Object)"createDelegate must be called after mOverlayFrame has been created");
        return zzji.zzdt().zza(this.zzss.getContext(), this, this.zzss);
    }

    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        super.addView(view, n, layoutParams);
        super.bringChildToFront((View)this.zzss);
    }

    public void removeView(View view) {
        if (this.zzss == view) {
            return;
        }
        super.removeView(view);
    }

    public void removeAllViews() {
        super.removeAllViews();
        super.addView((View)this.zzss);
    }

    public void bringChildToFront(View view) {
        super.bringChildToFront(view);
        if (this.zzss != view) {
            super.bringChildToFront((View)this.zzss);
        }
    }

    public void onVisibilityChanged(View view, int n) {
        super.onVisibilityChanged(view, n);
        if (this.zzst != null) {
            try {
                this.zzst.zzb(zzn.zzw((Object)view), n);
                return;
            }
            catch (RemoteException remoteException) {
                zzajc.zzb("Unable to call onVisibilityChanged on delegate", remoteException);
            }
        }
    }
}

