/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.view.View;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAdView;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.ads.mediation.MediationNativeAdapter;
import com.google.android.gms.ads.mediation.MediationNativeListener;
import com.google.android.gms.ads.mediation.NativeAppInstallAdMapper;
import com.google.android.gms.ads.mediation.NativeContentAdMapper;
import com.google.android.gms.ads.mediation.NativeMediationAdRequest;
import com.google.android.gms.ads.mediation.OnImmersiveModeUpdatedListener;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdAdapter;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdListener;
import com.google.android.gms.internal.zzaje;
import com.google.android.gms.internal.zzaji;
import com.google.android.gms.internal.zzalt;
import com.google.android.gms.internal.zzis;
import com.google.android.gms.internal.zzjo;
import com.google.android.gms.internal.zzky;
import com.google.android.gms.internal.zzzt;
import java.util.Date;
import java.util.Set;

@zzzt
public abstract class AbstractAdViewAdapter
implements MediationBannerAdapter,
MediationNativeAdapter,
OnImmersiveModeUpdatedListener,
com.google.android.gms.ads.mediation.zza,
MediationRewardedVideoAdAdapter,
zzalt {
    public static final String AD_UNIT_ID_PARAMETER = "pubid";
    private AdView zzgm;
    private InterstitialAd zzgn;
    private AdLoader zzgo;
    private Context zzgp;
    private InterstitialAd zzgq;
    private MediationRewardedVideoAdListener zzgr;
    private RewardedVideoAdListener zzgs = new com.google.ads.mediation.zza(this);

    public AbstractAdViewAdapter() {
    }

    protected abstract Bundle zza(Bundle var1, Bundle var2);

    private final AdRequest zza(Context context, MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle2) {
        String string;
        Location location;
        Set<String> set;
        int n;
        AdRequest.Builder builder = new AdRequest.Builder();
        Date date = mediationAdRequest.getBirthday();
        if (date != null) {
            builder.setBirthday(date);
        }
        if ((n = mediationAdRequest.getGender()) != 0) {
            builder.setGender(n);
        }
        if ((set = mediationAdRequest.getKeywords()) != null) {
            location = set.iterator();
            while (location.hasNext()) {
                string = (String)location.next();
                builder.addKeyword(string);
            }
        }
        if ((location = mediationAdRequest.getLocation()) != null) {
            builder.setLocation(location);
        }
        if (mediationAdRequest.isTesting()) {
            zzjo.zzhu();
            builder.addTestDevice(zzaje.zzay(context));
        }
        if (mediationAdRequest.taggedForChildDirectedTreatment() != -1) {
            builder.tagForChildDirectedTreatment(mediationAdRequest.taggedForChildDirectedTreatment() == 1);
        }
        builder.setIsDesignedForFamilies(mediationAdRequest.isDesignedForFamilies());
        string = this.zza(bundle, bundle2);
        builder.addNetworkExtrasBundle(AdMobAdapter.class, (Bundle)string);
        return builder.build();
    }

    @Override
    public void onDestroy() {
        if (this.zzgm != null) {
            this.zzgm.destroy();
            this.zzgm = null;
        }
        if (this.zzgn != null) {
            this.zzgn = null;
        }
        if (this.zzgo != null) {
            this.zzgo = null;
        }
        if (this.zzgq != null) {
            this.zzgq = null;
        }
    }

    @Override
    public void onPause() {
        if (this.zzgm != null) {
            this.zzgm.pause();
        }
    }

    @Override
    public void onResume() {
        if (this.zzgm != null) {
            this.zzgm.resume();
        }
    }

    public String getAdUnitId(Bundle bundle) {
        return bundle.getString(AD_UNIT_ID_PARAMETER);
    }

    @Override
    public void requestBannerAd(Context context, MediationBannerListener mediationBannerListener, Bundle bundle, AdSize adSize, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zzgm = new AdView(context);
        this.zzgm.setAdSize(new AdSize(adSize.getWidth(), adSize.getHeight()));
        this.zzgm.setAdUnitId(this.getAdUnitId(bundle));
        this.zzgm.setAdListener(new zzc(this, mediationBannerListener));
        this.zzgm.loadAd(this.zza(context, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public View getBannerView() {
        return this.zzgm;
    }

    @Override
    public void requestInterstitialAd(Context context, MediationInterstitialListener mediationInterstitialListener, Bundle bundle, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zzgn = new InterstitialAd(context);
        this.zzgn.setAdUnitId(this.getAdUnitId(bundle));
        this.zzgn.setAdListener(new zzd(this, mediationInterstitialListener));
        this.zzgn.loadAd(this.zza(context, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public void onImmersiveModeUpdated(boolean bl) {
        if (this.zzgn != null) {
            this.zzgn.setImmersiveMode(bl);
        }
        if (this.zzgq != null) {
            this.zzgq.setImmersiveMode(bl);
        }
    }

    @Override
    public zzky getVideoController() {
        VideoController videoController;
        if (this.zzgm != null && (videoController = this.zzgm.getVideoController()) != null) {
            return videoController.zzbc();
        }
        return null;
    }

    @Override
    public void showInterstitial() {
        this.zzgn.show();
    }

    @Override
    public Bundle getInterstitialAdapterInfo() {
        return new MediationAdapter.zza().zzaf(1).zztm();
    }

    @Override
    public void requestNativeAd(Context context, MediationNativeListener mediationNativeListener, Bundle bundle, NativeMediationAdRequest nativeMediationAdRequest, Bundle bundle2) {
        zze zze2 = new zze(this, mediationNativeListener);
        String string = bundle.getString(AD_UNIT_ID_PARAMETER);
        Context context2 = context;
        AdLoader.Builder builder = new AdLoader.Builder(context2, string).withAdListener(zze2);
        NativeAdOptions nativeAdOptions = nativeMediationAdRequest.getNativeAdOptions();
        if (nativeAdOptions != null) {
            builder.withNativeAdOptions(nativeAdOptions);
        }
        if (nativeMediationAdRequest.isAppInstallAdRequested()) {
            builder.forAppInstallAd(zze2);
        }
        if (nativeMediationAdRequest.isContentAdRequested()) {
            builder.forContentAd(zze2);
        }
        if (nativeMediationAdRequest.zzmc()) {
            for (String string2 : nativeMediationAdRequest.zzmd().keySet()) {
                builder.forCustomTemplateAd(string2, zze2, nativeMediationAdRequest.zzmd().get(string2) != false ? zze2 : null);
            }
        }
        this.zzgo = builder.build();
        this.zzgo.loadAd(this.zza(context, nativeMediationAdRequest, bundle2, bundle));
    }

    @Override
    public void initialize(Context context, MediationAdRequest mediationAdRequest, String string, MediationRewardedVideoAdListener mediationRewardedVideoAdListener, Bundle bundle, Bundle bundle2) {
        this.zzgp = context.getApplicationContext();
        this.zzgr = mediationRewardedVideoAdListener;
        this.zzgr.onInitializationSucceeded(this);
    }

    @Override
    public void loadAd(MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle2) {
        if (this.zzgp == null || this.zzgr == null) {
            zzaji.e("AdMobAdapter.loadAd called before initialize.");
            return;
        }
        this.zzgq = new InterstitialAd(this.zzgp);
        this.zzgq.zza(true);
        this.zzgq.setAdUnitId(this.getAdUnitId(bundle));
        this.zzgq.setRewardedVideoAdListener(this.zzgs);
        this.zzgq.loadAd(this.zza(this.zzgp, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public void showVideo() {
        this.zzgq.show();
    }

    @Override
    public boolean isInitialized() {
        return this.zzgr != null;
    }

    static /* synthetic */ MediationRewardedVideoAdListener zza(AbstractAdViewAdapter abstractAdViewAdapter) {
        return abstractAdViewAdapter.zzgr;
    }

    static /* synthetic */ InterstitialAd zza(AbstractAdViewAdapter abstractAdViewAdapter, InterstitialAd interstitialAd) {
        abstractAdViewAdapter.zzgq = null;
        return null;
    }

    static final class zzb
    extends NativeContentAdMapper {
        private final NativeContentAd zzgv;

        public zzb(NativeContentAd nativeContentAd) {
            this.zzgv = nativeContentAd;
            this.setHeadline(nativeContentAd.getHeadline().toString());
            this.setImages(nativeContentAd.getImages());
            this.setBody(nativeContentAd.getBody().toString());
            if (nativeContentAd.getLogo() != null) {
                this.setLogo(nativeContentAd.getLogo());
            }
            this.setCallToAction(nativeContentAd.getCallToAction().toString());
            this.setAdvertiser(nativeContentAd.getAdvertiser().toString());
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
            this.zza(nativeContentAd.getVideoController());
        }

        @Override
        public final void trackView(View view) {
            if (view instanceof NativeAdView) {
                ((NativeAdView)view).setNativeAd(this.zzgv);
            }
        }
    }

    static final class zza
    extends NativeAppInstallAdMapper {
        private final NativeAppInstallAd zzgu;

        public zza(NativeAppInstallAd nativeAppInstallAd) {
            this.zzgu = nativeAppInstallAd;
            this.setHeadline(nativeAppInstallAd.getHeadline().toString());
            this.setImages(nativeAppInstallAd.getImages());
            this.setBody(nativeAppInstallAd.getBody().toString());
            this.setIcon(nativeAppInstallAd.getIcon());
            this.setCallToAction(nativeAppInstallAd.getCallToAction().toString());
            if (nativeAppInstallAd.getStarRating() != null) {
                this.setStarRating(nativeAppInstallAd.getStarRating());
            }
            if (nativeAppInstallAd.getStore() != null) {
                this.setStore(nativeAppInstallAd.getStore().toString());
            }
            if (nativeAppInstallAd.getPrice() != null) {
                this.setPrice(nativeAppInstallAd.getPrice().toString());
            }
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
            this.zza(nativeAppInstallAd.getVideoController());
        }

        @Override
        public final void trackView(View view) {
            if (view instanceof NativeAdView) {
                ((NativeAdView)view).setNativeAd(this.zzgu);
            }
        }
    }

    static final class zze
    extends AdListener
    implements NativeAppInstallAd.OnAppInstallAdLoadedListener,
    NativeContentAd.OnContentAdLoadedListener,
    NativeCustomTemplateAd.OnCustomClickListener,
    NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener {
        private AbstractAdViewAdapter zzgw;
        private MediationNativeListener zzgz;

        public zze(AbstractAdViewAdapter abstractAdViewAdapter, MediationNativeListener mediationNativeListener) {
            this.zzgw = abstractAdViewAdapter;
            this.zzgz = mediationNativeListener;
        }

        @Override
        public final void onAdLoaded() {
        }

        @Override
        public final void onAdFailedToLoad(int n) {
            this.zzgz.onAdFailedToLoad(this.zzgw, n);
        }

        @Override
        public final void onAdOpened() {
            this.zzgz.onAdOpened(this.zzgw);
        }

        @Override
        public final void onAdClosed() {
            this.zzgz.onAdClosed(this.zzgw);
        }

        @Override
        public final void onAdLeftApplication() {
            this.zzgz.onAdLeftApplication(this.zzgw);
        }

        @Override
        public final void onAdClicked() {
            this.zzgz.onAdClicked(this.zzgw);
        }

        @Override
        public final void onAdImpression() {
            this.zzgz.onAdImpression(this.zzgw);
        }

        @Override
        public final void onAppInstallAdLoaded(NativeAppInstallAd nativeAppInstallAd) {
            this.zzgz.onAdLoaded(this.zzgw, new zza(nativeAppInstallAd));
        }

        @Override
        public final void onContentAdLoaded(NativeContentAd nativeContentAd) {
            this.zzgz.onAdLoaded(this.zzgw, new zzb(nativeContentAd));
        }

        @Override
        public final void onCustomTemplateAdLoaded(NativeCustomTemplateAd nativeCustomTemplateAd) {
            this.zzgz.zza(this.zzgw, nativeCustomTemplateAd);
        }

        @Override
        public final void onCustomClick(NativeCustomTemplateAd nativeCustomTemplateAd, String string) {
            this.zzgz.zza(this.zzgw, nativeCustomTemplateAd, string);
        }
    }

    static final class zzd
    extends AdListener
    implements zzis {
        private AbstractAdViewAdapter zzgw;
        private MediationInterstitialListener zzgy;

        public zzd(AbstractAdViewAdapter abstractAdViewAdapter, MediationInterstitialListener mediationInterstitialListener) {
            this.zzgw = abstractAdViewAdapter;
            this.zzgy = mediationInterstitialListener;
        }

        @Override
        public final void onAdLoaded() {
            this.zzgy.onAdLoaded(this.zzgw);
        }

        @Override
        public final void onAdFailedToLoad(int n) {
            this.zzgy.onAdFailedToLoad(this.zzgw, n);
        }

        @Override
        public final void onAdOpened() {
            this.zzgy.onAdOpened(this.zzgw);
        }

        @Override
        public final void onAdClosed() {
            this.zzgy.onAdClosed(this.zzgw);
        }

        @Override
        public final void onAdLeftApplication() {
            this.zzgy.onAdLeftApplication(this.zzgw);
        }

        @Override
        public final void onAdClicked() {
            this.zzgy.onAdClicked(this.zzgw);
        }
    }

    static final class zzc
    extends AdListener
    implements AppEventListener,
    zzis {
        private AbstractAdViewAdapter zzgw;
        private MediationBannerListener zzgx;

        public zzc(AbstractAdViewAdapter abstractAdViewAdapter, MediationBannerListener mediationBannerListener) {
            this.zzgw = abstractAdViewAdapter;
            this.zzgx = mediationBannerListener;
        }

        @Override
        public final void onAdLoaded() {
            this.zzgx.onAdLoaded(this.zzgw);
        }

        @Override
        public final void onAdFailedToLoad(int n) {
            this.zzgx.onAdFailedToLoad(this.zzgw, n);
        }

        @Override
        public final void onAdOpened() {
            this.zzgx.onAdOpened(this.zzgw);
        }

        @Override
        public final void onAdClosed() {
            this.zzgx.onAdClosed(this.zzgw);
        }

        @Override
        public final void onAdLeftApplication() {
            this.zzgx.onAdLeftApplication(this.zzgw);
        }

        @Override
        public final void onAdClicked() {
            this.zzgx.onAdClicked(this.zzgw);
        }

        @Override
        public final void onAppEvent(String string, String string2) {
            this.zzgx.zza(this.zzgw, string, string2);
        }
    }
}

