/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.doubleclick;

import android.content.Context;
import android.support.annotation.RequiresPermission;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.ads.doubleclick.PublisherAdRequest;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzaji;
import com.google.android.gms.internal.zzkf;
import com.google.android.gms.internal.zzli;

public final class PublisherAdView
extends ViewGroup {
    private final zzli zzaky;

    public PublisherAdView(Context context) {
        super(context);
        this.zzaky = new zzli(this);
    }

    public PublisherAdView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.zzaky = new zzli(this, attributeSet, true);
        zzbp.zzb((Object)context, (Object)"Context cannot be null");
    }

    public PublisherAdView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.zzaky = new zzli(this, attributeSet, true);
    }

    public final VideoController getVideoController() {
        return this.zzaky.getVideoController();
    }

    public final void setVideoOptions(VideoOptions videoOptions) {
        this.zzaky.setVideoOptions(videoOptions);
    }

    public final VideoOptions getVideoOptions() {
        return this.zzaky.getVideoOptions();
    }

    public final void destroy() {
        this.zzaky.destroy();
    }

    public final AdListener getAdListener() {
        return this.zzaky.getAdListener();
    }

    public final AdSize getAdSize() {
        return this.zzaky.getAdSize();
    }

    public final AdSize[] getAdSizes() {
        return this.zzaky.getAdSizes();
    }

    public final String getAdUnitId() {
        return this.zzaky.getAdUnitId();
    }

    public final AppEventListener getAppEventListener() {
        return this.zzaky.getAppEventListener();
    }

    public final OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzaky.getOnCustomRenderedAdLoadedListener();
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public final void loadAd(PublisherAdRequest publisherAdRequest) {
        this.zzaky.zza(publisherAdRequest.zzaz());
    }

    public final void pause() {
        this.zzaky.pause();
    }

    public final void setManualImpressionsEnabled(boolean bl) {
        this.zzaky.setManualImpressionsEnabled(bl);
    }

    public final void recordManualImpression() {
        this.zzaky.recordManualImpression();
    }

    public final void resume() {
        this.zzaky.resume();
    }

    public final void setAdListener(AdListener adListener) {
        this.zzaky.setAdListener(adListener);
    }

    public final void setAdSizes(AdSize ... adSizeArray) {
        if (adSizeArray == null || adSizeArray.length <= 0) {
            throw new IllegalArgumentException("The supported ad sizes must contain at least one valid ad size.");
        }
        this.zzaky.zza(adSizeArray);
    }

    public final void setAdUnitId(String string) {
        this.zzaky.setAdUnitId(string);
    }

    public final void setAppEventListener(AppEventListener appEventListener) {
        this.zzaky.setAppEventListener(appEventListener);
    }

    public final void setCorrelator(Correlator correlator) {
        this.zzaky.setCorrelator(correlator);
    }

    public final void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        this.zzaky.setOnCustomRenderedAdLoadedListener(onCustomRenderedAdLoadedListener);
    }

    public final String getMediationAdapterClassName() {
        return this.zzaky.getMediationAdapterClassName();
    }

    public final boolean isLoading() {
        return this.zzaky.isLoading();
    }

    public final boolean zza(zzkf zzkf2) {
        return this.zzaky.zza(zzkf2);
    }

    protected final void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            int n5 = view.getMeasuredWidth();
            int n6 = view.getMeasuredHeight();
            int n7 = (n3 - n - n5) / 2;
            int n8 = (n4 - n2 - n6) / 2;
            view.layout(n7, n8, n7 + n5, n8 + n6);
        }
    }

    protected final void onMeasure(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            this.measureChild(view, n, n2);
            n3 = view.getMeasuredWidth();
            n4 = view.getMeasuredHeight();
        } else {
            AdSize adSize = null;
            try {
                adSize = this.getAdSize();
            }
            catch (NullPointerException nullPointerException) {
                zzaji.zzb("Unable to retrieve ad size.", nullPointerException);
            }
            if (adSize != null) {
                Context context = this.getContext();
                n3 = adSize.getWidthInPixels(context);
                n4 = adSize.getHeightInPixels(context);
            }
        }
        n3 = Math.max(n3, this.getSuggestedMinimumWidth());
        n4 = Math.max(n4, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(View.resolveSize((int)n3, (int)n), View.resolveSize((int)n4, (int)n2));
    }
}

