/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.formats.MediaView;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzaji;
import com.google.android.gms.internal.zzky;
import com.google.android.gms.internal.zzpc;
import com.google.android.gms.internal.zzpf;
import com.google.android.gms.internal.zzpt;
import com.google.android.gms.internal.zzzt;
import java.util.List;

@zzzt
public final class zzpw
implements NativeCustomTemplateAd {
    private final zzpt zzbub;
    private final MediaView zzbuc;
    private final VideoController zzbeb = new VideoController();

    public zzpw(zzpt zzpt2) {
        this.zzbub = zzpt2;
        Context context = null;
        try {
            context = (Context)zzn.zzab((IObjectWrapper)zzpt2.zzjp());
        }
        catch (RemoteException | NullPointerException throwable) {
            zzaji.zzb("Unable to inflate MediaView.", throwable);
        }
        MediaView mediaView = null;
        if (context != null) {
            Context context2 = context;
            mediaView = new MediaView(context2);
            try {
                if (!this.zzbub.zzj(zzn.zzw((Object)((Object)mediaView)))) {
                    mediaView = null;
                }
            }
            catch (RemoteException remoteException) {
                mediaView = null;
                zzaji.zzb("Unable to render video in MediaView.", remoteException);
            }
        }
        this.zzbuc = mediaView;
    }

    public final zzpt zzjz() {
        return this.zzbub;
    }

    @Override
    public final CharSequence getText(String string) {
        try {
            return this.zzbub.zzao(string);
        }
        catch (RemoteException remoteException) {
            zzaji.zzb("Failed to get string.", remoteException);
            return null;
        }
    }

    @Override
    public final NativeAd.Image getImage(String string) {
        try {
            zzpc zzpc2 = this.zzbub.zzap(string);
            if (zzpc2 != null) {
                return new zzpf(zzpc2);
            }
        }
        catch (RemoteException remoteException) {
            zzaji.zzb("Failed to get image.", remoteException);
        }
        return null;
    }

    @Override
    public final VideoController getVideoController() {
        try {
            zzky zzky2 = this.zzbub.getVideoController();
            if (zzky2 != null) {
                this.zzbeb.zza(zzky2);
            }
        }
        catch (RemoteException remoteException) {
            zzaji.zzb("Exception occurred while getting video controller", remoteException);
        }
        return this.zzbeb;
    }

    @Override
    public final MediaView getVideoMediaView() {
        return this.zzbuc;
    }

    @Override
    public final List<String> getAvailableAssetNames() {
        try {
            return this.zzbub.getAvailableAssetNames();
        }
        catch (RemoteException remoteException) {
            zzaji.zzb("Failed to get available asset names.", remoteException);
            return null;
        }
    }

    @Override
    public final String getCustomTemplateId() {
        try {
            return this.zzbub.getCustomTemplateId();
        }
        catch (RemoteException remoteException) {
            zzaji.zzb("Failed to get custom template id.", remoteException);
            return null;
        }
    }

    @Override
    public final void performClick(String string) {
        try {
            this.zzbub.performClick(string);
            return;
        }
        catch (RemoteException remoteException) {
            zzaji.zzb("Failed to perform click.", remoteException);
            return;
        }
    }

    @Override
    public final void recordImpression() {
        try {
            this.zzbub.recordImpression();
            return;
        }
        catch (RemoteException remoteException) {
            zzaji.zzb("Failed to record impression.", remoteException);
            return;
        }
    }

    @Override
    public final void destroy() {
        try {
            this.zzbub.destroy();
            return;
        }
        catch (RemoteException remoteException) {
            zzaji.zzb("Failed to destroy ad.", remoteException);
            return;
        }
    }
}

