/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.RemoteException;
import com.google.ads.mediation.AdUrlAdapter;
import com.google.ads.mediation.MediationServerParameters;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.ads.mediation.customevent.CustomEventAdapter;
import com.google.ads.mediation.customevent.CustomEventServerParameters;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.NetworkExtras;
import com.google.android.gms.ads.mediation.customevent.CustomEvent;
import com.google.android.gms.ads.mediation.customevent.CustomEventExtras;
import com.google.android.gms.internal.zzaji;
import com.google.android.gms.internal.zzvb;
import com.google.android.gms.internal.zzvd;
import com.google.android.gms.internal.zzvt;
import com.google.android.gms.internal.zzvy;
import com.google.android.gms.internal.zzzt;
import java.util.Map;

@zzzt
public final class zzuz
extends zzvb {
    private Map<Class<? extends NetworkExtras>, NetworkExtras> zzccs;

    @Override
    public final zzvd zzbh(String string) throws RemoteException {
        return this.zzbj(string);
    }

    @Override
    public final boolean zzbi(String string) throws RemoteException {
        try {
            Class<?> clazz = Class.forName(string, false, zzuz.class.getClassLoader());
            return CustomEvent.class.isAssignableFrom(clazz);
        }
        catch (Throwable throwable) {
            zzaji.zzcs(new StringBuilder(80 + String.valueOf(string).length()).append("Could not load custom event implementation class: ").append(string).append(", assuming old implementation.").toString());
            return false;
        }
    }

    public final void zzh(Map<Class<? extends NetworkExtras>, NetworkExtras> map) {
        this.zzccs = map;
    }

    private final <NETWORK_EXTRAS extends com.google.ads.mediation.NetworkExtras, SERVER_PARAMETERS extends MediationServerParameters> zzvd zzbj(String string) throws RemoteException {
        try {
            Class<?> clazz = Class.forName(string, false, zzuz.class.getClassLoader());
            if (com.google.ads.mediation.MediationAdapter.class.isAssignableFrom(clazz)) {
                com.google.ads.mediation.MediationAdapter mediationAdapter = (com.google.ads.mediation.MediationAdapter)clazz.newInstance();
                com.google.ads.mediation.NetworkExtras networkExtras = (com.google.ads.mediation.NetworkExtras)this.zzccs.get(mediationAdapter.getAdditionalParametersType());
                return new zzvy(mediationAdapter, networkExtras);
            }
            if (MediationAdapter.class.isAssignableFrom(clazz)) {
                MediationAdapter mediationAdapter = (MediationAdapter)clazz.newInstance();
                return new zzvt(mediationAdapter);
            }
            zzaji.zzcs(new StringBuilder(64 + String.valueOf(string).length()).append("Could not instantiate mediation adapter: ").append(string).append(" (not a valid adapter).").toString());
            throw new RemoteException();
        }
        catch (Throwable throwable) {
            return this.zzbk(string);
        }
    }

    private final zzvd zzbk(String string) throws RemoteException {
        try {
            zzaji.zzcb("Reflection failed, retrying using direct instantiation");
            if ("com.google.ads.mediation.admob.AdMobAdapter".equals(string)) {
                return new zzvt(new AdMobAdapter());
            }
            if ("com.google.ads.mediation.AdUrlAdapter".equals(string)) {
                return new zzvt(new AdUrlAdapter());
            }
            if ("com.google.android.gms.ads.mediation.customevent.CustomEventAdapter".equals(string)) {
                return new zzvt(new com.google.android.gms.ads.mediation.customevent.CustomEventAdapter());
            }
            if ("com.google.ads.mediation.customevent.CustomEventAdapter".equals(string)) {
                CustomEventAdapter customEventAdapter = new CustomEventAdapter();
                CustomEventExtras customEventExtras = (CustomEventExtras)this.zzccs.get(customEventAdapter.getAdditionalParametersType());
                return new zzvy<CustomEventExtras, CustomEventServerParameters>(customEventAdapter, customEventExtras);
            }
        }
        catch (Throwable throwable) {
            zzaji.zzc(new StringBuilder(43 + String.valueOf(string).length()).append("Could not instantiate mediation adapter: ").append(string).append(". ").toString(), throwable);
        }
        throw new RemoteException();
    }
}

