/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.view.View;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAdView;
import com.google.android.gms.ads.formats.NativeAdViewHolder;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.ads.mediation.MediationNativeAdapter;
import com.google.android.gms.ads.mediation.MediationNativeListener;
import com.google.android.gms.ads.mediation.NativeAppInstallAdMapper;
import com.google.android.gms.ads.mediation.NativeContentAdMapper;
import com.google.android.gms.ads.mediation.NativeMediationAdRequest;
import com.google.android.gms.ads.mediation.OnImmersiveModeUpdatedListener;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdAdapter;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdListener;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzako;
import com.google.android.gms.internal.zzaky;
import com.google.android.gms.internal.zzaqk;
import com.google.android.gms.internal.zzkf;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzmm;
import java.util.Date;
import java.util.Map;
import java.util.Set;

@zzabh
@Hide
public abstract class AbstractAdViewAdapter
implements MediationBannerAdapter,
MediationNativeAdapter,
OnImmersiveModeUpdatedListener,
com.google.android.gms.ads.mediation.zzb,
MediationRewardedVideoAdAdapter,
zzaqk {
    public static final String AD_UNIT_ID_PARAMETER = "pubid";
    private AdView zza;
    private InterstitialAd zzb;
    private AdLoader zzc;
    private Context zzd;
    private InterstitialAd zze;
    private MediationRewardedVideoAdListener zzf;
    private RewardedVideoAdListener zzg = new com.google.ads.mediation.zza(this);

    public AbstractAdViewAdapter() {
    }

    protected abstract Bundle zza(Bundle var1, Bundle var2);

    private final AdRequest zza(Context context, MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle2) {
        String string;
        Location location;
        Set<String> set;
        int n;
        AdRequest.Builder builder = new AdRequest.Builder();
        Date date = mediationAdRequest.getBirthday();
        if (date != null) {
            builder.setBirthday(date);
        }
        if ((n = mediationAdRequest.getGender()) != 0) {
            builder.setGender(n);
        }
        if ((set = mediationAdRequest.getKeywords()) != null) {
            location = set.iterator();
            while (location.hasNext()) {
                string = (String)location.next();
                builder.addKeyword(string);
            }
        }
        if ((location = mediationAdRequest.getLocation()) != null) {
            builder.setLocation(location);
        }
        if (mediationAdRequest.isTesting()) {
            zzlc.zza();
            builder.addTestDevice(zzako.zza(context));
        }
        if (mediationAdRequest.taggedForChildDirectedTreatment() != -1) {
            builder.tagForChildDirectedTreatment(mediationAdRequest.taggedForChildDirectedTreatment() == 1);
        }
        builder.setIsDesignedForFamilies(mediationAdRequest.isDesignedForFamilies());
        string = this.zza(bundle, bundle2);
        builder.addNetworkExtrasBundle(AdMobAdapter.class, (Bundle)string);
        return builder.build();
    }

    @Override
    public void onDestroy() {
        if (this.zza != null) {
            this.zza.destroy();
            this.zza = null;
        }
        if (this.zzb != null) {
            this.zzb = null;
        }
        if (this.zzc != null) {
            this.zzc = null;
        }
        if (this.zze != null) {
            this.zze = null;
        }
    }

    @Override
    public void onPause() {
        if (this.zza != null) {
            this.zza.pause();
        }
    }

    @Override
    public void onResume() {
        if (this.zza != null) {
            this.zza.resume();
        }
    }

    public String getAdUnitId(Bundle bundle) {
        return bundle.getString(AD_UNIT_ID_PARAMETER);
    }

    @Override
    public void requestBannerAd(Context context, MediationBannerListener mediationBannerListener, Bundle bundle, AdSize adSize, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zza = new AdView(context);
        this.zza.setAdSize(new AdSize(adSize.getWidth(), adSize.getHeight()));
        this.zza.setAdUnitId(this.getAdUnitId(bundle));
        this.zza.setAdListener(new zzd(this, mediationBannerListener));
        this.zza.loadAd(this.zza(context, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public View getBannerView() {
        return this.zza;
    }

    @Override
    public void requestInterstitialAd(Context context, MediationInterstitialListener mediationInterstitialListener, Bundle bundle, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zzb = new InterstitialAd(context);
        this.zzb.setAdUnitId(this.getAdUnitId(bundle));
        this.zzb.setAdListener(new zze(this, mediationInterstitialListener));
        this.zzb.loadAd(this.zza(context, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public void onImmersiveModeUpdated(boolean bl) {
        if (this.zzb != null) {
            this.zzb.setImmersiveMode(bl);
        }
        if (this.zze != null) {
            this.zze.setImmersiveMode(bl);
        }
    }

    @Override
    public zzmm getVideoController() {
        VideoController videoController;
        if (this.zza != null && (videoController = this.zza.zza()) != null) {
            return videoController.zza();
        }
        return null;
    }

    @Override
    public void showInterstitial() {
        this.zzb.show();
    }

    @Override
    public Bundle getInterstitialAdapterInfo() {
        return new MediationAdapter.zza().zza(1).zza();
    }

    @Override
    public void requestNativeAd(Context context, MediationNativeListener mediationNativeListener, Bundle bundle, NativeMediationAdRequest nativeMediationAdRequest, Bundle bundle2) {
        zzf zzf2 = new zzf(this, mediationNativeListener);
        String string = bundle.getString(AD_UNIT_ID_PARAMETER);
        Context context2 = context;
        AdLoader.Builder builder = new AdLoader.Builder(context2, string).withAdListener(zzf2);
        NativeAdOptions nativeAdOptions = nativeMediationAdRequest.getNativeAdOptions();
        if (nativeAdOptions != null) {
            builder.withNativeAdOptions(nativeAdOptions);
        }
        if (nativeMediationAdRequest.zza()) {
            builder.zza(zzf2);
        }
        if (nativeMediationAdRequest.isAppInstallAdRequested()) {
            builder.forAppInstallAd(zzf2);
        }
        if (nativeMediationAdRequest.isContentAdRequested()) {
            builder.forContentAd(zzf2);
        }
        if (nativeMediationAdRequest.zzb()) {
            for (String string2 : nativeMediationAdRequest.zzc().keySet()) {
                builder.forCustomTemplateAd(string2, zzf2, nativeMediationAdRequest.zzc().get(string2) != false ? zzf2 : null);
            }
        }
        this.zzc = builder.build();
        this.zzc.loadAd(this.zza(context, nativeMediationAdRequest, bundle2, bundle));
    }

    @Override
    public void initialize(Context context, MediationAdRequest mediationAdRequest, String string, MediationRewardedVideoAdListener mediationRewardedVideoAdListener, Bundle bundle, Bundle bundle2) {
        this.zzd = context.getApplicationContext();
        this.zzf = mediationRewardedVideoAdListener;
        this.zzf.onInitializationSucceeded(this);
    }

    @Override
    public void loadAd(MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle2) {
        if (this.zzd == null || this.zzf == null) {
            zzaky.zzc("AdMobAdapter.loadAd called before initialize.");
            return;
        }
        this.zze = new InterstitialAd(this.zzd);
        this.zze.zza(true);
        this.zze.setAdUnitId(this.getAdUnitId(bundle));
        this.zze.zza(this.zzg);
        this.zze.loadAd(this.zza(this.zzd, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public void showVideo() {
        this.zze.show();
    }

    @Override
    public boolean isInitialized() {
        return this.zzf != null;
    }

    static /* synthetic */ MediationRewardedVideoAdListener zza(AbstractAdViewAdapter abstractAdViewAdapter) {
        return abstractAdViewAdapter.zzf;
    }

    static /* synthetic */ InterstitialAd zza(AbstractAdViewAdapter abstractAdViewAdapter, InterstitialAd interstitialAd) {
        abstractAdViewAdapter.zze = null;
        return null;
    }

    static final class zzb
    extends NativeContentAdMapper {
        private final NativeContentAd zza;

        public zzb(NativeContentAd nativeContentAd) {
            this.zza = nativeContentAd;
            this.setHeadline(nativeContentAd.getHeadline().toString());
            this.setImages(nativeContentAd.getImages());
            this.setBody(nativeContentAd.getBody().toString());
            if (nativeContentAd.getLogo() != null) {
                this.setLogo(nativeContentAd.getLogo());
            }
            this.setCallToAction(nativeContentAd.getCallToAction().toString());
            this.setAdvertiser(nativeContentAd.getAdvertiser().toString());
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
            this.zza(nativeContentAd.getVideoController());
        }

        @Override
        public final void trackView(View view) {
            NativeAdViewHolder nativeAdViewHolder;
            if (view instanceof NativeAdView) {
                ((NativeAdView)view).setNativeAd(this.zza);
            }
            if ((nativeAdViewHolder = NativeAdViewHolder.zza.get(view)) != null) {
                nativeAdViewHolder.setNativeAd(this.zza);
            }
        }
    }

    static final class zzc
    extends com.google.android.gms.ads.mediation.zza {
        private final UnifiedNativeAd zza;

        public zzc(UnifiedNativeAd unifiedNativeAd) {
            this.zza = unifiedNativeAd;
            this.zza(unifiedNativeAd.zza());
            this.zza(unifiedNativeAd.zzb());
            this.zzb(unifiedNativeAd.zzc());
            this.zza(unifiedNativeAd.zzd());
            this.zzc(unifiedNativeAd.zze());
            this.zzd(unifiedNativeAd.zzf());
            this.zza(unifiedNativeAd.zzg());
            this.zze(unifiedNativeAd.zzh());
            this.zzf(unifiedNativeAd.zzi());
            this.zza(unifiedNativeAd.zzk());
            this.zza(true);
            this.zzb(true);
            this.zza(unifiedNativeAd.zzj());
        }

        @Override
        public final void zza(View view, Map<String, View> map, Map<String, View> map2) {
            if (view instanceof com.google.android.gms.ads.formats.zzd) {
                com.google.android.gms.ads.formats.zzd.zza(this.zza);
                return;
            }
        }
    }

    static final class zza
    extends NativeAppInstallAdMapper {
        private final NativeAppInstallAd zza;

        public zza(NativeAppInstallAd nativeAppInstallAd) {
            this.zza = nativeAppInstallAd;
            this.setHeadline(nativeAppInstallAd.getHeadline().toString());
            this.setImages(nativeAppInstallAd.getImages());
            this.setBody(nativeAppInstallAd.getBody().toString());
            this.setIcon(nativeAppInstallAd.getIcon());
            this.setCallToAction(nativeAppInstallAd.getCallToAction().toString());
            if (nativeAppInstallAd.getStarRating() != null) {
                this.setStarRating(nativeAppInstallAd.getStarRating());
            }
            if (nativeAppInstallAd.getStore() != null) {
                this.setStore(nativeAppInstallAd.getStore().toString());
            }
            if (nativeAppInstallAd.getPrice() != null) {
                this.setPrice(nativeAppInstallAd.getPrice().toString());
            }
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
            this.zza(nativeAppInstallAd.getVideoController());
        }

        @Override
        public final void trackView(View view) {
            NativeAdViewHolder nativeAdViewHolder;
            if (view instanceof NativeAdView) {
                ((NativeAdView)view).setNativeAd(this.zza);
            }
            if ((nativeAdViewHolder = NativeAdViewHolder.zza.get(view)) != null) {
                nativeAdViewHolder.setNativeAd(this.zza);
            }
        }
    }

    static final class zzf
    extends AdListener
    implements NativeAppInstallAd.OnAppInstallAdLoadedListener,
    NativeContentAd.OnContentAdLoadedListener,
    NativeCustomTemplateAd.OnCustomClickListener,
    NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener,
    UnifiedNativeAd.zza {
        private AbstractAdViewAdapter zza;
        private MediationNativeListener zzb;

        public zzf(AbstractAdViewAdapter abstractAdViewAdapter, MediationNativeListener mediationNativeListener) {
            this.zza = abstractAdViewAdapter;
            this.zzb = mediationNativeListener;
        }

        @Override
        public final void onAdLoaded() {
        }

        @Override
        public final void onAdFailedToLoad(int n) {
            this.zzb.onAdFailedToLoad(this.zza, n);
        }

        @Override
        public final void onAdOpened() {
            this.zzb.onAdOpened(this.zza);
        }

        @Override
        public final void onAdClosed() {
            this.zzb.onAdClosed(this.zza);
        }

        @Override
        public final void onAdLeftApplication() {
            this.zzb.onAdLeftApplication(this.zza);
        }

        @Override
        public final void onAdClicked() {
            this.zzb.onAdClicked(this.zza);
        }

        @Override
        public final void onAdImpression() {
            this.zzb.onAdImpression(this.zza);
        }

        @Override
        public final void onAppInstallAdLoaded(NativeAppInstallAd nativeAppInstallAd) {
            this.zzb.onAdLoaded(this.zza, new zza(nativeAppInstallAd));
        }

        @Override
        public final void zza(UnifiedNativeAd unifiedNativeAd) {
            this.zzb.zza((MediationNativeAdapter)this.zza, new zzc(unifiedNativeAd));
        }

        @Override
        public final void onContentAdLoaded(NativeContentAd nativeContentAd) {
            this.zzb.onAdLoaded(this.zza, new zzb(nativeContentAd));
        }

        @Override
        public final void onCustomTemplateAdLoaded(NativeCustomTemplateAd nativeCustomTemplateAd) {
            this.zzb.zza((MediationNativeAdapter)this.zza, nativeCustomTemplateAd);
        }

        @Override
        public final void onCustomClick(NativeCustomTemplateAd nativeCustomTemplateAd, String string) {
            this.zzb.zza(this.zza, nativeCustomTemplateAd, string);
        }
    }

    static final class zze
    extends AdListener
    implements zzkf {
        private AbstractAdViewAdapter zza;
        private MediationInterstitialListener zzb;

        public zze(AbstractAdViewAdapter abstractAdViewAdapter, MediationInterstitialListener mediationInterstitialListener) {
            this.zza = abstractAdViewAdapter;
            this.zzb = mediationInterstitialListener;
        }

        @Override
        public final void onAdLoaded() {
            this.zzb.onAdLoaded(this.zza);
        }

        @Override
        public final void onAdFailedToLoad(int n) {
            this.zzb.onAdFailedToLoad(this.zza, n);
        }

        @Override
        public final void onAdOpened() {
            this.zzb.onAdOpened(this.zza);
        }

        @Override
        public final void onAdClosed() {
            this.zzb.onAdClosed(this.zza);
        }

        @Override
        public final void onAdLeftApplication() {
            this.zzb.onAdLeftApplication(this.zza);
        }

        @Override
        public final void onAdClicked() {
            this.zzb.onAdClicked(this.zza);
        }
    }

    static final class zzd
    extends AdListener
    implements AppEventListener,
    zzkf {
        private AbstractAdViewAdapter zza;
        private MediationBannerListener zzb;

        public zzd(AbstractAdViewAdapter abstractAdViewAdapter, MediationBannerListener mediationBannerListener) {
            this.zza = abstractAdViewAdapter;
            this.zzb = mediationBannerListener;
        }

        @Override
        public final void onAdLoaded() {
            this.zzb.onAdLoaded(this.zza);
        }

        @Override
        public final void onAdFailedToLoad(int n) {
            this.zzb.onAdFailedToLoad(this.zza, n);
        }

        @Override
        public final void onAdOpened() {
            this.zzb.onAdOpened(this.zza);
        }

        @Override
        public final void onAdClosed() {
            this.zzb.onAdClosed(this.zza);
        }

        @Override
        public final void onAdLeftApplication() {
            this.zzb.onAdLeftApplication(this.zza);
        }

        @Override
        public final void onAdClicked() {
            this.zzb.onAdClicked(this.zza);
        }

        @Override
        public final void onAppEvent(String string, String string2) {
            this.zzb.zza(this.zza, string, string2);
        }
    }
}

