/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.doubleclick.PublisherAdRequest;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.formats.OnPublisherAdViewLoadedListener;
import com.google.android.gms.ads.formats.PublisherAdViewOptions;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzaky;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzko;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzll;
import com.google.android.gms.internal.zzlo;
import com.google.android.gms.internal.zzmu;
import com.google.android.gms.internal.zzqh;
import com.google.android.gms.internal.zzsq;
import com.google.android.gms.internal.zzsr;
import com.google.android.gms.internal.zzss;
import com.google.android.gms.internal.zzst;
import com.google.android.gms.internal.zzsu;
import com.google.android.gms.internal.zzsw;
import com.google.android.gms.internal.zzwe;

public class AdLoader {
    private final zzkn zza;
    private final Context zzb;
    private final zzll zzc;

    AdLoader(Context context, zzll zzll2) {
        this(context, zzll2, zzkn.zza);
    }

    private AdLoader(Context context, zzll zzll2, zzkn zzkn2) {
        this.zzb = context;
        this.zzc = zzll2;
        this.zza = zzkn2;
    }

    private final void zza(zzmu zzmu2) {
        try {
            this.zzc.zza(zzkn.zza(this.zzb, zzmu2));
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzb("Failed to load ad.", remoteException);
            return;
        }
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(AdRequest adRequest) {
        this.zza(adRequest.zza());
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAds(AdRequest adRequest, int n) {
        zzmu zzmu2 = adRequest.zza();
        AdLoader adLoader = this;
        try {
            adLoader.zzc.zza(zzkn.zza(adLoader.zzb, zzmu2), n);
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzb("Failed to load ads.", remoteException);
            return;
        }
    }

    public void loadAd(PublisherAdRequest publisherAdRequest) {
        this.zza(publisherAdRequest.zza());
    }

    @Deprecated
    public String getMediationAdapterClassName() {
        try {
            return this.zzc.zzb();
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to get the mediation adapter class name.", remoteException);
            return null;
        }
    }

    public boolean isLoading() {
        try {
            return this.zzc.zzc();
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    public static class Builder {
        private final Context zza;
        private final zzlo zzb;

        public Builder(Context context, String string) {
            this((Context)zzbq.zza((Object)context, (Object)"context cannot be null"), zzlc.zzb().zza(context, string, new zzwe()));
        }

        private Builder(Context context, zzlo zzlo2) {
            this.zza = context;
            this.zzb = zzlo2;
        }

        public Builder forContentAd(NativeContentAd.OnContentAdLoadedListener onContentAdLoadedListener) {
            try {
                this.zzb.zza(new zzsr(onContentAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzaky.zzc("Failed to add content ad listener", remoteException);
            }
            return this;
        }

        public Builder forAppInstallAd(NativeAppInstallAd.OnAppInstallAdLoadedListener onAppInstallAdLoadedListener) {
            try {
                this.zzb.zza(new zzsq(onAppInstallAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzaky.zzc("Failed to add app install ad listener", remoteException);
            }
            return this;
        }

        @Hide
        public final Builder zza(UnifiedNativeAd.zza zza2) {
            try {
                this.zzb.zza(new zzsw(zza2));
            }
            catch (RemoteException remoteException) {
                zzaky.zzc("Failed to add google native ad listener", remoteException);
            }
            return this;
        }

        public Builder forCustomTemplateAd(String string, NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener onCustomTemplateAdLoadedListener, NativeCustomTemplateAd.OnCustomClickListener onCustomClickListener) {
            try {
                this.zzb.zza(string, new zzst(onCustomTemplateAdLoadedListener), onCustomClickListener == null ? null : new zzss(onCustomClickListener));
            }
            catch (RemoteException remoteException) {
                zzaky.zzc("Failed to add custom template ad listener", remoteException);
            }
            return this;
        }

        public Builder forPublisherAdView(OnPublisherAdViewLoadedListener onPublisherAdViewLoadedListener, AdSize ... adSizeArray) {
            if (adSizeArray == null || adSizeArray.length <= 0) {
                throw new IllegalArgumentException("The supported ad sizes must contain at least one valid ad size.");
            }
            try {
                zzko zzko2 = new zzko(this.zza, adSizeArray);
                this.zzb.zza(new zzsu(onPublisherAdViewLoadedListener), zzko2);
            }
            catch (RemoteException remoteException) {
                zzaky.zzc("Failed to add publisher banner ad listener", remoteException);
            }
            return this;
        }

        public Builder withAdListener(AdListener adListener) {
            try {
                this.zzb.zza(new zzkh(adListener));
            }
            catch (RemoteException remoteException) {
                zzaky.zzc("Failed to set AdListener.", remoteException);
            }
            return this;
        }

        public Builder withNativeAdOptions(NativeAdOptions nativeAdOptions) {
            try {
                this.zzb.zza(new zzqh(nativeAdOptions));
            }
            catch (RemoteException remoteException) {
                zzaky.zzc("Failed to specify native ad options", remoteException);
            }
            return this;
        }

        public Builder withPublisherAdViewOptions(PublisherAdViewOptions publisherAdViewOptions) {
            try {
                this.zzb.zza(publisherAdViewOptions);
            }
            catch (RemoteException remoteException) {
                zzaky.zzc("Failed to specify DFP banner ad options", remoteException);
            }
            return this;
        }

        public Builder withCorrelator(@NonNull Correlator correlator) {
            zzbq.zza((Object)correlator);
            try {
                this.zzb.zza(correlator.zza());
            }
            catch (RemoteException remoteException) {
                zzaky.zzc("Failed to set correlator.", remoteException);
            }
            return this;
        }

        public AdLoader build() {
            try {
                return new AdLoader(this.zza, this.zzb.zza());
            }
            catch (RemoteException remoteException) {
                zzaky.zzb("Failed to build AdLoader.", remoteException);
                return null;
            }
        }
    }
}

