/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.NetworkExtras;
import com.google.android.gms.ads.mediation.customevent.CustomEvent;
import com.google.android.gms.ads.zza;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzmu;
import com.google.android.gms.internal.zzmv;
import java.util.Date;
import java.util.Set;

public final class AdRequest {
    public static final int ERROR_CODE_INTERNAL_ERROR = 0;
    public static final int ERROR_CODE_INVALID_REQUEST = 1;
    public static final int ERROR_CODE_NETWORK_ERROR = 2;
    public static final int ERROR_CODE_NO_FILL = 3;
    public static final int GENDER_UNKNOWN = 0;
    public static final int GENDER_MALE = 1;
    public static final int GENDER_FEMALE = 2;
    public static final int MAX_CONTENT_URL_LENGTH = 512;
    public static final String DEVICE_ID_EMULATOR = "B3EEABB8EE11C2BE770B684D95219ECB";
    private final zzmu zza;

    private AdRequest(Builder builder) {
        this.zza = new zzmu(builder.zza);
    }

    public final Date getBirthday() {
        return this.zza.zza();
    }

    public final String getContentUrl() {
        return this.zza.zzb();
    }

    public final int getGender() {
        return this.zza.zzc();
    }

    public final Set<String> getKeywords() {
        return this.zza.zzd();
    }

    public final Location getLocation() {
        return this.zza.zze();
    }

    @Deprecated
    public final <T extends NetworkExtras> T getNetworkExtras(Class<T> clazz) {
        return this.zza.zza(clazz);
    }

    public final <T extends MediationAdapter> Bundle getNetworkExtrasBundle(Class<T> clazz) {
        return this.zza.zzb(clazz);
    }

    public final <T extends CustomEvent> Bundle getCustomEventExtrasBundle(Class<T> clazz) {
        return this.zza.zzc(clazz);
    }

    public final boolean isTestDevice(Context context) {
        return this.zza.zza(context);
    }

    @Hide
    public final zzmu zza() {
        return this.zza;
    }

    /* synthetic */ AdRequest(Builder builder, zza zza2) {
        this(builder);
    }

    public static final class Builder {
        private final zzmv zza = new zzmv();

        public Builder() {
            this.zza.zzb(AdRequest.DEVICE_ID_EMULATOR);
        }

        public final Builder addKeyword(String string) {
            this.zza.zza(string);
            return this;
        }

        public final Builder addNetworkExtras(NetworkExtras networkExtras) {
            this.zza.zza(networkExtras);
            return this;
        }

        public final Builder addNetworkExtrasBundle(Class<? extends MediationAdapter> clazz, Bundle bundle) {
            this.zza.zza(clazz, bundle);
            if (clazz.equals(AdMobAdapter.class) && bundle.getBoolean("_emulatorLiveAds")) {
                this.zza.zzc(AdRequest.DEVICE_ID_EMULATOR);
            }
            return this;
        }

        public final Builder addCustomEventExtrasBundle(Class<? extends CustomEvent> clazz, Bundle bundle) {
            this.zza.zzb(clazz, bundle);
            return this;
        }

        public final Builder addTestDevice(String string) {
            this.zza.zzb(string);
            return this;
        }

        public final AdRequest build() {
            return new AdRequest(this, null);
        }

        public final Builder setBirthday(Date date) {
            this.zza.zza(date);
            return this;
        }

        public final Builder setContentUrl(String string) {
            zzbq.zza((Object)string, (Object)"Content URL must be non-null.");
            zzbq.zza((String)string, (Object)"Content URL must be non-empty.");
            zzbq.zzb((string.length() <= 512 ? 1 : 0) != 0, (String)"Content URL must not exceed %d in length.  Provided length was %d.", (Object[])new Object[]{512, string.length()});
            this.zza.zzd(string);
            return this;
        }

        public final Builder setGender(int n) {
            this.zza.zza(n);
            return this;
        }

        public final Builder setLocation(Location location) {
            this.zza.zza(location);
            return this;
        }

        public final Builder setRequestAgent(String string) {
            this.zza.zzf(string);
            return this;
        }

        public final Builder tagForChildDirectedTreatment(boolean bl) {
            this.zza.zzb(bl);
            return this;
        }

        public final Builder setIsDesignedForFamilies(boolean bl) {
            this.zza.zzc(bl);
            return this;
        }
    }
}

