/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.os.RemoteException;
import android.support.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzaky;
import com.google.android.gms.internal.zzmm;
import com.google.android.gms.internal.zznr;

@zzabh
public final class VideoController {
    @Hide
    @KeepForSdk
    public static final int PLAYBACK_STATE_UNKNOWN = 0;
    @Hide
    @KeepForSdk
    public static final int PLAYBACK_STATE_PLAYING = 1;
    @Hide
    @KeepForSdk
    public static final int PLAYBACK_STATE_PAUSED = 2;
    @Hide
    @KeepForSdk
    public static final int PLAYBACK_STATE_ENDED = 3;
    @Hide
    @KeepForSdk
    public static final int PLAYBACK_STATE_READY = 5;
    private final Object zza = new Object();
    @Nullable
    private zzmm zzb;
    @Nullable
    private VideoLifecycleCallbacks zzc;

    @Hide
    public VideoController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    public final void zza(zzmm zzmm2) {
        Object object = this.zza;
        synchronized (object) {
            this.zzb = zzmm2;
            if (this.zzc != null) {
                this.setVideoLifecycleCallbacks(this.zzc);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    public final zzmm zza() {
        Object object = this.zza;
        synchronized (object) {
            return this.zzb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    @KeepForSdk
    public final void play() {
        Object object = this.zza;
        synchronized (object) {
            if (this.zzb == null) {
                return;
            }
            try {
                this.zzb.zza();
            }
            catch (RemoteException remoteException) {
                zzaky.zzb("Unable to call play on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    @KeepForSdk
    public final void pause() {
        Object object = this.zza;
        synchronized (object) {
            if (this.zzb == null) {
                return;
            }
            try {
                this.zzb.zzb();
            }
            catch (RemoteException remoteException) {
                zzaky.zzb("Unable to call pause on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    @KeepForSdk
    public final void mute(boolean bl) {
        Object object = this.zza;
        synchronized (object) {
            if (this.zzb == null) {
                return;
            }
            try {
                this.zzb.zza(bl);
            }
            catch (RemoteException remoteException) {
                zzaky.zzb("Unable to call mute on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    @KeepForSdk
    public final boolean isMuted() {
        Object object = this.zza;
        synchronized (object) {
            if (this.zzb == null) {
                return true;
            }
            try {
                return this.zzb.zzc();
            }
            catch (RemoteException remoteException) {
                zzaky.zzb("Unable to call isMuted on video controller.", remoteException);
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    @KeepForSdk
    public final int getPlaybackState() {
        Object object = this.zza;
        synchronized (object) {
            if (this.zzb == null) {
                return 0;
            }
            try {
                return this.zzb.zzd();
            }
            catch (RemoteException remoteException) {
                zzaky.zzb("Unable to call getPlaybackState on video controller.", remoteException);
                return 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    @KeepForSdk
    public final boolean isCustomControlsEnabled() {
        Object object = this.zza;
        synchronized (object) {
            if (this.zzb == null) {
                return false;
            }
            try {
                return this.zzb.zzh();
            }
            catch (RemoteException remoteException) {
                zzaky.zzb("Unable to call isUsingCustomPlayerControls.", remoteException);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    @KeepForSdk
    public final boolean isClickToExpandEnabled() {
        Object object = this.zza;
        synchronized (object) {
            if (this.zzb == null) {
                return false;
            }
            try {
                return this.zzb.zzj();
            }
            catch (RemoteException remoteException) {
                zzaky.zzb("Unable to call isClickToExpandEnabled.", remoteException);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setVideoLifecycleCallbacks(VideoLifecycleCallbacks videoLifecycleCallbacks) {
        zzbq.zza((Object)videoLifecycleCallbacks, (Object)"VideoLifecycleCallbacks may not be null.");
        Object object = this.zza;
        synchronized (object) {
            this.zzc = videoLifecycleCallbacks;
            if (this.zzb == null) {
                return;
            }
            try {
                this.zzb.zza(new zznr(videoLifecycleCallbacks));
            }
            catch (RemoteException remoteException) {
                zzaky.zzb("Unable to call setVideoLifecycleCallbacks on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final VideoLifecycleCallbacks getVideoLifecycleCallbacks() {
        Object object = this.zza;
        synchronized (object) {
            return this.zzc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasVideoContent() {
        Object object = this.zza;
        synchronized (object) {
            return this.zzb != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final float getAspectRatio() {
        Object object = this.zza;
        synchronized (object) {
            if (this.zzb == null) {
                return 0.0f;
            }
            try {
                return this.zzb.zzg();
            }
            catch (RemoteException remoteException) {
                zzaky.zzb("Unable to call getAspectRatio on video controller.", remoteException);
                return 0.0f;
            }
        }
    }

    public static abstract class VideoLifecycleCallbacks {
        public VideoLifecycleCallbacks() {
        }

        public void onVideoStart() {
        }

        public void onVideoPlay() {
        }

        public void onVideoPause() {
        }

        public void onVideoEnd() {
        }

        public void onVideoMute(boolean bl) {
        }
    }
}

