/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Looper;
import android.text.TextUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.ads.zzaem;
import com.google.android.gms.internal.ads.zzaen;
import com.google.android.gms.internal.ads.zzaeo;
import com.google.android.gms.internal.ads.zzaep;
import com.google.android.gms.internal.ads.zzaeq;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzaoa;
import com.google.android.gms.internal.ads.zzaok;
import com.google.android.gms.internal.ads.zzaoo;
import com.google.android.gms.internal.ads.zzaop;
import com.google.android.gms.internal.ads.zzbbe;
import com.google.android.gms.internal.ads.zzkd;
import com.google.android.gms.internal.ads.zznl;
import com.google.android.gms.internal.ads.zznw;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.ParametersAreNonnullByDefault;

@zzaer
@ParametersAreNonnullByDefault
public final class zzael
implements zzaep {
    private static final Object sLock = new Object();
    @VisibleForTesting
    private static zzaep zzcfl = null;
    @VisibleForTesting
    private static zzaep zzcfm = null;
    private final Object zzcfn = new Object();
    private final Context zzcfo;
    private final WeakHashMap<Thread, Boolean> zzcfp = new WeakHashMap();
    private final ExecutorService zzry = Executors.newCachedThreadPool();
    private final zzaop zzaak;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzaep zzm(Context context) {
        Object object = sLock;
        synchronized (object) {
            if (zzcfl == null) {
                zznl<Boolean> zznl2 = zznw.zzayi;
                zzcfl = zzkd.zzjd().zzd(zznl2) != false ? new zzael(context) : new zzaeq();
            }
        }
        return zzcfl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzaep zzc(Context context, zzaop zzaop2) {
        Object object = sLock;
        synchronized (object) {
            if (zzcfm == null) {
                Object object2 = zznw.zzayi;
                if (zzkd.zzjd().zzd(object2).booleanValue()) {
                    zzael zzael2 = new zzael(context, zzaop2);
                    Thread thread = Looper.getMainLooper().getThread();
                    zzael zzael3 = zzael2;
                    if (thread != null) {
                        Object object3 = zzael3.zzcfn;
                        synchronized (object3) {
                            zzael3.zzcfp.put(thread, true);
                        }
                        object3 = thread.getUncaughtExceptionHandler();
                        thread.setUncaughtExceptionHandler(new zzaen(zzael3, (Thread.UncaughtExceptionHandler)object3));
                    }
                    object2 = zzael2;
                    Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                    Thread.setDefaultUncaughtExceptionHandler(new zzaem((zzael)object2, uncaughtExceptionHandler));
                    zzcfm = zzael2;
                } else {
                    zzcfm = new zzaeq();
                }
            }
        }
        return zzcfm;
    }

    private zzael(Context context) {
        this(context, zzaop.zztz());
    }

    private zzael(Context context, zzaop zzaop2) {
        this.zzcfo = context.getApplicationContext() != null ? context.getApplicationContext() : context;
        this.zzaak = zzaop2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void zza(Thread thread, Throwable throwable) {
        Throwable throwable2;
        zzael zzael2 = this;
        if (throwable2 == null) return;
        boolean bl = false;
        boolean bl2 = false;
        for (throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            for (StackTraceElement stackTraceElement : throwable2.getStackTrace()) {
                if (zzaoa.zzdk(stackTraceElement.getClassName())) {
                    bl = true;
                }
                if (!zzael2.getClass().getName().equals(stackTraceElement.getClassName())) continue;
                bl2 = true;
            }
        }
        if (!bl) return;
        if (bl2) return;
        boolean bl3 = true;
        if (!bl3) return;
        throwable2 = throwable;
        String string = "";
        Throwable throwable3 = throwable2;
        this.zza(throwable2, string, 1.0f);
    }

    @Override
    public final void zza(Throwable throwable, String string) {
        this.zza(throwable, string, 1.0f);
    }

    @Override
    public final void zza(Throwable throwable, String string, float f) {
        if (zzaoa.zzc(throwable) == null) {
            return;
        }
        String string2 = throwable.getClass().getName();
        StringWriter stringWriter = new StringWriter();
        zzbbe.zza((Throwable)throwable, (PrintWriter)new PrintWriter(stringWriter));
        String string3 = stringWriter.toString();
        boolean bl = Math.random() < (double)f;
        int n = f > 0.0f ? (int)(1.0f / f) : 1;
        if (bl) {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = n;
            String string4 = string;
            String string5 = string3;
            Object object = string2;
            arrayList.add(this.zza((String)object, string5, string4, n2).toString());
            object = arrayList;
            zzael zzael2 = this;
            ArrayList arrayList2 = (ArrayList)object;
            int n3 = arrayList2.size();
            string5 = null;
            for (int i = 0; i < n3; ++i) {
                Object e = arrayList2.get(i);
                string4 = (String)e;
                zzaoo zzaoo2 = new zzaoo();
                zzael2.zzry.submit(new zzaeo(zzael2, zzaoo2, string4));
            }
        }
    }

    @VisibleForTesting
    private final Uri.Builder zza(String string, String string2, String string3, int n) {
        boolean bl = false;
        try {
            bl = Wrappers.packageManager((Context)this.zzcfo).isCallerInstantApp();
        }
        catch (Throwable throwable) {
            zzaok.zzb("Error fetching instant app info", throwable);
        }
        String string4 = "unknown";
        try {
            string4 = this.zzcfo.getPackageName();
        }
        catch (Throwable throwable) {
            zzaok.zzdp("Cannot obtain package name, proceeding.");
        }
        String string5 = Build.MANUFACTURER;
        String string6 = Build.MODEL;
        zznl<String> zznl2 = zznw.zzbij;
        return new Uri.Builder().scheme("https").path("//pagead2.googlesyndication.com/pagead/gen_204").appendQueryParameter("is_aia", Boolean.toString(bl)).appendQueryParameter("id", "gmob-apps-report-exception").appendQueryParameter("os", Build.VERSION.RELEASE).appendQueryParameter("api", String.valueOf(Build.VERSION.SDK_INT)).appendQueryParameter("device", string6.startsWith(string5) ? string6 : new StringBuilder(1 + String.valueOf(string5).length() + String.valueOf(string6).length()).append(string5).append(" ").append(string6).toString()).appendQueryParameter("js", this.zzaak.zzcx).appendQueryParameter("appid", string4).appendQueryParameter("exceptiontype", string).appendQueryParameter("stacktrace", string2).appendQueryParameter("eids", TextUtils.join((CharSequence)",", zznw.zzjz())).appendQueryParameter("exceptionkey", string3).appendQueryParameter("cl", "215809645").appendQueryParameter("rc", "dev").appendQueryParameter("session_id", zzkd.zzje()).appendQueryParameter("sampling_rate", Integer.toString(n)).appendQueryParameter("pb_tm", String.valueOf(zzkd.zzjd().zzd(zznl2)));
    }
}

