/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzaok;
import com.google.android.gms.internal.ads.zzjc;
import com.google.android.gms.internal.ads.zzjd;
import com.google.android.gms.internal.ads.zzjg;
import com.google.android.gms.internal.ads.zzjn;
import com.google.android.gms.internal.ads.zzjo;
import com.google.android.gms.internal.ads.zzjq;
import com.google.android.gms.internal.ads.zzjr;
import com.google.android.gms.internal.ads.zzjs;
import com.google.android.gms.internal.ads.zzjt;
import com.google.android.gms.internal.ads.zzjv;
import com.google.android.gms.internal.ads.zzkd;
import com.google.android.gms.internal.ads.zzkf;
import com.google.android.gms.internal.ads.zzku;
import com.google.android.gms.internal.ads.zzly;
import com.google.android.gms.internal.ads.zzmg;
import com.google.android.gms.internal.ads.zzmj;
import com.google.android.gms.internal.ads.zznf;
import com.google.android.gms.internal.ads.zzos;
import com.google.android.gms.internal.ads.zzym;
import java.util.concurrent.atomic.AtomicBoolean;

@zzaer
public final class zzmi {
    private final zzym zzawp = new zzym();
    private final zzjn zzuv;
    private final AtomicBoolean zzawq;
    private final VideoController zzawr = new VideoController();
    @VisibleForTesting
    private final zzkf zzaws = new zzmj(this);
    private zzjc zzatc;
    private AdListener zzatf;
    private AdSize[] zzauw;
    private AppEventListener zzwb;
    private Correlator zzawt;
    private zzku zzawu;
    private OnCustomRenderedAdLoadedListener zzawv;
    private VideoOptions zzvs;
    private String zzyr;
    private ViewGroup zzaww;
    private int zzawx;
    private boolean zzvz;

    public zzmi(ViewGroup viewGroup) {
        this(viewGroup, null, false, zzjn.zzaup, 0);
    }

    public zzmi(ViewGroup viewGroup, int n) {
        this(viewGroup, null, false, zzjn.zzaup, n);
    }

    public zzmi(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl) {
        this(viewGroup, attributeSet, bl, zzjn.zzaup, 0);
    }

    public zzmi(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, int n) {
        this(viewGroup, attributeSet, false, zzjn.zzaup, n);
    }

    @VisibleForTesting
    private zzmi(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzjn zzjn2, zzku zzku2, int n) {
        this.zzaww = viewGroup;
        this.zzuv = zzjn2;
        this.zzawu = null;
        this.zzawq = new AtomicBoolean(false);
        this.zzawx = n;
        if (attributeSet != null) {
            Context context = viewGroup.getContext();
            try {
                zzjr zzjr2 = new zzjr(context, attributeSet);
                this.zzauw = zzjr2.zzi(bl);
                this.zzyr = zzjr2.getAdUnitId();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzkd.zziz().zza(viewGroup, new zzjo(context, AdSize.BANNER), illegalArgumentException.getMessage(), illegalArgumentException.getMessage());
                return;
            }
            if (viewGroup.isInEditMode()) {
                boolean bl2;
                int n2 = this.zzawx;
                AdSize adSize = this.zzauw[0];
                Context context2 = context;
                zzjo zzjo2 = new zzjo(context2, adSize);
                new zzjo(context2, adSize).zzauv = bl2 = zzmi.zzz(n2);
                zzkd.zziz().zza(viewGroup, zzjo2, "Ads by Google");
            }
        }
    }

    @VisibleForTesting
    private zzmi(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzjn zzjn2, int n) {
        this(viewGroup, attributeSet, bl, zzjn2, null, n);
    }

    public final void destroy() {
        try {
            if (this.zzawu != null) {
                this.zzawu.destroy();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final AdListener getAdListener() {
        return this.zzatf;
    }

    public final AdSize getAdSize() {
        try {
            zzjo zzjo2;
            if (this.zzawu != null && (zzjo2 = this.zzawu.zzbk()) != null) {
                return zzjo2.zzit();
            }
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
        }
        if (this.zzauw != null) {
            return this.zzauw[0];
        }
        return null;
    }

    public final AdSize[] getAdSizes() {
        return this.zzauw;
    }

    public final String getAdUnitId() {
        if (this.zzyr == null && this.zzawu != null) {
            try {
                this.zzyr = this.zzawu.getAdUnitId();
            }
            catch (RemoteException remoteException) {
                zzaok.zzd("#007 Could not call remote method.", remoteException);
            }
        }
        return this.zzyr;
    }

    public final AppEventListener getAppEventListener() {
        return this.zzwb;
    }

    public final OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzawv;
    }

    public final void zza(zzmg zzmg2) {
        try {
            if (this.zzawu == null) {
                zzku zzku2;
                zzjo zzjo2;
                zzmi zzmi2 = this;
                if ((zzmi2.zzauw == null || zzmi2.zzyr == null) && zzmi2.zzawu == null) {
                    throw new IllegalStateException("The ad size and ad unit ID must be set before loadAd is called.");
                }
                zzmi zzmi3 = zzmi2;
                Context context = zzmi3.zzaww.getContext();
                Object object = zzjo2 = zzmi.zza(context, zzmi3.zzauw, zzmi3.zzawx);
                if ("search_v2".equals(object.zzauq)) {
                    String string = zzmi3.zzyr;
                    zzjo zzjo3 = zzjo2;
                    Context context2 = context;
                    object = zzkd.zzja();
                    Context context3 = context2;
                    zzku2 = (zzku)new zzjv((zzjs)object, context2, zzjo3, string).zzc(context3, false);
                } else {
                    zzym zzym2 = zzmi3.zzawp;
                    String string = zzmi3.zzyr;
                    zzjo zzjo4 = zzjo2;
                    Context context4 = context;
                    object = zzkd.zzja();
                    Context context5 = context4;
                    zzku2 = (zzku)new zzjt((zzjs)object, context4, zzjo4, string, zzym2).zzc(context5, false);
                }
                zzmi2.zzawu = zzku2;
                zzmi2.zzawu.zza(new zzjg(zzmi2.zzaws));
                if (zzmi2.zzatc != null) {
                    zzmi2.zzawu.zza(new zzjd(zzmi2.zzatc));
                }
                if (zzmi2.zzwb != null) {
                    zzmi2.zzawu.zza(new zzjq(zzmi2.zzwb));
                }
                if (zzmi2.zzawv != null) {
                    zzmi2.zzawu.zza(new zzos(zzmi2.zzawv));
                }
                if (zzmi2.zzawt != null) {
                    zzmi2.zzawu.zza(zzmi2.zzawt.zzaz());
                }
                if (zzmi2.zzvs != null) {
                    zzmi2.zzawu.zza(new zznf(zzmi2.zzvs));
                }
                zzmi2.zzawu.setManualImpressionsEnabled(zzmi2.zzvz);
                zzmi zzmi4 = zzmi2;
                try {
                    IObjectWrapper iObjectWrapper = zzmi4.zzawu.zzbj();
                    if (iObjectWrapper != null) {
                        zzmi4.zzaww.addView((View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
                    }
                }
                catch (RemoteException remoteException) {
                    zzaok.zzd("#007 Could not call remote method.", remoteException);
                }
            }
            if (this.zzawu.zzb(zzjn.zza(this.zzaww.getContext(), zzmg2))) {
                this.zzawp.zzj(zzmg2.zzjo());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void pause() {
        try {
            if (this.zzawu != null) {
                this.zzawu.pause();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void recordManualImpression() {
        if (this.zzawq.getAndSet(true)) {
            return;
        }
        try {
            if (this.zzawu != null) {
                this.zzawu.zzbm();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void resume() {
        try {
            if (this.zzawu != null) {
                this.zzawu.resume();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setAdListener(AdListener adListener) {
        this.zzatf = adListener;
        this.zzaws.zza(adListener);
    }

    public final void zza(zzjc zzjc2) {
        try {
            this.zzatc = zzjc2;
            if (this.zzawu != null) {
                this.zzawu.zza(zzjc2 != null ? new zzjd(zzjc2) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setAdSizes(AdSize ... adSizeArray) {
        if (this.zzauw != null) {
            throw new IllegalStateException("The ad size can only be set once on AdView.");
        }
        this.zza(adSizeArray);
    }

    public final void zza(AdSize ... adSizeArray) {
        this.zzauw = adSizeArray;
        try {
            if (this.zzawu != null) {
                this.zzawu.zza(zzmi.zza(this.zzaww.getContext(), this.zzauw, this.zzawx));
            }
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
        }
        this.zzaww.requestLayout();
    }

    public final void setAdUnitId(String string) {
        if (this.zzyr != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on AdView.");
        }
        this.zzyr = string;
    }

    public final void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzwb = appEventListener;
            if (this.zzawu != null) {
                this.zzawu.zza(appEventListener != null ? new zzjq(appEventListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        this.zzawv = onCustomRenderedAdLoadedListener;
        try {
            if (this.zzawu != null) {
                this.zzawu.zza(onCustomRenderedAdLoadedListener != null ? new zzos(onCustomRenderedAdLoadedListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setManualImpressionsEnabled(boolean bl) {
        this.zzvz = bl;
        try {
            if (this.zzawu != null) {
                this.zzawu.setManualImpressionsEnabled(this.zzvz);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setCorrelator(Correlator correlator) {
        this.zzawt = correlator;
        try {
            if (this.zzawu != null) {
                this.zzawu.zza(this.zzawt == null ? null : this.zzawt.zzaz());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final String getMediationAdapterClassName() {
        try {
            if (this.zzawu != null) {
                return this.zzawu.zzcj();
            }
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
        }
        return null;
    }

    public final boolean isLoading() {
        try {
            if (this.zzawu != null) {
                return this.zzawu.isLoading();
            }
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
        }
        return false;
    }

    public final VideoController getVideoController() {
        return this.zzawr;
    }

    public final zzly zzbb() {
        if (this.zzawu == null) {
            return null;
        }
        try {
            return this.zzawu.getVideoController();
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
            return null;
        }
    }

    public final void setVideoOptions(VideoOptions videoOptions) {
        this.zzvs = videoOptions;
        try {
            if (this.zzawu != null) {
                this.zzawu.zza(videoOptions == null ? null : new zznf(videoOptions));
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final VideoOptions getVideoOptions() {
        return this.zzvs;
    }

    public final boolean zza(zzku zzku2) {
        IObjectWrapper iObjectWrapper;
        if (zzku2 == null) {
            return false;
        }
        try {
            iObjectWrapper = zzku2.zzbj();
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
            return false;
        }
        if (iObjectWrapper == null) {
            return false;
        }
        if (((View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper)).getParent() != null) {
            return false;
        }
        this.zzaww.addView((View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        this.zzawu = zzku2;
        return true;
    }

    private static zzjo zza(Context context, AdSize[] adSizeArray, int n) {
        boolean bl;
        zzjo zzjo2 = new zzjo(context, adSizeArray);
        new zzjo(context, adSizeArray).zzauv = bl = zzmi.zzz(n);
        return zzjo2;
    }

    private static boolean zzz(int n) {
        return n == 1;
    }

    static /* synthetic */ VideoController zza(zzmi zzmi2) {
        return zzmi2.zzawr;
    }
}

