/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.doubleclick.PublisherAdRequest;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.formats.OnPublisherAdViewLoadedListener;
import com.google.android.gms.ads.formats.PublisherAdViewOptions;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzaaz;
import com.google.android.gms.internal.ads.zzady;
import com.google.android.gms.internal.ads.zzagm;
import com.google.android.gms.internal.ads.zzagn;
import com.google.android.gms.internal.ads.zzago;
import com.google.android.gms.internal.ads.zzagp;
import com.google.android.gms.internal.ads.zzagq;
import com.google.android.gms.internal.ads.zzags;
import com.google.android.gms.internal.ads.zzamo;
import com.google.android.gms.internal.ads.zzbad;
import com.google.android.gms.internal.ads.zzxv;
import com.google.android.gms.internal.ads.zzyc;
import com.google.android.gms.internal.ads.zzyd;
import com.google.android.gms.internal.ads.zzyt;
import com.google.android.gms.internal.ads.zzzc;
import com.google.android.gms.internal.ads.zzzf;

public class AdLoader {
    private final zzyc zzaaj;
    private final Context zzlj;
    private final zzzc zzaak;

    AdLoader(Context context, zzzc zzzc2) {
        this(context, zzzc2, zzyc.zzche);
    }

    private AdLoader(Context context, zzzc zzzc2, zzyc zzyc2) {
        this.zzlj = context;
        this.zzaak = zzzc2;
        this.zzaaj = zzyc2;
    }

    private final void zza(zzaaz zzaaz2) {
        try {
            this.zzaak.zza(zzyc.zza(this.zzlj, zzaaz2));
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zzc("Failed to load ad.", remoteException);
            return;
        }
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(AdRequest adRequest) {
        this.zza(adRequest.zzde());
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAds(AdRequest adRequest, int n) {
        zzaaz zzaaz2 = adRequest.zzde();
        AdLoader adLoader = this;
        try {
            adLoader.zzaak.zza(zzyc.zza(adLoader.zzlj, zzaaz2), n);
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zzc("Failed to load ads.", remoteException);
            return;
        }
    }

    public void loadAd(PublisherAdRequest publisherAdRequest) {
        this.zza(publisherAdRequest.zzde());
    }

    @Deprecated
    public String getMediationAdapterClassName() {
        try {
            return this.zzaak.zzpj();
        }
        catch (RemoteException remoteException) {
            zzbad.zzd("Failed to get the mediation adapter class name.", remoteException);
            return null;
        }
    }

    public boolean isLoading() {
        try {
            return this.zzaak.isLoading();
        }
        catch (RemoteException remoteException) {
            zzbad.zzd("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    public static class Builder {
        private final Context zzlj;
        private final zzzf zzaal;

        public Builder(Context context, String string) {
            this((Context)Preconditions.checkNotNull((Object)context, (Object)"context cannot be null"), zzyt.zzpb().zzb(context, string, new zzamo()));
        }

        private Builder(Context context, zzzf zzzf2) {
            this.zzlj = context;
            this.zzaal = zzzf2;
        }

        @Deprecated
        public Builder forContentAd(NativeContentAd.OnContentAdLoadedListener onContentAdLoadedListener) {
            try {
                this.zzaal.zza(new zzagn(onContentAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzbad.zzd("Failed to add content ad listener", remoteException);
            }
            return this;
        }

        @Deprecated
        public Builder forAppInstallAd(NativeAppInstallAd.OnAppInstallAdLoadedListener onAppInstallAdLoadedListener) {
            try {
                this.zzaal.zza(new zzagm(onAppInstallAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzbad.zzd("Failed to add app install ad listener", remoteException);
            }
            return this;
        }

        public Builder forUnifiedNativeAd(UnifiedNativeAd.OnUnifiedNativeAdLoadedListener onUnifiedNativeAdLoadedListener) {
            try {
                this.zzaal.zza(new zzags(onUnifiedNativeAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzbad.zzd("Failed to add google native ad listener", remoteException);
            }
            return this;
        }

        public Builder forCustomTemplateAd(String string, NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener onCustomTemplateAdLoadedListener, NativeCustomTemplateAd.OnCustomClickListener onCustomClickListener) {
            try {
                this.zzaal.zza(string, new zzagp(onCustomTemplateAdLoadedListener), onCustomClickListener == null ? null : new zzago(onCustomClickListener));
            }
            catch (RemoteException remoteException) {
                zzbad.zzd("Failed to add custom template ad listener", remoteException);
            }
            return this;
        }

        public Builder forPublisherAdView(OnPublisherAdViewLoadedListener onPublisherAdViewLoadedListener, AdSize ... adSizeArray) {
            if (adSizeArray == null || adSizeArray.length <= 0) {
                throw new IllegalArgumentException("The supported ad sizes must contain at least one valid ad size.");
            }
            try {
                zzyd zzyd2 = new zzyd(this.zzlj, adSizeArray);
                this.zzaal.zza(new zzagq(onPublisherAdViewLoadedListener), zzyd2);
            }
            catch (RemoteException remoteException) {
                zzbad.zzd("Failed to add publisher banner ad listener", remoteException);
            }
            return this;
        }

        public Builder withAdListener(AdListener adListener) {
            try {
                this.zzaal.zza(new zzxv(adListener));
            }
            catch (RemoteException remoteException) {
                zzbad.zzd("Failed to set AdListener.", remoteException);
            }
            return this;
        }

        public Builder withNativeAdOptions(NativeAdOptions nativeAdOptions) {
            try {
                this.zzaal.zza(new zzady(nativeAdOptions));
            }
            catch (RemoteException remoteException) {
                zzbad.zzd("Failed to specify native ad options", remoteException);
            }
            return this;
        }

        public Builder withPublisherAdViewOptions(PublisherAdViewOptions publisherAdViewOptions) {
            try {
                this.zzaal.zza(publisherAdViewOptions);
            }
            catch (RemoteException remoteException) {
                zzbad.zzd("Failed to specify DFP banner ad options", remoteException);
            }
            return this;
        }

        public Builder withCorrelator(@NonNull Correlator correlator) {
            Preconditions.checkNotNull((Object)correlator);
            try {
                this.zzaal.zza(correlator.zzaar);
            }
            catch (RemoteException remoteException) {
                zzbad.zzd("Failed to set correlator.", remoteException);
            }
            return this;
        }

        public AdLoader build() {
            try {
                return new AdLoader(this.zzlj, this.zzaal.zzpk());
            }
            catch (RemoteException remoteException) {
                zzbad.zzc("Failed to build AdLoader.", remoteException);
                return null;
            }
        }
    }
}

