/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.os.RemoteException;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzaar;
import com.google.android.gms.internal.ads.zzacc;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzbad;
import javax.annotation.concurrent.GuardedBy;

@zzard
public final class VideoController {
    @KeepForSdk
    public static final int PLAYBACK_STATE_UNKNOWN = 0;
    @KeepForSdk
    public static final int PLAYBACK_STATE_PLAYING = 1;
    @KeepForSdk
    public static final int PLAYBACK_STATE_PAUSED = 2;
    @KeepForSdk
    public static final int PLAYBACK_STATE_ENDED = 3;
    @KeepForSdk
    public static final int PLAYBACK_STATE_READY = 5;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    @Nullable
    private zzaar zzaav;
    @GuardedBy(value="lock")
    @Nullable
    private VideoLifecycleCallbacks zzaaw;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzaar zzaar2) {
        Object object = this.lock;
        synchronized (object) {
            this.zzaav = zzaar2;
            if (this.zzaaw != null) {
                this.setVideoLifecycleCallbacks(this.zzaaw);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzaar zzdh() {
        Object object = this.lock;
        synchronized (object) {
            return this.zzaav;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void play() {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzaav == null) {
                return;
            }
            try {
                this.zzaav.play();
            }
            catch (RemoteException remoteException) {
                zzbad.zzc("Unable to call play on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pause() {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzaav == null) {
                return;
            }
            try {
                this.zzaav.pause();
            }
            catch (RemoteException remoteException) {
                zzbad.zzc("Unable to call pause on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void mute(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzaav == null) {
                return;
            }
            try {
                this.zzaav.mute(bl);
            }
            catch (RemoteException remoteException) {
                zzbad.zzc("Unable to call mute on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isMuted() {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzaav == null) {
                return true;
            }
            try {
                return this.zzaav.isMuted();
            }
            catch (RemoteException remoteException) {
                zzbad.zzc("Unable to call isMuted on video controller.", remoteException);
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final int getPlaybackState() {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzaav == null) {
                return 0;
            }
            try {
                return this.zzaav.getPlaybackState();
            }
            catch (RemoteException remoteException) {
                zzbad.zzc("Unable to call getPlaybackState on video controller.", remoteException);
                return 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isCustomControlsEnabled() {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzaav == null) {
                return false;
            }
            try {
                return this.zzaav.isCustomControlsEnabled();
            }
            catch (RemoteException remoteException) {
                zzbad.zzc("Unable to call isUsingCustomPlayerControls.", remoteException);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isClickToExpandEnabled() {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzaav == null) {
                return false;
            }
            try {
                return this.zzaav.isClickToExpandEnabled();
            }
            catch (RemoteException remoteException) {
                zzbad.zzc("Unable to call isClickToExpandEnabled.", remoteException);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setVideoLifecycleCallbacks(VideoLifecycleCallbacks videoLifecycleCallbacks) {
        Preconditions.checkNotNull((Object)videoLifecycleCallbacks, (Object)"VideoLifecycleCallbacks may not be null.");
        Object object = this.lock;
        synchronized (object) {
            this.zzaaw = videoLifecycleCallbacks;
            if (this.zzaav == null) {
                return;
            }
            try {
                this.zzaav.zza(new zzacc(videoLifecycleCallbacks));
            }
            catch (RemoteException remoteException) {
                zzbad.zzc("Unable to call setVideoLifecycleCallbacks on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final VideoLifecycleCallbacks getVideoLifecycleCallbacks() {
        Object object = this.lock;
        synchronized (object) {
            return this.zzaaw;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasVideoContent() {
        Object object = this.lock;
        synchronized (object) {
            return this.zzaav != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final float getAspectRatio() {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzaav == null) {
                return 0.0f;
            }
            try {
                return this.zzaav.getAspectRatio();
            }
            catch (RemoteException remoteException) {
                zzbad.zzc("Unable to call getAspectRatio on video controller.", remoteException);
                return 0.0f;
            }
        }
    }

    public static abstract class VideoLifecycleCallbacks {
        public void onVideoStart() {
        }

        public void onVideoPlay() {
        }

        public void onVideoPause() {
        }

        public void onVideoEnd() {
        }

        public void onVideoMute(boolean bl) {
        }
    }
}

