/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.RemoteException;
import com.google.android.gms.ads.mediation.rtb.RtbAdapter;
import com.google.android.gms.ads.reward.RewardedVideoAd;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzaab;
import com.google.android.gms.internal.ads.zzabf;
import com.google.android.gms.internal.ads.zzabg;
import com.google.android.gms.internal.ads.zzabi;
import com.google.android.gms.internal.ads.zzacu;
import com.google.android.gms.internal.ads.zzami;
import com.google.android.gms.internal.ads.zzamo;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzasw;
import com.google.android.gms.internal.ads.zzatj;
import com.google.android.gms.internal.ads.zzbad;
import com.google.android.gms.internal.ads.zztw;
import com.google.android.gms.internal.ads.zztx;
import com.google.android.gms.internal.ads.zzyh;
import com.google.android.gms.internal.ads.zzyn;
import com.google.android.gms.internal.ads.zzyq;
import com.google.android.gms.internal.ads.zzyt;
import javax.annotation.concurrent.GuardedBy;

@zzard
public final class zzabe {
    @GuardedBy(value="lock")
    private static zzabe zzcjo;
    private static final Object lock;
    private zzaab zzcjp;
    private RewardedVideoAd zzcjq;
    private zztw zzcjr;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzabe zzqf() {
        Object object = lock;
        synchronized (object) {
            if (zzcjo == null) {
                zzcjo = new zzabe();
            }
            return zzcjo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void zza(Context context, String string, zzabi zzabi2, zztx zztx2) {
        Object object = lock;
        synchronized (object) {
            if (this.zzcjp != null) {
                return;
            }
            if (context == null) {
                throw new IllegalArgumentException("Context cannot be null.");
            }
            try {
                zzami.initialize(context, string);
                Context context2 = context;
                Object object2 = zzyt.zzpb();
                Context context3 = context2;
                this.zzcjp = (zzaab)new zzyn((zzyh)object2, context2).zzd(context3, false);
                this.zzcjp.zza(new zzamo());
                this.zzcjp.zza();
                this.zzcjp.zzb(string, ObjectWrapper.wrap((Object)new zzabf(this, context)));
                zzacu.initialize(context);
                object2 = zzacu.zzcuw;
                if (!((Boolean)zzyt.zzpe().zzd(object2)).booleanValue()) {
                    object2 = zzacu.zzcvc;
                    if (zzyt.zzpe().zzd(object2).booleanValue()) {
                        return;
                    }
                }
                boolean bl = false;
                if (bl) return;
                zzbad.zzen("Google Mobile Ads SDK initialization functionality unavailable for this session. Ad requests can be made at any time.");
                object2 = this;
                this.zzcjr = new zzabg((zzabe)object2);
            }
            catch (RemoteException remoteException) {
                zzbad.zzd("MobileAdsSettingManager initialization failed", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RewardedVideoAd getRewardedVideoAdInstance(Context context) {
        Object object = lock;
        synchronized (object) {
            zzamo zzamo2;
            if (this.zzcjq != null) {
                return this.zzcjq;
            }
            zzamo zzamo3 = zzamo2 = new zzamo();
            Context context2 = context;
            zzyh zzyh2 = zzyt.zzpb();
            Context context3 = context2;
            zzasw zzasw2 = (zzasw)new zzyq(zzyh2, context2, zzamo3).zzd(context3, false);
            this.zzcjq = new zzatj(context, zzasw2);
            return this.zzcjq;
        }
    }

    public final void setAppVolume(float f) {
        Preconditions.checkArgument((0.0f <= f && f <= 1.0f ? 1 : 0) != 0, (Object)"The app volume must be a value between 0 and 1 inclusive.");
        Preconditions.checkState((this.zzcjp != null ? 1 : 0) != 0, (Object)"MobileAds.initialize() must be called prior to setting the app volume.");
        try {
            this.zzcjp.setAppVolume(f);
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zzc("Unable to set app volume.", remoteException);
            return;
        }
    }

    public final float zzpq() {
        float f = 1.0f;
        if (this.zzcjp == null) {
            return 1.0f;
        }
        try {
            f = this.zzcjp.zzpq();
        }
        catch (RemoteException remoteException) {
            zzbad.zzc("Unable to get app volume.", remoteException);
        }
        return f;
    }

    public final void setAppMuted(boolean bl) {
        Preconditions.checkState((this.zzcjp != null ? 1 : 0) != 0, (Object)"MobileAds.initialize() must be called prior to setting app muted state.");
        try {
            this.zzcjp.setAppMuted(bl);
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zzc("Unable to set app mute state.", remoteException);
            return;
        }
    }

    public final boolean zzpr() {
        boolean bl = false;
        if (this.zzcjp == null) {
            return false;
        }
        try {
            bl = this.zzcjp.zzpr();
        }
        catch (RemoteException remoteException) {
            zzbad.zzc("Unable to get app mute state.", remoteException);
        }
        return bl;
    }

    public final void openDebugMenu(Context context, String string) {
        Preconditions.checkState((this.zzcjp != null ? 1 : 0) != 0, (Object)"MobileAds.initialize() must be called prior to opening debug menu.");
        try {
            this.zzcjp.zzc(ObjectWrapper.wrap((Object)context), string);
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zzc("Unable to open debug menu.", remoteException);
            return;
        }
    }

    public final String getVersionString() {
        Preconditions.checkState((this.zzcjp != null ? 1 : 0) != 0, (Object)"MobileAds.initialize() must be called prior to getting version string.");
        try {
            return this.zzcjp.getVersionString();
        }
        catch (RemoteException remoteException) {
            zzbad.zzc("Unable to get version string.", remoteException);
            return "";
        }
    }

    public final void registerRtbAdapter(Class<? extends RtbAdapter> clazz) {
        try {
            this.zzcjp.zzbv(clazz.getCanonicalName());
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zzc("Unable to register RtbAdapter", remoteException);
            return;
        }
    }

    private zzabe() {
    }

    static {
        lock = new Object();
    }
}

