/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.formats.MediaView;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzaar;
import com.google.android.gms.internal.ads.zzaei;
import com.google.android.gms.internal.ads.zzael;
import com.google.android.gms.internal.ads.zzafe;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzbad;
import java.util.List;
import java.util.WeakHashMap;

@zzard
public final class zzafh
implements NativeCustomTemplateAd {
    private static WeakHashMap<IBinder, zzafh> zzcyy = new WeakHashMap();
    private final zzafe zzcyz;
    private final MediaView zzcza;
    private final VideoController zzcje = new VideoController();

    @VisibleForTesting
    private zzafh(zzafe zzafe2) {
        this.zzcyz = zzafe2;
        Context context = null;
        try {
            context = (Context)ObjectWrapper.unwrap((IObjectWrapper)zzafe2.zzrm());
        }
        catch (RemoteException | NullPointerException throwable) {
            zzbad.zzc("", throwable);
        }
        MediaView mediaView = null;
        if (context != null) {
            Object object = context;
            mediaView = new MediaView((Context)object);
            try {
                if (!this.zzcyz.zzp(ObjectWrapper.wrap((Object)((Object)mediaView)))) {
                    mediaView = null;
                }
            }
            catch (RemoteException remoteException) {
                mediaView = null;
                object = remoteException;
                zzbad.zzc("", (Throwable)object);
            }
        }
        this.zzcza = mediaView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzafh zza(zzafe zzafe2) {
        WeakHashMap<IBinder, zzafh> weakHashMap = zzcyy;
        synchronized (weakHashMap) {
            zzafh zzafh2 = zzcyy.get(zzafe2.asBinder());
            if (zzafh2 != null) {
                return zzafh2;
            }
            zzafh2 = new zzafh(zzafe2);
            zzcyy.put(zzafe2.asBinder(), zzafh2);
            return zzafh2;
        }
    }

    public final zzafe zzrn() {
        return this.zzcyz;
    }

    @Override
    public final CharSequence getText(String string) {
        try {
            return this.zzcyz.zzcj(string);
        }
        catch (RemoteException remoteException) {
            zzbad.zzc("", remoteException);
            return null;
        }
    }

    @Override
    public final NativeAd.Image getImage(String string) {
        try {
            zzaei zzaei2 = this.zzcyz.zzck(string);
            if (zzaei2 != null) {
                return new zzael(zzaei2);
            }
        }
        catch (RemoteException remoteException) {
            zzbad.zzc("", remoteException);
        }
        return null;
    }

    @Override
    public final VideoController getVideoController() {
        try {
            zzaar zzaar2 = this.zzcyz.getVideoController();
            if (zzaar2 != null) {
                this.zzcje.zza(zzaar2);
            }
        }
        catch (RemoteException remoteException) {
            zzbad.zzc("Exception occurred while getting video controller", remoteException);
        }
        return this.zzcje;
    }

    @Override
    public final MediaView getVideoMediaView() {
        return this.zzcza;
    }

    @Override
    public final List<String> getAvailableAssetNames() {
        try {
            return this.zzcyz.getAvailableAssetNames();
        }
        catch (RemoteException remoteException) {
            zzbad.zzc("", remoteException);
            return null;
        }
    }

    @Override
    public final String getCustomTemplateId() {
        try {
            return this.zzcyz.getCustomTemplateId();
        }
        catch (RemoteException remoteException) {
            zzbad.zzc("", remoteException);
            return null;
        }
    }

    @Override
    public final void performClick(String string) {
        try {
            this.zzcyz.performClick(string);
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zzc("", remoteException);
            return;
        }
    }

    @Override
    public final void recordImpression() {
        try {
            this.zzcyz.recordImpression();
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zzc("", remoteException);
            return;
        }
    }

    @Override
    public final void destroy() {
        try {
            this.zzcyz.destroy();
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zzc("", remoteException);
            return;
        }
    }
}

