/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Looper;
import android.text.TextUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.ads.zzacj;
import com.google.android.gms.internal.ads.zzacu;
import com.google.android.gms.internal.ads.zzaqy;
import com.google.android.gms.internal.ads.zzaqz;
import com.google.android.gms.internal.ads.zzara;
import com.google.android.gms.internal.ads.zzarb;
import com.google.android.gms.internal.ads.zzarc;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzazt;
import com.google.android.gms.internal.ads.zzbad;
import com.google.android.gms.internal.ads.zzbah;
import com.google.android.gms.internal.ads.zzbai;
import com.google.android.gms.internal.ads.zzdmb;
import com.google.android.gms.internal.ads.zzyt;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.ParametersAreNonnullByDefault;

@zzard
@ParametersAreNonnullByDefault
public final class zzaqx
implements zzarb {
    private static final Object lock = new Object();
    @VisibleForTesting
    private static zzarb zzdkz = null;
    @VisibleForTesting
    private static zzarb zzdla = null;
    private final Object zzdlb = new Object();
    private final Context zzcko;
    private final WeakHashMap<Thread, Boolean> zzdlc = new WeakHashMap();
    private final ExecutorService zzxf = Executors.newCachedThreadPool();
    private final zzbai zzdld;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzarb zzo(Context context) {
        Object object = lock;
        synchronized (object) {
            if (zzdkz == null) {
                zzacj<Boolean> zzacj2 = zzacu.zzcle;
                zzdkz = zzyt.zzpe().zzd(zzacj2) != false ? new zzaqx(context) : new zzarc();
            }
        }
        return zzdkz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzarb zzc(Context context, zzbai zzbai2) {
        Object object = lock;
        synchronized (object) {
            if (zzdla == null) {
                Object object2 = zzacu.zzcle;
                if (zzyt.zzpe().zzd(object2).booleanValue()) {
                    zzaqx zzaqx2 = new zzaqx(context, zzbai2);
                    Thread thread = Looper.getMainLooper().getThread();
                    zzaqx zzaqx3 = zzaqx2;
                    if (thread != null) {
                        Object object3 = zzaqx3.zzdlb;
                        synchronized (object3) {
                            zzaqx3.zzdlc.put(thread, true);
                        }
                        object3 = thread.getUncaughtExceptionHandler();
                        thread.setUncaughtExceptionHandler(new zzaqz(zzaqx3, (Thread.UncaughtExceptionHandler)object3));
                    }
                    object2 = zzaqx2;
                    Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                    Thread.setDefaultUncaughtExceptionHandler(new zzaqy((zzaqx)object2, uncaughtExceptionHandler));
                    zzdla = zzaqx2;
                } else {
                    zzdla = new zzarc();
                }
            }
        }
        return zzdla;
    }

    private zzaqx(Context context) {
        this(context, zzbai.zzxc());
    }

    private zzaqx(Context context, zzbai zzbai2) {
        this.zzcko = context.getApplicationContext() != null ? context.getApplicationContext() : context;
        this.zzdld = zzbai2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void zza(Thread thread, Throwable throwable) {
        Throwable throwable2;
        zzaqx zzaqx2 = this;
        if (throwable2 == null) return;
        boolean bl = false;
        boolean bl2 = false;
        for (throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            for (StackTraceElement stackTraceElement : throwable2.getStackTrace()) {
                if (zzazt.zzej(stackTraceElement.getClassName())) {
                    bl = true;
                }
                if (!zzaqx2.getClass().getName().equals(stackTraceElement.getClassName())) continue;
                bl2 = true;
            }
        }
        if (!bl) return;
        if (bl2) return;
        boolean bl3 = true;
        if (!bl3) return;
        throwable2 = throwable;
        String string = "";
        Throwable throwable3 = throwable2;
        this.zza(throwable2, string, 1.0f);
    }

    @Override
    public final void zza(Throwable throwable, String string) {
        this.zza(throwable, string, 1.0f);
    }

    @Override
    public final void zza(Throwable throwable, String string, float f) {
        if (zzazt.zzc(throwable) == null) {
            return;
        }
        String string2 = throwable.getClass().getName();
        StringWriter stringWriter = new StringWriter();
        zzdmb.zza((Throwable)throwable, (PrintWriter)new PrintWriter(stringWriter));
        String string3 = stringWriter.toString();
        boolean bl = Math.random() < (double)f;
        int n = f > 0.0f ? (int)(1.0f / f) : 1;
        if (bl) {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = n;
            String string4 = string;
            String string5 = string3;
            Object object = string2;
            arrayList.add(this.zza((String)object, string5, string4, n2).toString());
            object = arrayList;
            zzaqx zzaqx2 = this;
            ArrayList arrayList2 = (ArrayList)object;
            int n3 = arrayList2.size();
            string5 = null;
            for (int i = 0; i < n3; ++i) {
                Object e = arrayList2.get(i);
                string4 = (String)e;
                zzbah zzbah2 = new zzbah();
                zzaqx2.zzxf.submit(new zzara(zzaqx2, zzbah2, string4));
            }
        }
    }

    @VisibleForTesting
    private final Uri.Builder zza(String string, String string2, String string3, int n) {
        boolean bl = false;
        try {
            bl = Wrappers.packageManager((Context)this.zzcko).isCallerInstantApp();
        }
        catch (Throwable throwable) {
            zzbad.zzc("Error fetching instant app info", throwable);
        }
        String string4 = "unknown";
        try {
            string4 = this.zzcko.getPackageName();
        }
        catch (Throwable throwable) {
            zzbad.zzep("Cannot obtain package name, proceeding.");
        }
        String string5 = Build.MANUFACTURER;
        String string6 = Build.MODEL;
        zzacj<String> zzacj2 = zzacu.zzcwf;
        return new Uri.Builder().scheme("https").path("//pagead2.googlesyndication.com/pagead/gen_204").appendQueryParameter("is_aia", Boolean.toString(bl)).appendQueryParameter("id", "gmob-apps-report-exception").appendQueryParameter("os", Build.VERSION.RELEASE).appendQueryParameter("api", String.valueOf(Build.VERSION.SDK_INT)).appendQueryParameter("device", string6.startsWith(string5) ? string6 : new StringBuilder(1 + String.valueOf(string5).length() + String.valueOf(string6).length()).append(string5).append(" ").append(string6).toString()).appendQueryParameter("js", this.zzdld.zzbsx).appendQueryParameter("appid", string4).appendQueryParameter("exceptiontype", string).appendQueryParameter("stacktrace", string2).appendQueryParameter("eids", TextUtils.join((CharSequence)",", zzacu.zzqn())).appendQueryParameter("exceptionkey", string3).appendQueryParameter("cl", "248613007").appendQueryParameter("rc", "dev").appendQueryParameter("session_id", zzyt.zzpf()).appendQueryParameter("sampling_rate", Integer.toString(n)).appendQueryParameter("pb_tm", String.valueOf(zzyt.zzpe().zzd(zzacj2)));
    }
}

