/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.ResponseInfo;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.internal.ads.zzazh;
import com.google.android.gms.internal.ads.zztz;
import com.google.android.gms.internal.ads.zzxt;

class BaseAdView
extends ViewGroup {
    protected final zzxt zzabr;

    public BaseAdView(Context context, int n) {
        super(context);
        this.zzabr = new zzxt(this, n);
    }

    public BaseAdView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet);
        this.zzabr = new zzxt(this, attributeSet, false, n);
    }

    public BaseAdView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n);
        this.zzabr = new zzxt(this, attributeSet, false, n2);
    }

    public void destroy() {
        this.zzabr.destroy();
    }

    public AdListener getAdListener() {
        return this.zzabr.getAdListener();
    }

    public AdSize getAdSize() {
        return this.zzabr.getAdSize();
    }

    public String getAdUnitId() {
        return this.zzabr.getAdUnitId();
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(AdRequest adRequest) {
        this.zzabr.zza(adRequest.zzdl());
    }

    public void pause() {
        this.zzabr.pause();
    }

    public void resume() {
        this.zzabr.resume();
    }

    public boolean isLoading() {
        return this.zzabr.isLoading();
    }

    public void setAdListener(AdListener adListener) {
        this.zzabr.setAdListener(adListener);
        if (adListener == null) {
            this.zzabr.zza((zztz)null);
            this.zzabr.setAppEventListener(null);
            return;
        }
        if (adListener instanceof zztz) {
            this.zzabr.zza((zztz)((Object)adListener));
        }
        if (adListener instanceof AppEventListener) {
            this.zzabr.setAppEventListener((AppEventListener)((Object)adListener));
        }
    }

    public void setAdSize(AdSize adSize) {
        this.zzabr.setAdSizes(adSize);
    }

    public void setAdUnitId(String string) {
        this.zzabr.setAdUnitId(string);
    }

    @Deprecated
    public String getMediationAdapterClassName() {
        return this.zzabr.getMediationAdapterClassName();
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            int n5 = view.getMeasuredWidth();
            int n6 = view.getMeasuredHeight();
            int n7 = (n3 - n - n5) / 2;
            int n8 = (n4 - n2 - n6) / 2;
            view.layout(n7, n8, n7 + n5, n8 + n6);
        }
    }

    protected void onMeasure(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            this.measureChild(view, n, n2);
            n3 = view.getMeasuredWidth();
            n4 = view.getMeasuredHeight();
        } else {
            AdSize adSize = null;
            try {
                adSize = this.getAdSize();
            }
            catch (NullPointerException nullPointerException) {
                zzazh.zzc("Unable to retrieve ad size.", nullPointerException);
            }
            if (adSize != null) {
                Context context = this.getContext();
                n3 = adSize.getWidthInPixels(context);
                n4 = adSize.getHeightInPixels(context);
            }
        }
        n3 = Math.max(n3, this.getSuggestedMinimumWidth());
        n4 = Math.max(n4, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(View.resolveSize((int)n3, (int)n), View.resolveSize((int)n4, (int)n2));
    }

    @Nullable
    public ResponseInfo getResponseInfo() {
        return this.zzabr.getResponseInfo();
    }

    public void setOnPaidEventListener(@Nullable OnPaidEventListener onPaidEventListener) {
        this.zzabr.setOnPaidEventListener(onPaidEventListener);
    }
}

