/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.formats;

import android.os.RemoteException;
import android.view.View;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.formats.NativeAdView;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.ads.formats.UnifiedNativeAdView;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzacy;
import com.google.android.gms.internal.ads.zzazh;
import com.google.android.gms.internal.ads.zzvh;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public final class NativeAdViewHolder {
    private zzacy zzbkm;
    public static WeakHashMap<View, NativeAdViewHolder> zzbkn = new WeakHashMap();
    private WeakReference<View> zzbko;

    public NativeAdViewHolder(View view, Map<String, View> map, Map<String, View> map2) {
        HashMap<String, View> hashMap;
        Preconditions.checkNotNull((Object)view, (Object)"ContainerView must not be null");
        if (view instanceof NativeAdView || view instanceof UnifiedNativeAdView) {
            zzazh.zzey("The provided containerView is of type of NativeAdView, which cannot be usedwith NativeAdViewHolder.");
            return;
        }
        if (zzbkn.get(view) != null) {
            zzazh.zzey("The provided containerView is already in use with another NativeAdViewHolder.");
            return;
        }
        zzbkn.put(view, this);
        this.zzbko = new WeakReference<View>(view);
        HashMap<String, View> hashMap2 = NativeAdViewHolder.zzb(map);
        HashMap<String, View> hashMap3 = hashMap = NativeAdViewHolder.zzb(map2);
        HashMap<String, View> hashMap4 = hashMap2;
        View view2 = view;
        this.zzbkm = zzvh.zzpa().zza(view2, hashMap4, hashMap3);
    }

    private static HashMap<String, View> zzb(Map<String, View> map) {
        if (map == null) {
            return new HashMap<String, View>();
        }
        return new HashMap<String, View>(map);
    }

    public final void setNativeAd(NativeAd nativeAd) {
        this.zza((IObjectWrapper)nativeAd.zzjo());
    }

    public final void setNativeAd(UnifiedNativeAd unifiedNativeAd) {
        this.zza((IObjectWrapper)unifiedNativeAd.zzjo());
    }

    private final void zza(IObjectWrapper iObjectWrapper) {
        View view = this.zzbko != null ? (View)this.zzbko.get() : null;
        if (view == null) {
            zzazh.zzfa("NativeAdViewHolder.setNativeAd containerView doesn't exist, returning");
            return;
        }
        if (!zzbkn.containsKey(view)) {
            zzbkn.put(view, this);
        }
        if (this.zzbkm != null) {
            try {
                this.zzbkm.zza(iObjectWrapper);
                return;
            }
            catch (RemoteException remoteException) {
                zzazh.zzc("Unable to call setNativeAd on delegate", remoteException);
            }
        }
    }

    public final void unregisterNativeAd() {
        View view;
        if (this.zzbkm != null) {
            try {
                this.zzbkm.unregisterNativeAd();
            }
            catch (RemoteException remoteException) {
                zzazh.zzc("Unable to call unregisterNativeAd on delegate", remoteException);
            }
        }
        if ((view = this.zzbko != null ? (View)this.zzbko.get() : null) != null) {
            zzbkn.remove(view);
        }
    }

    public final void setClickConfirmingView(View view) {
        try {
            this.zzbkm.zze(ObjectWrapper.wrap((Object)view));
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zzc("Unable to call setClickConfirmingView on delegate", remoteException);
            return;
        }
    }
}

