/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.formats.MediaView;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzacn;
import com.google.android.gms.internal.ads.zzacr;
import com.google.android.gms.internal.ads.zzacs;
import com.google.android.gms.internal.ads.zzadn;
import com.google.android.gms.internal.ads.zzazh;
import com.google.android.gms.internal.ads.zzxj;
import java.util.List;
import java.util.WeakHashMap;

public final class zzado
implements NativeCustomTemplateAd {
    private static WeakHashMap<IBinder, zzado> zzcxe = new WeakHashMap();
    private final zzadn zzcxf;
    private final MediaView zzcxg;
    private final VideoController zzcfe = new VideoController();
    private NativeCustomTemplateAd.DisplayOpenMeasurement zzcxh;

    @VisibleForTesting
    private zzado(zzadn zzadn2) {
        this.zzcxf = zzadn2;
        Context context = null;
        try {
            context = (Context)ObjectWrapper.unwrap((IObjectWrapper)zzadn2.zzro());
        }
        catch (RemoteException | NullPointerException throwable) {
            zzazh.zzc("", throwable);
        }
        MediaView mediaView = null;
        if (context != null) {
            Object object = context;
            mediaView = new MediaView((Context)object);
            try {
                if (!this.zzcxf.zzp(ObjectWrapper.wrap((Object)((Object)mediaView)))) {
                    mediaView = null;
                }
            }
            catch (RemoteException remoteException) {
                mediaView = null;
                object = remoteException;
                zzazh.zzc("", (Throwable)object);
            }
        }
        this.zzcxg = mediaView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzado zza(zzadn zzadn2) {
        WeakHashMap<IBinder, zzado> weakHashMap = zzcxe;
        synchronized (weakHashMap) {
            zzado zzado2 = zzcxe.get(zzadn2.asBinder());
            if (zzado2 != null) {
                return zzado2;
            }
            zzado2 = new zzado(zzadn2);
            zzcxe.put(zzadn2.asBinder(), zzado2);
            return zzado2;
        }
    }

    public final zzadn zzrs() {
        return this.zzcxf;
    }

    @Override
    public final CharSequence getText(String string) {
        try {
            return this.zzcxf.zzcu(string);
        }
        catch (RemoteException remoteException) {
            zzazh.zzc("", remoteException);
            return null;
        }
    }

    @Override
    public final NativeAd.Image getImage(String string) {
        try {
            zzacr zzacr2 = this.zzcxf.zzcv(string);
            if (zzacr2 != null) {
                return new zzacs(zzacr2);
            }
        }
        catch (RemoteException remoteException) {
            zzazh.zzc("", remoteException);
        }
        return null;
    }

    @Override
    public final VideoController getVideoController() {
        try {
            zzxj zzxj2 = this.zzcxf.getVideoController();
            if (zzxj2 != null) {
                this.zzcfe.zza(zzxj2);
            }
        }
        catch (RemoteException remoteException) {
            zzazh.zzc("Exception occurred while getting video controller", remoteException);
        }
        return this.zzcfe;
    }

    @Override
    public final MediaView getVideoMediaView() {
        return this.zzcxg;
    }

    @Override
    public final List<String> getAvailableAssetNames() {
        try {
            return this.zzcxf.getAvailableAssetNames();
        }
        catch (RemoteException remoteException) {
            zzazh.zzc("", remoteException);
            return null;
        }
    }

    @Override
    public final String getCustomTemplateId() {
        try {
            return this.zzcxf.getCustomTemplateId();
        }
        catch (RemoteException remoteException) {
            zzazh.zzc("", remoteException);
            return null;
        }
    }

    @Override
    public final void performClick(String string) {
        try {
            this.zzcxf.performClick(string);
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zzc("", remoteException);
            return;
        }
    }

    @Override
    public final void recordImpression() {
        try {
            this.zzcxf.recordImpression();
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zzc("", remoteException);
            return;
        }
    }

    @Override
    public final NativeCustomTemplateAd.DisplayOpenMeasurement getDisplayOpenMeasurement() {
        try {
            if (this.zzcxh == null && this.zzcxf.zzrp()) {
                this.zzcxh = new zzacn(this.zzcxf);
            }
        }
        catch (RemoteException remoteException) {
            zzazh.zzc("", remoteException);
        }
        return this.zzcxh;
    }

    @Override
    public final void destroy() {
        try {
            this.zzcxf.destroy();
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zzc("", remoteException);
            return;
        }
    }
}

