/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.zzb;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.ads.zzayx;
import com.google.android.gms.internal.ads.zzun;
import com.google.android.gms.internal.ads.zzvh;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="AdSizeParcelCreator")
public final class zzuk
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<zzuk> CREATOR = new zzun();
    @SafeParcelable.Field(id=2)
    public final String zzabk;
    @SafeParcelable.Field(id=3)
    public final int height;
    @SafeParcelable.Field(id=4)
    public final int heightPixels;
    @SafeParcelable.Field(id=5)
    public final boolean zzcdc;
    @SafeParcelable.Field(id=6)
    public final int width;
    @SafeParcelable.Field(id=7)
    public final int widthPixels;
    @SafeParcelable.Field(id=8)
    public final zzuk[] zzcdd;
    @SafeParcelable.Field(id=9)
    public final boolean zzbml;
    @SafeParcelable.Field(id=10)
    public final boolean zzcde;
    @SafeParcelable.Field(id=11)
    public boolean zzcdf;
    @SafeParcelable.Field(id=12)
    public boolean zzcdg;
    @SafeParcelable.Field(id=13)
    private boolean zzcdh;
    @SafeParcelable.Field(id=14)
    public boolean zzcdi;
    @SafeParcelable.Field(id=15)
    public boolean zzcdj;

    public static int zzb(DisplayMetrics displayMetrics) {
        return displayMetrics.widthPixels;
    }

    public static int zzc(DisplayMetrics displayMetrics) {
        return (int)((float)zzuk.zzd(displayMetrics) * displayMetrics.density);
    }

    private static int zzd(DisplayMetrics displayMetrics) {
        int n = (int)((float)displayMetrics.heightPixels / displayMetrics.density);
        if (n <= 400) {
            return 32;
        }
        if (n <= 720) {
            return 50;
        }
        return 90;
    }

    public static zzuk zzh(Context context) {
        return new zzuk("320x50_mb", 0, 0, false, 0, 0, null, true, false, false, false, false, false, false);
    }

    public static zzuk zzoq() {
        return new zzuk("reward_mb", 0, 0, true, 0, 0, null, false, false, false, false, false, false, false);
    }

    public static zzuk zzor() {
        return new zzuk("interstitial_mb", 0, 0, false, 0, 0, null, false, false, false, false, true, false, false);
    }

    public zzuk() {
        this("interstitial_mb", 0, 0, true, 0, 0, null, false, false, false, false, false, false, false);
    }

    public static zzuk zzos() {
        return new zzuk("invalid", 0, 0, false, 0, 0, null, false, false, false, true, false, false, false);
    }

    public zzuk(Context context, AdSize adSize) {
        this(context, new AdSize[]{adSize});
    }

    /*
     * Unable to fully structure code
     */
    public zzuk(Context var1_1, AdSize[] var2_2) {
        block15: {
            block14: {
                super();
                var3_3 = var2_2[0];
                this.zzcdc = false;
                this.zzcde = var3_3.isFluid();
                this.zzcdi = zzb.zza(var3_3);
                this.zzcdj = zzb.zzb(var3_3);
                if (this.zzcde) {
                    this.width = AdSize.BANNER.getWidth();
                    this.height = AdSize.BANNER.getHeight();
                } else if (this.zzcdj) {
                    this.width = var3_3.getWidth();
                    this.height = zzb.zzc(var3_3);
                } else {
                    this.width = var3_3.getWidth();
                    this.height = var3_3.getHeight();
                }
                var4_4 = this.width == -1;
                var5_5 = this.height == -2;
                var6_6 = var1_1.getResources().getDisplayMetrics();
                if (!var4_4) break block14;
                zzvh.zzoz();
                if (!zzayx.zzbo(var1_1)) ** GOTO lbl-1000
                zzvh.zzoz();
                if (zzayx.zzbp(var1_1)) {
                    v0 = var6_6.widthPixels;
                    zzvh.zzoz();
                    this.widthPixels = v0 - zzayx.zzbq(var1_1);
                } else lbl-1000:
                // 2 sources

                {
                    this.widthPixels = var6_6.widthPixels;
                }
                var9_7 = (float)this.widthPixels / var6_6.density;
                var7_11 = (int)var9_7;
                if (var9_7 - (double)((int)var9_7) >= 0.01) {
                    ++var7_11;
                }
                break block15;
            }
            var7_11 = this.width;
            zzvh.zzoz();
            this.widthPixels = zzayx.zza(var6_6, this.width);
        }
        var8_12 = var5_5 != false ? zzuk.zzd(var6_6) : this.height;
        zzvh.zzoz();
        this.heightPixels = zzayx.zza(var6_6, var8_12);
        if (var4_4 || var5_5) {
            var9_8 = var7_11;
            this.zzabk = new StringBuilder(26).append(var9_8).append("x").append(var8_12).append("_as").toString();
        } else if (this.zzcdj) {
            var9_9 = this.width;
            var10_13 = this.height;
            this.zzabk = new StringBuilder(26).append(var9_9).append("x").append(var10_13).append("_as").toString();
        } else {
            this.zzabk = this.zzcde != false ? "320x50_mb" : var3_3.toString();
        }
        if (var2_2.length > 1) {
            this.zzcdd = new zzuk[var2_2.length];
            for (var9_10 = 0; var9_10 < var2_2.length; ++var9_10) {
                this.zzcdd[var9_10] = new zzuk(var1_1, var2_2[var9_10]);
            }
        } else {
            this.zzcdd = null;
        }
        this.zzbml = false;
        this.zzcdf = false;
    }

    @SafeParcelable.Constructor
    zzuk(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) int n, @SafeParcelable.Param(id=4) int n2, @SafeParcelable.Param(id=5) boolean bl, @SafeParcelable.Param(id=6) int n3, @SafeParcelable.Param(id=7) int n4, @SafeParcelable.Param(id=8) zzuk[] zzukArray, @SafeParcelable.Param(id=9) boolean bl2, @SafeParcelable.Param(id=10) boolean bl3, @SafeParcelable.Param(id=11) boolean bl4, @SafeParcelable.Param(id=12) boolean bl5, @SafeParcelable.Param(id=13) boolean bl6, @SafeParcelable.Param(id=14) boolean bl7, @SafeParcelable.Param(id=15) boolean bl8) {
        this.zzabk = string;
        this.height = n;
        this.heightPixels = n2;
        this.zzcdc = bl;
        this.width = n3;
        this.widthPixels = n4;
        this.zzcdd = zzukArray;
        this.zzbml = bl2;
        this.zzcde = bl3;
        this.zzcdf = bl4;
        this.zzcdg = bl5;
        this.zzcdh = bl6;
        this.zzcdi = bl7;
        this.zzcdj = bl8;
    }

    public final AdSize zzot() {
        return zzb.zza(this.width, this.height, this.zzabk);
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzuk zzuk2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)zzuk2.zzabk, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)3, (int)zzuk2.height);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)4, (int)zzuk2.heightPixels);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)5, (boolean)zzuk2.zzcdc);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)6, (int)zzuk2.width);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)7, (int)zzuk2.widthPixels);
        SafeParcelWriter.writeTypedArray((Parcel)parcel2, (int)8, (Parcelable[])zzuk2.zzcdd, (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)9, (boolean)zzuk2.zzbml);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)10, (boolean)zzuk2.zzcde);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)11, (boolean)zzuk2.zzcdf);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)12, (boolean)zzuk2.zzcdg);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)13, (boolean)zzuk2.zzcdh);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)14, (boolean)zzuk2.zzcdi);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)15, (boolean)zzuk2.zzcdj);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }
}

