/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.RequestConfiguration;
import com.google.android.gms.ads.initialization.AdapterStatus;
import com.google.android.gms.ads.initialization.InitializationStatus;
import com.google.android.gms.ads.initialization.OnInitializationCompleteListener;
import com.google.android.gms.ads.mediation.rtb.RtbAdapter;
import com.google.android.gms.ads.reward.RewardedVideoAd;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzagz;
import com.google.android.gms.internal.ads.zzahg;
import com.google.android.gms.internal.ads.zzahh;
import com.google.android.gms.internal.ads.zzalc;
import com.google.android.gms.internal.ads.zzall;
import com.google.android.gms.internal.ads.zzary;
import com.google.android.gms.internal.ads.zzasj;
import com.google.android.gms.internal.ads.zzayx;
import com.google.android.gms.internal.ads.zzazh;
import com.google.android.gms.internal.ads.zzus;
import com.google.android.gms.internal.ads.zzva;
import com.google.android.gms.internal.ads.zzvf;
import com.google.android.gms.internal.ads.zzvh;
import com.google.android.gms.internal.ads.zzwn;
import com.google.android.gms.internal.ads.zzxw;
import com.google.android.gms.internal.ads.zzxx;
import com.google.android.gms.internal.ads.zzxz;
import com.google.android.gms.internal.ads.zzyb;
import com.google.android.gms.internal.ads.zzyd;
import com.google.android.gms.internal.ads.zzyw;
import com.google.android.gms.internal.ads.zzzx;
import java.util.HashMap;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;

public final class zzxu {
    @GuardedBy(value="lock")
    private static zzxu zzcfk;
    private static final Object lock;
    private zzwn zzcfl;
    private RewardedVideoAd zzcfm;
    @NonNull
    private RequestConfiguration zzcfn = new RequestConfiguration.Builder().build();
    private InitializationStatus zzcfo;

    private zzxu() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzxu zzpy() {
        Object object = lock;
        synchronized (object) {
            if (zzcfk == null) {
                zzcfk = new zzxu();
            }
            return zzcfk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(Context context, String string, zzyd zzyd2, OnInitializationCompleteListener onInitializationCompleteListener) {
        Object object = lock;
        synchronized (object) {
            if (this.zzcfl != null) {
                return;
            }
            if (context == null) {
                throw new IllegalArgumentException("Context cannot be null.");
            }
            try {
                zzalc.zzso().zzc(context, string);
                Context context2 = context;
                Object object2 = zzvh.zzpa();
                Context context3 = context2;
                this.zzcfl = (zzwn)new zzva((zzus)object2, context2).zzd(context3, false);
                if (onInitializationCompleteListener != null) {
                    this.zzcfl.zza(new zzyb(this, onInitializationCompleteListener, null));
                }
                this.zzcfl.zza(new zzall());
                this.zzcfl.initialize();
                this.zzcfl.zza(string, ObjectWrapper.wrap((Object)new zzxx(this, context)));
                if (this.zzcfn.getTagForChildDirectedTreatment() != -1 || this.zzcfn.getTagForUnderAgeOfConsent() != -1) {
                    this.zza(this.zzcfn);
                }
                zzzx.initialize(context);
                object2 = zzzx.zzcpj;
                if (!((Boolean)zzvh.zzpd().zzd(object2)).booleanValue() && !this.zzpz()) {
                    zzazh.zzey("Google Mobile Ads SDK initialization functionality unavailable for this session. Ad requests can be made at any time.");
                    object2 = this;
                    this.zzcfo = new zzxz((zzxu)object2);
                    if (onInitializationCompleteListener != null) {
                        zzayx.zzyy.post((Runnable)new zzxw(this, onInitializationCompleteListener));
                    }
                }
            }
            catch (RemoteException remoteException) {
                zzazh.zzd("MobileAdsSettingManager initialization failed", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RewardedVideoAd getRewardedVideoAdInstance(Context context) {
        Object object = lock;
        synchronized (object) {
            zzall zzall2;
            if (this.zzcfm != null) {
                return this.zzcfm;
            }
            zzall zzall3 = zzall2 = new zzall();
            Context context2 = context;
            zzus zzus2 = zzvh.zzpa();
            Context context3 = context2;
            zzary zzary2 = (zzary)new zzvf(zzus2, context2, zzall3).zzd(context3, false);
            this.zzcfm = new zzasj(context, zzary2);
            return this.zzcfm;
        }
    }

    public final void setAppVolume(float f) {
        Preconditions.checkArgument((0.0f <= f && f <= 1.0f ? 1 : 0) != 0, (Object)"The app volume must be a value between 0 and 1 inclusive.");
        Preconditions.checkState((this.zzcfl != null ? 1 : 0) != 0, (Object)"MobileAds.initialize() must be called prior to setting the app volume.");
        try {
            this.zzcfl.setAppVolume(f);
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zzc("Unable to set app volume.", remoteException);
            return;
        }
    }

    public final float zzpj() {
        float f = 1.0f;
        if (this.zzcfl == null) {
            return 1.0f;
        }
        try {
            f = this.zzcfl.zzpj();
        }
        catch (RemoteException remoteException) {
            zzazh.zzc("Unable to get app volume.", remoteException);
        }
        return f;
    }

    public final void setAppMuted(boolean bl) {
        Preconditions.checkState((this.zzcfl != null ? 1 : 0) != 0, (Object)"MobileAds.initialize() must be called prior to setting app muted state.");
        try {
            this.zzcfl.setAppMuted(bl);
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zzc("Unable to set app mute state.", remoteException);
            return;
        }
    }

    public final boolean zzpk() {
        boolean bl = false;
        if (this.zzcfl == null) {
            return false;
        }
        try {
            bl = this.zzcfl.zzpk();
        }
        catch (RemoteException remoteException) {
            zzazh.zzc("Unable to get app mute state.", remoteException);
        }
        return bl;
    }

    public final void openDebugMenu(Context context, String string) {
        Preconditions.checkState((this.zzcfl != null ? 1 : 0) != 0, (Object)"MobileAds.initialize() must be called prior to opening debug menu.");
        try {
            this.zzcfl.zzb(ObjectWrapper.wrap((Object)context), string);
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zzc("Unable to open debug menu.", remoteException);
            return;
        }
    }

    public final String getVersionString() {
        Preconditions.checkState((this.zzcfl != null ? 1 : 0) != 0, (Object)"MobileAds.initialize() must be called prior to getting version string.");
        try {
            return this.zzcfl.getVersionString();
        }
        catch (RemoteException remoteException) {
            zzazh.zzc("Unable to get version string.", remoteException);
            return "";
        }
    }

    public final void registerRtbAdapter(Class<? extends RtbAdapter> clazz) {
        try {
            this.zzcfl.zzcf(clazz.getCanonicalName());
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zzc("Unable to register RtbAdapter", remoteException);
            return;
        }
    }

    public final InitializationStatus getInitializationStatus() {
        Preconditions.checkState((this.zzcfl != null ? 1 : 0) != 0, (Object)"MobileAds.initialize() must be called prior to getting initialization status.");
        try {
            if (this.zzcfo != null) {
                return this.zzcfo;
            }
            return zzxu.zzc(this.zzcfl.zzpl());
        }
        catch (RemoteException remoteException) {
            zzazh.zzey("Unable to get Initialization status.");
            return null;
        }
    }

    private static InitializationStatus zzc(List<zzagz> list) {
        HashMap<String, AdapterStatus> hashMap = new HashMap<String, AdapterStatus>();
        for (zzagz zzagz2 : list) {
            hashMap.put(zzagz2.zzczf, new zzahh(zzagz2.zzczg ? AdapterStatus.State.READY : AdapterStatus.State.NOT_READY, zzagz2.description, zzagz2.zzczh));
        }
        return new zzahg(hashMap);
    }

    @NonNull
    public final RequestConfiguration getRequestConfiguration() {
        return this.zzcfn;
    }

    public final void setRequestConfiguration(@NonNull RequestConfiguration requestConfiguration) {
        Preconditions.checkArgument((requestConfiguration != null ? 1 : 0) != 0, (Object)"Null passed to setRequestConfiguration.");
        RequestConfiguration requestConfiguration2 = this.zzcfn;
        this.zzcfn = requestConfiguration;
        if (this.zzcfl == null) {
            return;
        }
        if (requestConfiguration2.getTagForChildDirectedTreatment() != requestConfiguration.getTagForChildDirectedTreatment() || requestConfiguration2.getTagForUnderAgeOfConsent() != requestConfiguration.getTagForUnderAgeOfConsent()) {
            this.zza(requestConfiguration);
        }
    }

    private final void zza(@NonNull RequestConfiguration requestConfiguration) {
        try {
            this.zzcfl.zza(new zzyw(requestConfiguration));
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zzc("Unable to set request configuration parcel.", remoteException);
            return;
        }
    }

    private final boolean zzpz() throws RemoteException {
        try {
            return this.zzcfl.getVersionString().endsWith("0");
        }
        catch (RemoteException remoteException) {
            zzazh.zzey("Unable to get version string.");
            return true;
        }
    }

    final /* synthetic */ void zza(OnInitializationCompleteListener onInitializationCompleteListener) {
        onInitializationCompleteListener.onInitializationComplete(this.zzcfo);
    }

    static /* synthetic */ InitializationStatus zza(zzxu zzxu2, List list) {
        return zzxu.zzc(list);
    }

    static {
        lock = new Object();
    }
}

