/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.mediation.MediationExtrasReceiver;
import com.google.android.gms.ads.mediation.NetworkExtras;
import com.google.android.gms.ads.mediation.customevent.CustomEvent;
import com.google.android.gms.ads.query.AdInfo;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzaco;
import com.google.android.gms.internal.ads.zzacp;
import com.google.android.gms.internal.ads.zzbbf;
import java.util.Date;
import java.util.List;
import java.util.Set;

@VisibleForTesting
public class AdRequest {
    public static final int ERROR_CODE_INTERNAL_ERROR = 0;
    public static final int ERROR_CODE_INVALID_REQUEST = 1;
    public static final int ERROR_CODE_NETWORK_ERROR = 2;
    public static final int ERROR_CODE_NO_FILL = 3;
    public static final int ERROR_CODE_APP_ID_MISSING = 8;
    public static final int ERROR_CODE_REQUEST_ID_MISMATCH = 10;
    public static final int ERROR_CODE_MEDIATION_NO_FILL = 9;
    public static final int GENDER_UNKNOWN = 0;
    public static final int GENDER_MALE = 1;
    public static final int GENDER_FEMALE = 2;
    public static final int MAX_CONTENT_URL_LENGTH = 512;
    @RecentlyNonNull
    public static final String DEVICE_ID_EMULATOR = "B3EEABB8EE11C2BE770B684D95219ECB";
    protected final zzacp zza;

    protected AdRequest(@RecentlyNonNull Builder builder) {
        zzacp zzacp2;
        this.zza = zzacp2 = new zzacp(builder.zza, null);
    }

    @RecentlyNonNull
    public String getContentUrl() {
        return this.zza.zzb();
    }

    @RecentlyNonNull
    public List<String> getNeighboringContentUrls() {
        return this.zza.zzc();
    }

    @RecentlyNonNull
    public Set<String> getKeywords() {
        return this.zza.zze();
    }

    @RecentlyNonNull
    public Location getLocation() {
        return this.zza.zzf();
    }

    @RecentlyNullable
    public <T extends MediationExtrasReceiver> Bundle getNetworkExtrasBundle(@RecentlyNonNull Class<T> clazz) {
        return this.zza.zzh(clazz);
    }

    @RecentlyNullable
    public <T extends CustomEvent> Bundle getCustomEventExtrasBundle(@RecentlyNonNull Class<T> clazz) {
        return this.zza.zzi(clazz);
    }

    public boolean isTestDevice(@RecentlyNonNull Context context) {
        return this.zza.zzm(context);
    }

    @RecentlyNonNull
    public Bundle getCustomTargeting() {
        return this.zza.zzq();
    }

    public zzacp zza() {
        return this.zza;
    }

    @VisibleForTesting
    public static class Builder {
        protected final zzaco zza;

        public Builder() {
            zzaco zzaco2;
            this.zza = zzaco2 = new zzaco();
            this.zza.zze(AdRequest.DEVICE_ID_EMULATOR);
        }

        @RecentlyNonNull
        public Builder addKeyword(@RecentlyNonNull String string) {
            this.zza.zza(string);
            return this;
        }

        @RecentlyNonNull
        public Builder addNetworkExtras(@RecentlyNonNull NetworkExtras networkExtras) {
            this.zza.zzb(networkExtras);
            return this;
        }

        @RecentlyNonNull
        public Builder addNetworkExtrasBundle(@RecentlyNonNull Class<? extends MediationExtrasReceiver> clazz, @RecentlyNonNull Bundle bundle) {
            this.zza.zzc(clazz, bundle);
            if (clazz.equals(AdMobAdapter.class) && bundle.getBoolean("_emulatorLiveAds")) {
                this.zza.zzf(AdRequest.DEVICE_ID_EMULATOR);
            }
            return this;
        }

        @RecentlyNonNull
        public Builder addCustomEventExtrasBundle(@RecentlyNonNull Class<? extends CustomEvent> clazz, @RecentlyNonNull Bundle bundle) {
            this.zza.zzd(clazz, bundle);
            return this;
        }

        @RecentlyNonNull
        public AdRequest build() {
            AdRequest adRequest = new AdRequest(this);
            return adRequest;
        }

        /*
         * Enabled aggressive block sorting
         */
        @RecentlyNonNull
        public Builder setContentUrl(@RecentlyNonNull String string) {
            Preconditions.checkNotNull((Object)string, (Object)"Content URL must be non-null.");
            Preconditions.checkNotEmpty((String)string, (Object)"Content URL must be non-empty.");
            boolean bl = string.length() <= 512;
            Object[] objectArray = new Object[]{512, string.length()};
            Preconditions.checkArgument((boolean)bl, (String)"Content URL must not exceed %d in length.  Provided length was %d.", (Object[])objectArray);
            this.zza.zzh(string);
            return this;
        }

        @RecentlyNonNull
        public Builder setNeighboringContentUrls(@RecentlyNonNull List<String> list) {
            if (list == null) {
                zzbbf.zzi("neighboring content URLs list should not be null");
                return this;
            }
            this.zza.zzi(list);
            return this;
        }

        @RecentlyNonNull
        public Builder setLocation(@RecentlyNonNull Location location) {
            this.zza.zzk(location);
            return this;
        }

        @RecentlyNonNull
        public Builder setRequestAgent(@RecentlyNonNull String string) {
            this.zza.zzm(string);
            return this;
        }

        @KeepForSdk
        @RecentlyNonNull
        public Builder setAdInfo(@RecentlyNonNull AdInfo adInfo) {
            this.zza.zzr(adInfo);
            return this;
        }

        @RecentlyNonNull
        public Builder setHttpTimeoutMillis(int n) {
            this.zza.zzs(n);
            return this;
        }

        @Deprecated
        @RecentlyNonNull
        public final Builder zza(@RecentlyNonNull String string) {
            this.zza.zze(string);
            return this;
        }

        @Deprecated
        @RecentlyNonNull
        public final Builder zzb(@RecentlyNonNull Date date) {
            this.zza.zzg(date);
            return this;
        }

        @Deprecated
        @RecentlyNonNull
        public final Builder zzc(int n) {
            this.zza.zzj(n);
            return this;
        }

        @Deprecated
        @RecentlyNonNull
        public final Builder zzd(boolean bl) {
            this.zza.zzn(bl);
            return this;
        }

        @Deprecated
        @RecentlyNonNull
        public final Builder zze(boolean bl) {
            this.zza.zzq(bl);
            return this;
        }
    }
}

