/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.ads.zzc;
import com.google.android.gms.internal.ads.zzbbf;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public class RequestConfiguration {
    public static final int TAG_FOR_CHILD_DIRECTED_TREATMENT_UNSPECIFIED = -1;
    public static final int TAG_FOR_CHILD_DIRECTED_TREATMENT_FALSE = 0;
    public static final int TAG_FOR_CHILD_DIRECTED_TREATMENT_TRUE = 1;
    public static final int TAG_FOR_UNDER_AGE_OF_CONSENT_TRUE = 1;
    public static final int TAG_FOR_UNDER_AGE_OF_CONSENT_FALSE = 0;
    public static final int TAG_FOR_UNDER_AGE_OF_CONSENT_UNSPECIFIED = -1;
    @RecentlyNonNull
    public static final String MAX_AD_CONTENT_RATING_UNSPECIFIED = "";
    @RecentlyNonNull
    public static final String MAX_AD_CONTENT_RATING_G = "G";
    @RecentlyNonNull
    public static final String MAX_AD_CONTENT_RATING_PG = "PG";
    @RecentlyNonNull
    public static final String MAX_AD_CONTENT_RATING_T = "T";
    @RecentlyNonNull
    public static final String MAX_AD_CONTENT_RATING_MA = "MA";
    private final int zzb;
    private final int zzc;
    @Nullable
    private final String zzd;
    private final List<String> zze;
    @RecentlyNonNull
    public static final List<String> zza;

    public int getTagForChildDirectedTreatment() {
        return this.zzb;
    }

    public int getTagForUnderAgeOfConsent() {
        return this.zzc;
    }

    @RecentlyNonNull
    public String getMaxAdContentRating() {
        String string = ((RequestConfiguration)((Object)string)).zzd;
        if (string == null) {
            return MAX_AD_CONTENT_RATING_UNSPECIFIED;
        }
        return string;
    }

    @RecentlyNonNull
    public List<String> getTestDeviceIds() {
        ArrayList<String> arrayList = new ArrayList<String>(this.zze);
        return arrayList;
    }

    @RecentlyNonNull
    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.setTagForChildDirectedTreatment(this.zzb);
        builder.setTagForUnderAgeOfConsent(this.zzc);
        builder.setMaxAdContentRating(this.zzd);
        builder.setTestDeviceIds(this.zze);
        return builder;
    }

    static {
        String[] stringArray = new String[]{MAX_AD_CONTENT_RATING_MA, MAX_AD_CONTENT_RATING_T, MAX_AD_CONTENT_RATING_PG, MAX_AD_CONTENT_RATING_G};
        zza = Arrays.asList(stringArray);
    }

    /* synthetic */ RequestConfiguration(int n, int n2, String string, List list, zzc zzc2) {
        this.zzb = n;
        this.zzc = n2;
        this.zzd = string;
        this.zze = list;
    }

    public static class Builder {
        private int zza = -1;
        private int zzb = -1;
        @Nullable
        private String zzc = null;
        private final List<String> zzd;

        public Builder() {
            ArrayList<String> arrayList = new ArrayList<String>();
            this.zzd = arrayList;
        }

        @RecentlyNonNull
        public RequestConfiguration build() {
            RequestConfiguration requestConfiguration = new RequestConfiguration(this.zza, this.zzb, this.zzc, this.zzd, null);
            return requestConfiguration;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @RecentlyNonNull
        public Builder setTagForChildDirectedTreatment(int n) {
            if (n == -1 || n == 0 || n == 1) {
                this.zza = n;
                return this;
            }
            StringBuilder stringBuilder = new StringBuilder(68);
            stringBuilder.append("Invalid value passed to setTagForChildDirectedTreatment: ");
            stringBuilder.append(n);
            zzbbf.zzi(stringBuilder.toString());
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @RecentlyNonNull
        public Builder setTagForUnderAgeOfConsent(int n) {
            if (n == -1 || n == 0 || n == 1) {
                this.zzb = n;
                return this;
            }
            StringBuilder stringBuilder = new StringBuilder(63);
            stringBuilder.append("Invalid value passed to setTagForUnderAgeOfConsent: ");
            stringBuilder.append(n);
            zzbbf.zzi(stringBuilder.toString());
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @RecentlyNonNull
        public Builder setMaxAdContentRating(@Nullable String string) {
            if (string == null || RequestConfiguration.MAX_AD_CONTENT_RATING_UNSPECIFIED.equals(string)) {
                this.zzc = null;
                return this;
            }
            if (RequestConfiguration.MAX_AD_CONTENT_RATING_G.equals(string) || RequestConfiguration.MAX_AD_CONTENT_RATING_PG.equals(string) || RequestConfiguration.MAX_AD_CONTENT_RATING_T.equals(string) || RequestConfiguration.MAX_AD_CONTENT_RATING_MA.equals(string)) {
                this.zzc = string;
                return this;
            }
            String string2 = "Invalid value passed to setMaxAdContentRating: ";
            string = string.length() != 0 ? string2.concat(string) : new String(string2);
            zzbbf.zzi(string);
            return this;
        }

        @RecentlyNonNull
        public Builder setTestDeviceIds(@Nullable List<String> list) {
            this.zzd.clear();
            if (list != null) {
                this.zzd.addAll(list);
            }
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MaxAdContentRating {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TagForUnderAgeOfConsent {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TagForChildDirectedTreatment {
    }
}

