/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.ads.zzapp;
import com.google.android.gms.internal.ads.zzbbf;

public final class zzacy
extends ContentProvider {
    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void attachInfo(Context object, ProviderInfo providerInfo) {
        void var2_12;
        Object object2;
        void var1_7;
        try {
            object2 = Wrappers.packageManager((Context)var1_7).getApplicationInfo((String)var1_7.getPackageName(), (int)128).metaData;
        }
        catch (NullPointerException nullPointerException) {
            zzbbf.zzg("Failed to load metadata: Null pointer exception.", nullPointerException);
            object2 = null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            zzbbf.zzg("Failed to load metadata: Package name not found.", nameNotFoundException);
            object2 = null;
        }
        Object object3 = zzapp.zza();
        if (object2 == null) {
            zzbbf.zzf("Metadata was null.");
        } else {
            String string = (String)object2.get("com.google.android.gms.ads.APPLICATION_ID");
            Object object4 = (Boolean)object2.get("com.google.android.gms.ads.AD_MANAGER_APP");
            Boolean bl = (Boolean)object2.get("com.google.android.gms.ads.DELAY_APP_MEASUREMENT_INIT");
            object2 = (String)object2.get("com.google.android.gms.ads.INTEGRATION_MANAGER");
            if (string != null && !string.matches("^/\\d+~.+$")) {
                if (!string.matches("^ca-app-pub-[0-9]{16}~[0-9]{10}$")) {
                    IllegalStateException illegalStateException = new IllegalStateException("\n\n******************************************************************************\n* Invalid application ID. Follow instructions here:                          *\n* https://googlemobileadssdk.page.link/admob-android-update-manifest         *\n* to find your app ID.                                                       *\n******************************************************************************\n\n");
                    throw illegalStateException;
                }
                object2 = "Publisher provided Google AdMob App ID in manifest: ";
                object2 = string.length() != 0 ? ((String)object2).concat(string) : (object4 = new String((String)object2));
                zzbbf.zzd((String)object2);
                if (bl == null || !bl.booleanValue()) {
                    ((zzapp)object3).zzb((Context)var1_7, string);
                }
            } else if (object4 == null || !((Boolean)object4).booleanValue()) {
                if (TextUtils.isEmpty((CharSequence)object2)) {
                    IllegalStateException illegalStateException = new IllegalStateException("\n\n******************************************************************************\n* The Google Mobile Ads SDK was initialized incorrectly. AdMob publishers    *\n* should follow the instructions here:                                       *\n* https://googlemobileadssdk.page.link/admob-android-update-manifest         *\n* to add a valid App ID inside the AndroidManifest.                          *\n* Google Ad Manager publishers should follow instructions here:              *\n* https://googlemobileadssdk.page.link/ad-manager-android-update-manifest.   *\n******************************************************************************\n\n");
                    throw illegalStateException;
                }
                object2 = String.valueOf(object2);
                object3 = "The Google Mobile Ads SDK is integrated by ";
                object2 = ((String)object2).length() != 0 ? ((String)object3).concat((String)object2) : new String((String)object3);
                zzbbf.zzd((String)object2);
            }
        }
        super.attachInfo((Context)var1_7, (ProviderInfo)var2_12);
        return;
        catch (ClassCastException classCastException) {
            IllegalStateException illegalStateException = new IllegalStateException("The com.google.android.gms.ads.APPLICATION_ID metadata must have a String value.", classCastException);
            throw illegalStateException;
        }
        catch (ClassCastException classCastException) {
            IllegalStateException illegalStateException = new IllegalStateException("The com.google.android.gms.ads.AD_MANAGER_APP metadata must have a boolean value.", classCastException);
            throw illegalStateException;
        }
        catch (ClassCastException classCastException) {
            IllegalStateException illegalStateException = new IllegalStateException("The com.google.android.gms.ads.DELAY_APP_MEASUREMENT_INIT metadata must have a boolean value.", classCastException);
            throw illegalStateException;
        }
        catch (ClassCastException classCastException) {
            IllegalStateException illegalStateException = new IllegalStateException("The com.google.android.gms.ads.INTEGRATION_MANAGER metadata must have a String value.", classCastException);
            throw illegalStateException;
        }
    }

    public final boolean onCreate() {
        return false;
    }

    @Nullable
    public final Cursor query(@NonNull Uri uri, String[] stringArray, String string, String[] stringArray2, String string2) {
        return null;
    }

    @Nullable
    public final String getType(@NonNull Uri uri) {
        return null;
    }

    @Nullable
    public final Uri insert(@NonNull Uri uri, ContentValues contentValues) {
        return null;
    }

    public final int delete(@NonNull Uri uri, String string, String[] stringArray) {
        return 0;
    }

    public final int update(@NonNull Uri uri, ContentValues contentValues, String string, String[] stringArray) {
        return 0;
    }
}

