/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import com.google.android.gms.ads.formats.AdManagerAdViewOptions;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.formats.OnAdManagerAdViewLoadedListener;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdOptions;
import com.google.android.gms.ads.nativead.NativeCustomFormatAd;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzbct;
import com.google.android.gms.internal.ads.zzbdc;
import com.google.android.gms.internal.ads.zzbdd;
import com.google.android.gms.internal.ads.zzbeh;
import com.google.android.gms.internal.ads.zzbej;
import com.google.android.gms.internal.ads.zzbey;
import com.google.android.gms.internal.ads.zzbfb;
import com.google.android.gms.internal.ads.zzbhb;
import com.google.android.gms.internal.ads.zzbhs;
import com.google.android.gms.internal.ads.zzbij;
import com.google.android.gms.internal.ads.zzblk;
import com.google.android.gms.internal.ads.zzboa;
import com.google.android.gms.internal.ads.zzboc;
import com.google.android.gms.internal.ads.zzbod;
import com.google.android.gms.internal.ads.zzbus;
import com.google.android.gms.internal.ads.zzbyn;
import com.google.android.gms.internal.ads.zzbyp;
import com.google.android.gms.internal.ads.zzcgg;

public class AdLoader {
    private final zzbdc zza;
    private final Context zzb;
    private final zzbey zzc;

    /*
     * WARNING - void declaration
     */
    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(@RecentlyNonNull AdRequest adRequest) {
        void var1_1;
        this.zza(var1_1.zza());
    }

    /*
     * WARNING - void declaration
     */
    public void loadAd(@RecentlyNonNull AdManagerAdRequest adManagerAdRequest) {
        void var1_1;
        this.zza(var1_1.zza);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAds(@RecentlyNonNull AdRequest adRequest, int maxNumberOfAds) {
        zzbhb zzbhb2 = adRequest.zza();
        try {
            void var2_3;
            this.zzc.zzi(this.zza.zza(this.zzb, zzbhb2), (int)var2_3);
            return;
        }
        catch (RemoteException remoteException) {
            zzcgg.zzg("Failed to load ads.", remoteException);
            return;
        }
    }

    public boolean isLoading() {
        try {
            boolean bl = this.zzc.zzg();
            return bl;
        }
        catch (RemoteException remoteException) {
            zzcgg.zzj("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    AdLoader(Context context, zzbey zzbey2, zzbdc zzbdc2) {
        this.zzb = context;
        this.zzc = zzbey2;
        this.zza = zzbdc2;
    }

    private final void zza(zzbhb zzbhb2) {
        try {
            this.zzc.zze(this.zza.zza(this.zzb, zzbhb2));
            return;
        }
        catch (RemoteException remoteException) {
            zzcgg.zzg("Failed to load ad.", remoteException);
            return;
        }
    }

    public static class Builder {
        private final Context zza;
        private final zzbfb zzb;

        /*
         * WARNING - void declaration
         */
        public Builder(@RecentlyNonNull Context context, @RecentlyNonNull String adUnitID) {
            void var2_2;
            zzbfb zzbfb2;
            Object object = Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
            object = (Context)object;
            zzbeh zzbeh2 = zzbej.zzb();
            zzbus zzbus2 = new zzbus();
            zzbfb2 = zzbeh2.zzc((Context)zzbfb2, (String)var2_2, zzbus2);
            this.zza = object;
            this.zzb = zzbfb2;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Deprecated
        @RecentlyNonNull
        public Builder forUnifiedNativeAd(@RecentlyNonNull UnifiedNativeAd.OnUnifiedNativeAdLoadedListener listener) {
            try {
                void var1_1;
                zzbfb zzbfb2 = this.zzb;
                zzbod zzbod2 = new zzbod((UnifiedNativeAd.OnUnifiedNativeAdLoadedListener)var1_1);
                zzbfb2.zzm(zzbod2);
                return this;
            }
            catch (RemoteException remoteException) {
                zzcgg.zzj("Failed to add google native ad listener", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @RecentlyNonNull
        public Builder forNativeAd(@RecentlyNonNull NativeAd.OnNativeAdLoadedListener listener) {
            try {
                void var1_1;
                zzbfb zzbfb2 = this.zzb;
                zzbyp zzbyp2 = new zzbyp((NativeAd.OnNativeAdLoadedListener)var1_1);
                zzbfb2.zzm(zzbyp2);
                return this;
            }
            catch (RemoteException remoteException) {
                zzcgg.zzj("Failed to add google native ad listener", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Deprecated
        @RecentlyNonNull
        public Builder forCustomTemplateAd(@RecentlyNonNull String templateId, @RecentlyNonNull NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener adLoadedListener, @Nullable NativeCustomTemplateAd.OnCustomClickListener customClickListener) {
            void var3_4;
            void var2_3;
            zzboa zzboa2 = new zzboa((NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener)var2_3, (NativeCustomTemplateAd.OnCustomClickListener)var3_4);
            try {
                void var1_1;
                this.zzb.zzi((String)var1_1, zzboa2.zza(), zzboa2.zzb());
                return this;
            }
            catch (RemoteException remoteException) {
                zzcgg.zzj("Failed to add custom template ad listener", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @RecentlyNonNull
        public Builder forCustomFormatAd(@RecentlyNonNull String customFormatId, @RecentlyNonNull NativeCustomFormatAd.OnCustomFormatAdLoadedListener adLoadedListener, @Nullable NativeCustomFormatAd.OnCustomClickListener customClickListener) {
            void var3_4;
            void var2_3;
            zzbyn zzbyn2 = new zzbyn((NativeCustomFormatAd.OnCustomFormatAdLoadedListener)var2_3, (NativeCustomFormatAd.OnCustomClickListener)var3_4);
            try {
                void var1_1;
                this.zzb.zzi((String)var1_1, zzbyn2.zza(), zzbyn2.zzb());
                return this;
            }
            catch (RemoteException remoteException) {
                zzcgg.zzj("Failed to add custom format ad listener", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @RecentlyNonNull
        public Builder forAdManagerAdView(@RecentlyNonNull OnAdManagerAdViewLoadedListener listener, AdSize ... adSizes) {
            zzbfb zzbfb2;
            if (adSizes == null || ((void)zzbfb2).length <= 0) {
                Object object = new IllegalArgumentException("The supported ad sizes must contain at least one valid ad size.");
                throw object;
            }
            try {
                void var1_1;
                zzbdd zzbdd2 = new zzbdd(((Builder)object).zza, (AdSize[])zzbfb2);
                zzbfb2 = ((Builder)object).zzb;
                zzboc zzboc2 = new zzboc((OnAdManagerAdViewLoadedListener)var1_1);
                zzbfb2.zzk(zzboc2, zzbdd2);
                return object;
            }
            catch (RemoteException remoteException) {
                zzcgg.zzj("Failed to add Google Ad Manager banner ad listener", remoteException);
                return object;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @RecentlyNonNull
        public Builder withAdListener(@RecentlyNonNull AdListener listener) {
            try {
                void var1_1;
                zzbfb zzbfb2 = this.zzb;
                zzbct zzbct2 = new zzbct((AdListener)var1_1);
                zzbfb2.zzf(zzbct2);
                return this;
            }
            catch (RemoteException remoteException) {
                zzcgg.zzj("Failed to set AdListener.", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Deprecated
        @RecentlyNonNull
        public Builder withNativeAdOptions(@RecentlyNonNull com.google.android.gms.ads.formats.NativeAdOptions options) {
            try {
                void var1_1;
                zzbfb zzbfb2 = this.zzb;
                zzblk zzblk2 = new zzblk((com.google.android.gms.ads.formats.NativeAdOptions)var1_1);
                zzbfb2.zzj(zzblk2);
                return this;
            }
            catch (RemoteException remoteException) {
                zzcgg.zzj("Failed to specify native ad options", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @RecentlyNonNull
        public Builder withNativeAdOptions(@RecentlyNonNull NativeAdOptions options) {
            try {
                void var2_10;
                void var1_1;
                zzbfb zzbfb2 = this.zzb;
                boolean bl = var1_1.shouldReturnUrlsForImageAssets();
                boolean bl2 = var1_1.shouldRequestMultipleImages();
                int n = var1_1.getAdChoicesPlacement();
                VideoOptions videoOptions = var1_1.getVideoOptions();
                if (videoOptions != null) {
                    zzbij zzbij2 = new zzbij(var1_1.getVideoOptions());
                } else {
                    Object var2_11 = null;
                }
                zzblk zzblk2 = new zzblk(4, bl, -1, bl2, n, (zzbij)var2_10, var1_1.zza(), var1_1.getMediaAspectRatio());
                zzbfb2.zzj(zzblk2);
                return this;
            }
            catch (RemoteException remoteException) {
                zzcgg.zzj("Failed to specify native ad options", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @RecentlyNonNull
        public Builder withAdManagerAdViewOptions(@RecentlyNonNull AdManagerAdViewOptions options) {
            try {
                void var1_1;
                this.zzb.zzp((AdManagerAdViewOptions)var1_1);
                return this;
            }
            catch (RemoteException remoteException) {
                zzcgg.zzj("Failed to specify Ad Manager banner ad options", remoteException);
                return this;
            }
        }

        @RecentlyNonNull
        public AdLoader build() {
            try {
                Context context = this.zza;
                zzbey zzbey2 = this.zzb.zze();
                AdLoader adLoader = new AdLoader(context, zzbey2, zzbdc.zza);
                return adLoader;
            }
            catch (RemoteException remoteException) {
                zzcgg.zzg("Failed to build AdLoader.", remoteException);
                zzbhs zzbhs2 = new zzbhs();
                AdLoader adLoader = new AdLoader(this.zza, zzbhs2.zzb(), zzbdc.zza);
                return adLoader;
            }
        }
    }
}

