/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.nativead;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.ads.MediaContent;
import com.google.android.gms.ads.nativead.AdChoicesView;
import com.google.android.gms.ads.nativead.MediaView;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.zzb;
import com.google.android.gms.ads.nativead.zzc;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzbej;
import com.google.android.gms.internal.ads.zzbel;
import com.google.android.gms.internal.ads.zzbhn;
import com.google.android.gms.internal.ads.zzbjb;
import com.google.android.gms.internal.ads.zzblh;
import com.google.android.gms.internal.ads.zzblj;
import com.google.android.gms.internal.ads.zzbma;
import com.google.android.gms.internal.ads.zzcgg;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public final class NativeAdView
extends FrameLayout {
    @NotOnlyInitialized
    private final FrameLayout zza;
    @NotOnlyInitialized
    @Nullable
    private final zzbma zzb;

    /*
     * WARNING - void declaration
     */
    public NativeAdView(@RecentlyNonNull Context context) {
        super((Context)var1_1);
        void var1_1;
        this.zza = this.zze((Context)var1_1);
        this.zzb = this.zzf();
    }

    /*
     * WARNING - void declaration
     */
    public NativeAdView(@RecentlyNonNull Context context, @RecentlyNonNull AttributeSet attrs) {
        super((Context)var1_1, (AttributeSet)var2_2);
        void var2_2;
        void var1_1;
        this.zza = this.zze((Context)var1_1);
        this.zzb = this.zzf();
    }

    /*
     * WARNING - void declaration
     */
    public NativeAdView(@RecentlyNonNull Context context, @RecentlyNonNull AttributeSet attrs, int defStyleAttr) {
        super((Context)var1_1, (AttributeSet)var2_2, (int)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
        this.zza = this.zze((Context)var1_1);
        this.zzb = this.zzf();
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=21)
    public NativeAdView(@RecentlyNonNull Context context, @RecentlyNonNull AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super((Context)var1_1, (AttributeSet)var2_2, (int)var3_3, (int)var4_4);
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        this.zza = this.zze((Context)var1_1);
        this.zzb = this.zzf();
    }

    /*
     * WARNING - void declaration
     */
    public final void setHeadlineView(@Nullable View view) {
        void var1_1;
        this.zzd("3001", (View)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setCallToActionView(@Nullable View view) {
        void var1_1;
        this.zzd("3002", (View)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setIconView(@Nullable View view) {
        void var1_1;
        this.zzd("3003", (View)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setBodyView(@Nullable View view) {
        void var1_1;
        this.zzd("3004", (View)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setAdvertiserView(@Nullable View view) {
        void var1_1;
        this.zzd("3005", (View)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setStoreView(@Nullable View view) {
        void var1_1;
        this.zzd("3006", (View)var1_1);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setClickConfirmingView(@Nullable View view) {
        zzbma this_ = ((NativeAdView)((Object)this_)).zzb;
        if (this_ == null) return;
        try {
            void var1_2;
            this_.zzg(ObjectWrapper.wrap((Object)var1_2));
            return;
        }
        catch (RemoteException remoteException) {
            zzcgg.zzg("Unable to call setClickConfirmingView on delegate", remoteException);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setPriceView(@Nullable View view) {
        void var1_1;
        this.zzd("3007", (View)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setImageView(@Nullable View view) {
        void var1_1;
        this.zzd("3008", (View)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setStarRatingView(@Nullable View view) {
        void var1_1;
        this.zzd("3009", (View)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setMediaView(@Nullable MediaView view) {
        void var1_1;
        this.zzd("3010", (View)var1_1);
        if (var1_1 == null) {
            return;
        }
        Object object = new zzb(this);
        var1_1.zza((zzblh)object);
        object = new zzc(this);
        var1_1.zzb((zzblj)object);
    }

    /*
     * WARNING - void declaration
     */
    public void setAdChoicesView(@Nullable AdChoicesView adChoicesView) {
        void var1_1;
        this.zzd("3011", (View)var1_1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setNativeAd(@RecentlyNonNull NativeAd ad) {
        zzbma this_ = ((NativeAdView)((Object)this_)).zzb;
        if (this_ == null) return;
        try {
            Object object;
            object = ((NativeAd)object).zza();
            this_.zzd((IObjectWrapper)object);
            return;
        }
        catch (RemoteException remoteException) {
            zzcgg.zzg("Unable to call setNativeAd on delegate", remoteException);
            return;
        }
    }

    @RecentlyNullable
    public final View getHeadlineView() {
        return this.zza("3001");
    }

    @RecentlyNullable
    public final View getCallToActionView() {
        return this.zza("3002");
    }

    @RecentlyNullable
    public final View getIconView() {
        return this.zza("3003");
    }

    @RecentlyNullable
    public final View getBodyView() {
        return this.zza("3004");
    }

    @RecentlyNullable
    public final View getStoreView() {
        return this.zza("3006");
    }

    @RecentlyNullable
    public final View getPriceView() {
        return this.zza("3007");
    }

    @RecentlyNullable
    public final View getAdvertiserView() {
        return this.zza("3005");
    }

    @RecentlyNullable
    public final View getImageView() {
        return this.zza("3008");
    }

    @RecentlyNullable
    public final View getStarRatingView() {
        return this.zza("3009");
    }

    @RecentlyNullable
    public final MediaView getMediaView() {
        if ((this = this.zza("3010")) instanceof MediaView) {
            return (MediaView)((Object)this);
        }
        if (this != null) {
            zzcgg.zzd("View is not an instance of MediaView");
        }
        return null;
    }

    @RecentlyNullable
    public AdChoicesView getAdChoicesView() {
        if ((this = this.zza("3011")) instanceof AdChoicesView) {
            return (AdChoicesView)((Object)this);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void destroy() {
        zzbma this_ = ((NativeAdView)((Object)this_)).zzb;
        if (this_ == null) return;
        try {
            this_.zze();
            return;
        }
        catch (RemoteException remoteException) {
            zzcgg.zzg("Unable to destroy native ad view", remoteException);
            return;
        }
    }

    public final void addView(@RecentlyNonNull View view, int n, @RecentlyNonNull ViewGroup.LayoutParams layoutParams) {
        super.addView(view, n, layoutParams);
        super.bringChildToFront((View)this.zza);
    }

    public final void removeView(@RecentlyNonNull View view) {
        if (this.zza == view) {
            return;
        }
        super.removeView(view);
    }

    public final void removeAllViews() {
        super.removeAllViews();
        super.addView((View)this.zza);
    }

    public final void bringChildToFront(@RecentlyNonNull View view) {
        super.bringChildToFront(view);
        FrameLayout frameLayout = this.zza;
        if (frameLayout != view) {
            super.bringChildToFront((View)frameLayout);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void onVisibilityChanged(@RecentlyNonNull View view, int n) {
        super.onVisibilityChanged(view, n);
        zzbma zzbma2 = ((NativeAdView)((Object)zzbma2)).zzb;
        if (zzbma2 == null) return;
        try {
            zzbma2.zzf(ObjectWrapper.wrap((Object)view), n);
            return;
        }
        catch (RemoteException remoteException) {
            zzcgg.zzg("Unable to call onVisibilityChanged on delegate", remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean dispatchTouchEvent(@RecentlyNonNull MotionEvent motionEvent) {
        Object object = zzbjb.zzbV;
        if (zzbel.zzc().zzb(object) == false) return super.dispatchTouchEvent(motionEvent);
        object = this.zzb;
        if (object == null) return super.dispatchTouchEvent(motionEvent);
        try {
            object.zzbP(ObjectWrapper.wrap((Object)motionEvent));
            return super.dispatchTouchEvent(motionEvent);
        }
        catch (RemoteException remoteException) {
            zzcgg.zzg("Unable to call handleTouchEvent on delegate", remoteException);
            return super.dispatchTouchEvent(motionEvent);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void zzd(String string, @Nullable View view) {
        zzbma zzbma2 = ((NativeAdView)((Object)zzbma2)).zzb;
        if (zzbma2 == null) return;
        try {
            zzbma2.zzb(string, ObjectWrapper.wrap((Object)view));
            return;
        }
        catch (RemoteException remoteException) {
            zzcgg.zzg("Unable to call setAssetView on delegate", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RecentlyNullable
    protected final View zza(@RecentlyNonNull String string) {
        Object object = ((NativeAdView)((Object)object)).zzb;
        if (object == null) return null;
        try {
            object = object.zzc(string);
            if (object == null) return null;
        }
        catch (RemoteException remoteException) {
            zzcgg.zzg("Unable to call getAssetView on delegate", remoteException);
            return null;
        }
        return (View)ObjectWrapper.unwrap((IObjectWrapper)object);
    }

    private final FrameLayout zze(Context context) {
        FrameLayout frameLayout = new FrameLayout(context);
        context = new FrameLayout.LayoutParams(-1, -1);
        frameLayout.setLayoutParams((ViewGroup.LayoutParams)context);
        this.addView((View)frameLayout);
        return frameLayout;
    }

    @RequiresNonNull(value={"overlayFrame"})
    @Nullable
    private final zzbma zzf() {
        if (this.isInEditMode()) {
            return null;
        }
        return zzbej.zzb().zzd(this.zza.getContext(), this, this.zza);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final /* synthetic */ void zzb(ImageView.ScaleType scaleType) {
        zzbma zzbma2 = ((NativeAdView)((Object)zzbma2)).zzb;
        if (zzbma2 == null) {
            return;
        }
        if (scaleType == null) return;
        try {
            zzbma2.zzbO(ObjectWrapper.wrap((Object)scaleType));
            return;
        }
        catch (RemoteException remoteException) {
            zzcgg.zzg("Unable to call setMediaViewImageScaleType on delegate", remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final /* synthetic */ void zzc(MediaContent mediaContent) {
        zzbma zzbma2 = ((NativeAdView)((Object)zzbma2)).zzb;
        if (zzbma2 == null) {
            return;
        }
        try {
            boolean bl = mediaContent instanceof zzbhn;
            if (bl) {
                zzbma2.zzbQ(((zzbhn)mediaContent).zza());
                return;
            }
            if (mediaContent == null) {
                zzbma2.zzbQ(null);
                return;
            }
            zzcgg.zzd("Use MediaContent provided by NativeAd.getMediaContent");
            return;
        }
        catch (RemoteException remoteException) {
            zzcgg.zzg("Unable to call setMediaContent on delegate", remoteException);
            return;
        }
    }
}

