/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import com.google.android.gms.ads.formats.AdManagerAdViewOptions;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.formats.OnAdManagerAdViewLoadedListener;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdOptions;
import com.google.android.gms.ads.nativead.NativeCustomFormatAd;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzbdb;
import com.google.android.gms.internal.ads.zzbdk;
import com.google.android.gms.internal.ads.zzbdl;
import com.google.android.gms.internal.ads.zzbep;
import com.google.android.gms.internal.ads.zzber;
import com.google.android.gms.internal.ads.zzbfg;
import com.google.android.gms.internal.ads.zzbfj;
import com.google.android.gms.internal.ads.zzbhj;
import com.google.android.gms.internal.ads.zzbib;
import com.google.android.gms.internal.ads.zzbis;
import com.google.android.gms.internal.ads.zzblv;
import com.google.android.gms.internal.ads.zzbol;
import com.google.android.gms.internal.ads.zzbon;
import com.google.android.gms.internal.ads.zzboo;
import com.google.android.gms.internal.ads.zzbvd;
import com.google.android.gms.internal.ads.zzbyy;
import com.google.android.gms.internal.ads.zzbza;
import com.google.android.gms.internal.ads.zzcgt;

public class AdLoader {
    private final zzbdk zza;
    private final Context zzb;
    private final zzbfg zzc;

    /*
     * WARNING - void declaration
     */
    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(@RecentlyNonNull AdRequest adRequest) {
        void var1_1;
        this.zza(var1_1.zza());
    }

    /*
     * WARNING - void declaration
     */
    public void loadAd(@RecentlyNonNull AdManagerAdRequest adManagerAdRequest) {
        void var1_1;
        this.zza(var1_1.zza);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAds(@RecentlyNonNull AdRequest adRequest, int maxNumberOfAds) {
        zzbhj zzbhj2 = adRequest.zza();
        try {
            void var2_3;
            this.zzc.zzi(this.zza.zza(this.zzb, zzbhj2), (int)var2_3);
            return;
        }
        catch (RemoteException remoteException) {
            zzcgt.zzg("Failed to load ads.", remoteException);
            return;
        }
    }

    public boolean isLoading() {
        try {
            boolean bl = this.zzc.zzg();
            return bl;
        }
        catch (RemoteException remoteException) {
            zzcgt.zzj("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    AdLoader(Context context, zzbfg zzbfg2, zzbdk zzbdk2) {
        this.zzb = context;
        this.zzc = zzbfg2;
        this.zza = zzbdk2;
    }

    private final void zza(zzbhj zzbhj2) {
        try {
            this.zzc.zze(this.zza.zza(this.zzb, zzbhj2));
            return;
        }
        catch (RemoteException remoteException) {
            zzcgt.zzg("Failed to load ad.", remoteException);
            return;
        }
    }

    public static class Builder {
        private final Context zza;
        private final zzbfj zzb;

        /*
         * WARNING - void declaration
         */
        public Builder(@RecentlyNonNull Context context, @RecentlyNonNull String adUnitID) {
            void var2_2;
            zzbfj zzbfj2;
            Object object = Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
            object = (Context)object;
            zzbep zzbep2 = zzber.zzb();
            zzbvd zzbvd2 = new zzbvd();
            zzbfj2 = zzbep2.zzl((Context)zzbfj2, (String)var2_2, zzbvd2);
            this.zza = object;
            this.zzb = zzbfj2;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Deprecated
        @RecentlyNonNull
        public Builder forUnifiedNativeAd(@RecentlyNonNull UnifiedNativeAd.OnUnifiedNativeAdLoadedListener listener) {
            try {
                void var1_1;
                zzbfj zzbfj2 = this.zzb;
                zzboo zzboo2 = new zzboo((UnifiedNativeAd.OnUnifiedNativeAdLoadedListener)var1_1);
                zzbfj2.zzm(zzboo2);
                return this;
            }
            catch (RemoteException remoteException) {
                zzcgt.zzj("Failed to add google native ad listener", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @RecentlyNonNull
        public Builder forNativeAd(@RecentlyNonNull NativeAd.OnNativeAdLoadedListener listener) {
            try {
                void var1_1;
                zzbfj zzbfj2 = this.zzb;
                zzbza zzbza2 = new zzbza((NativeAd.OnNativeAdLoadedListener)var1_1);
                zzbfj2.zzm(zzbza2);
                return this;
            }
            catch (RemoteException remoteException) {
                zzcgt.zzj("Failed to add google native ad listener", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Deprecated
        @RecentlyNonNull
        public Builder forCustomTemplateAd(@RecentlyNonNull String templateId, @RecentlyNonNull NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener adLoadedListener, @Nullable NativeCustomTemplateAd.OnCustomClickListener customClickListener) {
            void var3_4;
            void var2_3;
            zzbol zzbol2 = new zzbol((NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener)var2_3, (NativeCustomTemplateAd.OnCustomClickListener)var3_4);
            try {
                void var1_1;
                this.zzb.zzi((String)var1_1, zzbol2.zzc(), zzbol2.zzd());
                return this;
            }
            catch (RemoteException remoteException) {
                zzcgt.zzj("Failed to add custom template ad listener", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @RecentlyNonNull
        public Builder forCustomFormatAd(@RecentlyNonNull String customFormatId, @RecentlyNonNull NativeCustomFormatAd.OnCustomFormatAdLoadedListener adLoadedListener, @Nullable NativeCustomFormatAd.OnCustomClickListener customClickListener) {
            void var3_4;
            void var2_3;
            zzbyy zzbyy2 = new zzbyy((NativeCustomFormatAd.OnCustomFormatAdLoadedListener)var2_3, (NativeCustomFormatAd.OnCustomClickListener)var3_4);
            try {
                void var1_1;
                this.zzb.zzi((String)var1_1, zzbyy2.zzc(), zzbyy2.zzd());
                return this;
            }
            catch (RemoteException remoteException) {
                zzcgt.zzj("Failed to add custom format ad listener", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @RecentlyNonNull
        public Builder forAdManagerAdView(@RecentlyNonNull OnAdManagerAdViewLoadedListener listener, AdSize ... adSizes) {
            zzbfj zzbfj2;
            if (adSizes == null || ((void)zzbfj2).length <= 0) {
                Object object = new IllegalArgumentException("The supported ad sizes must contain at least one valid ad size.");
                throw object;
            }
            try {
                void var1_1;
                zzbdl zzbdl2 = new zzbdl(((Builder)object).zza, (AdSize[])zzbfj2);
                zzbfj2 = ((Builder)object).zzb;
                zzbon zzbon2 = new zzbon((OnAdManagerAdViewLoadedListener)var1_1);
                zzbfj2.zzk(zzbon2, zzbdl2);
                return object;
            }
            catch (RemoteException remoteException) {
                zzcgt.zzj("Failed to add Google Ad Manager banner ad listener", remoteException);
                return object;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @RecentlyNonNull
        public Builder withAdListener(@RecentlyNonNull AdListener listener) {
            try {
                void var1_1;
                zzbfj zzbfj2 = this.zzb;
                zzbdb zzbdb2 = new zzbdb((AdListener)var1_1);
                zzbfj2.zzf(zzbdb2);
                return this;
            }
            catch (RemoteException remoteException) {
                zzcgt.zzj("Failed to set AdListener.", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Deprecated
        @RecentlyNonNull
        public Builder withNativeAdOptions(@RecentlyNonNull com.google.android.gms.ads.formats.NativeAdOptions options) {
            try {
                void var1_1;
                zzbfj zzbfj2 = this.zzb;
                zzblv zzblv2 = new zzblv((com.google.android.gms.ads.formats.NativeAdOptions)var1_1);
                zzbfj2.zzj(zzblv2);
                return this;
            }
            catch (RemoteException remoteException) {
                zzcgt.zzj("Failed to specify native ad options", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @RecentlyNonNull
        public Builder withNativeAdOptions(@RecentlyNonNull NativeAdOptions options) {
            try {
                void var2_10;
                void var1_1;
                zzbfj zzbfj2 = this.zzb;
                boolean bl = var1_1.shouldReturnUrlsForImageAssets();
                boolean bl2 = var1_1.shouldRequestMultipleImages();
                int n = var1_1.getAdChoicesPlacement();
                VideoOptions videoOptions = var1_1.getVideoOptions();
                if (videoOptions != null) {
                    zzbis zzbis2 = new zzbis(var1_1.getVideoOptions());
                } else {
                    Object var2_11 = null;
                }
                zzblv zzblv2 = new zzblv(4, bl, -1, bl2, n, (zzbis)var2_10, var1_1.zza(), var1_1.getMediaAspectRatio());
                zzbfj2.zzj(zzblv2);
                return this;
            }
            catch (RemoteException remoteException) {
                zzcgt.zzj("Failed to specify native ad options", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @RecentlyNonNull
        public Builder withAdManagerAdViewOptions(@RecentlyNonNull AdManagerAdViewOptions options) {
            try {
                void var1_1;
                this.zzb.zzp((AdManagerAdViewOptions)var1_1);
                return this;
            }
            catch (RemoteException remoteException) {
                zzcgt.zzj("Failed to specify Ad Manager banner ad options", remoteException);
                return this;
            }
        }

        @RecentlyNonNull
        public AdLoader build() {
            try {
                Context context = this.zza;
                zzbfg zzbfg2 = this.zzb.zze();
                AdLoader adLoader = new AdLoader(context, zzbfg2, zzbdk.zza);
                return adLoader;
            }
            catch (RemoteException remoteException) {
                zzcgt.zzg("Failed to build AdLoader.", remoteException);
                zzbib zzbib2 = new zzbib();
                AdLoader adLoader = new AdLoader(this.zza, zzbib2.zzc(), zzbdk.zza);
                return adLoader;
            }
        }
    }
}

