/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.ResponseInfo;
import com.google.android.gms.ads.admanager.AppEventListener;
import com.google.android.gms.internal.ads.zzbcv;
import com.google.android.gms.internal.ads.zzbhl;
import com.google.android.gms.internal.ads.zzcgt;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;

public abstract class BaseAdView
extends ViewGroup {
    @NotOnlyInitialized
    protected final zzbhl zza;

    /*
     * WARNING - void declaration
     */
    protected BaseAdView(@RecentlyNonNull Context context, int adViewType) {
        super((Context)zzbhl2);
        void var2_2;
        zzbhl zzbhl2;
        this.zza = zzbhl2 = new zzbhl(this, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected BaseAdView(@RecentlyNonNull Context context, @RecentlyNonNull AttributeSet attrs, int adViewType) {
        super((Context)zzbhl2, (AttributeSet)var2_2);
        void var3_3;
        void var2_2;
        zzbhl zzbhl2;
        this.zza = zzbhl2 = new zzbhl(this, (AttributeSet)var2_2, false, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected BaseAdView(@RecentlyNonNull Context context, @RecentlyNonNull AttributeSet attrs, boolean allowMultipleAdSizes) {
        super((Context)zzbhl2, (AttributeSet)var2_2);
        void var3_3;
        void var2_2;
        zzbhl zzbhl2;
        this.zza = zzbhl2 = new zzbhl(this, (AttributeSet)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected BaseAdView(@RecentlyNonNull Context context, @RecentlyNonNull AttributeSet attrs, int defStyle, int adViewType) {
        super((Context)zzbhl2, (AttributeSet)var2_2, (int)var3_3);
        void var4_4;
        void var3_3;
        void var2_2;
        zzbhl zzbhl2;
        this.zza = zzbhl2 = new zzbhl(this, (AttributeSet)var2_2, false, (int)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    protected BaseAdView(@RecentlyNonNull Context context, @RecentlyNonNull AttributeSet attrs, int defStyle, int adViewType, boolean allowMultipleAdSizes) {
        super((Context)zzbhl2, (AttributeSet)var2_2, (int)var3_3);
        void var4_4;
        void var5_5;
        void var3_3;
        void var2_2;
        zzbhl zzbhl2;
        this.zza = zzbhl2 = new zzbhl(this, (AttributeSet)var2_2, (boolean)var5_5, (int)var4_4);
    }

    public void destroy() {
        this.zza.zzb();
    }

    @RecentlyNonNull
    public AdListener getAdListener() {
        return this.zza.zzc();
    }

    @RecentlyNullable
    public AdSize getAdSize() {
        return this.zza.zzd();
    }

    @RecentlyNonNull
    public String getAdUnitId() {
        return this.zza.zzf();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(@RecentlyNonNull AdRequest adRequest) {
        void var1_1;
        this.zza.zzh(var1_1.zza());
    }

    public void pause() {
        this.zza.zzi();
    }

    public void resume() {
        this.zza.zzk();
    }

    public boolean isLoading() {
        return this.zza.zzs();
    }

    /*
     * WARNING - void declaration
     */
    public void setAdListener(@RecentlyNonNull AdListener adListener) {
        void var1_1;
        this.zza.zzl((AdListener)var1_1);
        if (var1_1 == null) {
            this.zza.zzm(null);
            return;
        }
        if (var1_1 instanceof zzbcv) {
            this.zza.zzm((zzbcv)var1_1);
        }
        if (var1_1 instanceof AppEventListener) {
            this.zza.zzq((AppEventListener)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setAdSize(@RecentlyNonNull AdSize adSize) {
        void var1_1;
        zzbhl this_ = ((BaseAdView)((Object)this_)).zza;
        AdSize[] adSizeArray = new AdSize[]{var1_1};
        this_.zzn(adSizeArray);
    }

    /*
     * WARNING - void declaration
     */
    public void setAdUnitId(@RecentlyNonNull String adUnitId) {
        void var1_1;
        this.zza.zzp((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void onLayout(boolean bl, int left, int top, int right, int bottom) {
        if ((this = this.getChildAt(0)) != null && this.getVisibility() != 8) {
            void var3_4;
            void var5_6;
            void var2_3;
            void var4_5;
            int n = this.getMeasuredWidth();
            int n2 = this.getMeasuredHeight();
            var2_3 = (var4_5 - var2_3 - n) / 2;
            var3_4 = (var5_6 - var3_4 - n2) / 2;
            this.layout((int)var2_3, (int)var3_4, (int)(var2_3 + n), (int)(var3_4 + n2));
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n;
        int n2;
        int n3;
        void var2_2;
        void var1_1;
        Object object = this.getChildAt(0);
        if (object != null && object.getVisibility() != 8) {
            this.measureChild((View)object, (int)var1_1, (int)var2_2);
            n3 = object.getMeasuredWidth();
            n2 = object.getMeasuredHeight();
            n = n3;
            n3 = n2;
        } else {
            try {
                object = this.getAdSize();
            }
            catch (NullPointerException nullPointerException) {
                zzcgt.zzg("Unable to retrieve ad size.", nullPointerException);
                object = null;
            }
            if (object != null) {
                Context context = this.getContext();
                n2 = ((AdSize)object).getWidthInPixels(context);
                n3 = ((AdSize)object).getHeightInPixels(context);
                n = n2;
            } else {
                n = 0;
                n3 = 0;
            }
        }
        n2 = this.getSuggestedMinimumWidth();
        n = Math.max(n, n2);
        n2 = this.getSuggestedMinimumHeight();
        n3 = Math.max(n3, n2);
        this.setMeasuredDimension(View.resolveSize((int)n, (int)var1_1), View.resolveSize((int)n3, (int)var2_2));
    }

    @RecentlyNullable
    public ResponseInfo getResponseInfo() {
        return this.zza.zzt();
    }

    /*
     * WARNING - void declaration
     */
    public void setOnPaidEventListener(@Nullable OnPaidEventListener listener) {
        void var1_1;
        this.zza.zzu((OnPaidEventListener)var1_1);
    }

    @RecentlyNullable
    public OnPaidEventListener getOnPaidEventListener() {
        return this.zza.zzv();
    }
}

