/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.search;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.search.DynamicHeightSearchAdRequest;
import com.google.android.gms.ads.search.SearchAdRequest;
import com.google.android.gms.internal.ads.zzbhl;
import com.google.android.gms.internal.ads.zzcgt;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;

public final class SearchAdView
extends ViewGroup {
    @NotOnlyInitialized
    private final zzbhl zza;

    public SearchAdView(@RecentlyNonNull Context context) {
        super((Context)zzbhl2);
        zzbhl zzbhl2;
        this.zza = zzbhl2 = new zzbhl(this);
    }

    /*
     * WARNING - void declaration
     */
    public SearchAdView(@RecentlyNonNull Context context, @RecentlyNonNull AttributeSet attrs) {
        super((Context)zzbhl2, (AttributeSet)var2_2);
        void var2_2;
        zzbhl zzbhl2;
        this.zza = zzbhl2 = new zzbhl(this, (AttributeSet)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public SearchAdView(@RecentlyNonNull Context context, @RecentlyNonNull AttributeSet attrs, int defStyle) {
        super((Context)zzbhl2, (AttributeSet)var2_2, (int)var3_3);
        void var3_3;
        void var2_2;
        zzbhl zzbhl2;
        this.zza = zzbhl2 = new zzbhl(this, (AttributeSet)var2_2, false);
    }

    public void destroy() {
        this.zza.zzb();
    }

    @RecentlyNonNull
    public AdListener getAdListener() {
        return this.zza.zzc();
    }

    @RecentlyNullable
    public AdSize getAdSize() {
        return this.zza.zzd();
    }

    @RecentlyNonNull
    public String getAdUnitId() {
        return this.zza.zzf();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(@RecentlyNonNull SearchAdRequest searchAdRequest) {
        void var1_1;
        this.zza.zzh(var1_1.zza());
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(@RecentlyNonNull DynamicHeightSearchAdRequest dynamicHeightSearchAdRequest) {
        void var1_1;
        if (!AdSize.SEARCH.equals(object.getAdSize())) {
            Object object = new IllegalStateException("You must use AdSize.SEARCH for a DynamicHeightSearchAdRequest");
            throw object;
        }
        object.zza.zzh(var1_1.zza());
    }

    public void pause() {
        this.zza.zzi();
    }

    public void resume() {
        this.zza.zzk();
    }

    /*
     * WARNING - void declaration
     */
    public void setAdListener(@RecentlyNonNull AdListener adListener) {
        void var1_1;
        this.zza.zzl((AdListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setAdSize(@RecentlyNonNull AdSize adSize) {
        void var1_1;
        zzbhl this_ = ((SearchAdView)((Object)this_)).zza;
        AdSize[] adSizeArray = new AdSize[]{var1_1};
        this_.zzn(adSizeArray);
    }

    /*
     * WARNING - void declaration
     */
    public void setAdUnitId(@RecentlyNonNull String adUnitId) {
        void var1_1;
        this.zza.zzp((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void onLayout(boolean bl, int left, int top, int right, int bottom) {
        if ((this = this.getChildAt(0)) != null && this.getVisibility() != 8) {
            void var3_4;
            void var5_6;
            void var2_3;
            void var4_5;
            int n = this.getMeasuredWidth();
            int n2 = this.getMeasuredHeight();
            var2_3 = (var4_5 - var2_3 - n) / 2;
            var3_4 = (var5_6 - var3_4 - n2) / 2;
            this.layout((int)var2_3, (int)var3_4, (int)(var2_3 + n), (int)(var3_4 + n2));
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n;
        int n2;
        int n3;
        void var2_2;
        void var1_1;
        Object object = this.getChildAt(0);
        if (object != null && object.getVisibility() != 8) {
            this.measureChild((View)object, (int)var1_1, (int)var2_2);
            n3 = object.getMeasuredWidth();
            n2 = object.getMeasuredHeight();
            n = n3;
            n3 = n2;
        } else {
            try {
                object = this.getAdSize();
            }
            catch (NullPointerException nullPointerException) {
                zzcgt.zzg("Unable to retrieve ad size.", nullPointerException);
                object = null;
            }
            if (object != null) {
                Context context = this.getContext();
                n2 = ((AdSize)object).getWidthInPixels(context);
                n3 = ((AdSize)object).getHeightInPixels(context);
                n = n2;
            } else {
                n = 0;
                n3 = 0;
            }
        }
        n2 = this.getSuggestedMinimumWidth();
        n = Math.max(n, n2);
        n2 = this.getSuggestedMinimumHeight();
        n3 = Math.max(n3, n2);
        this.setMeasuredDimension(View.resolveSize((int)n, (int)var1_1), View.resolveSize((int)n3, (int)var2_2));
    }
}

