/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.gms.ads.h5.OnH5AdsEventListener;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzbep;
import com.google.android.gms.internal.ads.zzber;
import com.google.android.gms.internal.ads.zzbet;
import com.google.android.gms.internal.ads.zzbjd;
import com.google.android.gms.internal.ads.zzbjl;
import com.google.android.gms.internal.ads.zzbqp;
import com.google.android.gms.internal.ads.zzbvd;
import com.google.android.gms.internal.ads.zzcgt;

@RequiresApi(api=21)
public final class zzbqt {
    private final Context zza;
    private final OnH5AdsEventListener zzb;
    @Nullable
    private zzbqp zzc;

    /*
     * Enabled aggressive block sorting
     */
    public zzbqt(Context context, OnH5AdsEventListener onH5AdsEventListener) {
        boolean bl = Build.VERSION.SDK_INT >= 21;
        Preconditions.checkState((boolean)bl, (Object)"Android version must be Lollipop or higher");
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)onH5AdsEventListener);
        this.zza = context;
        this.zzb = onH5AdsEventListener;
        zzbjl.zza(context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean zza(String string) {
        if (!zzbqt.zzc(string)) {
            return false;
        }
        ((zzbqt)((Object)zzbqp2)).zzd();
        zzbqp zzbqp2 = ((zzbqt)((Object)zzbqp2)).zzc;
        if (zzbqp2 == null) return false;
        try {
            zzbqp2.zze(string);
            return true;
        }
        catch (RemoteException remoteException) {
            zzcgt.zzl("#007 Could not call remote method.", remoteException);
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void zzb() {
        zzbjd<Boolean> zzbjd2 = zzbjl.zzgJ;
        if (!zzbet.zzc().zzc(zzbjd2).booleanValue()) {
            return;
        }
        ((zzbqt)((Object)zzbqp2)).zzd();
        zzbqp zzbqp2 = ((zzbqt)((Object)zzbqp2)).zzc;
        if (zzbqp2 == null) return;
        try {
            zzbqp2.zzf();
            return;
        }
        catch (RemoteException remoteException) {
            zzcgt.zzl("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    private final void zzd() {
        if (this.zzc != null) {
            return;
        }
        zzbep zzbep2 = zzber.zzb();
        Context context = this.zza;
        zzbvd zzbvd2 = new zzbvd();
        this.zzc = zzbep2.zzs(context, zzbvd2, this.zzb);
    }

    public static final boolean zzc(String string) {
        zzbjd<Boolean> zzbjd2 = zzbjl.zzgJ;
        if (!zzbet.zzc().zzc(zzbjd2).booleanValue()) {
            return false;
        }
        Preconditions.checkNotNull((Object)string);
        int n = string.length();
        zzbjd<Integer> zzbjd3 = zzbjl.zzgL;
        if (n > zzbet.zzc().zzc(zzbjd3)) {
            zzcgt.zzd("H5 GMSG exceeds max length");
            return false;
        }
        return "gmsg".equals((string = Uri.parse((String)string)).getScheme()) && "mobileads.google.com".equals(string.getHost()) && "/h5ads".equals(string.getPath());
    }
}

