/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.util.JsonWriter;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import com.google.android.gms.common.util.Base64Utils;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.internal.ads.zzbkv;
import com.google.android.gms.internal.ads.zzcgn;
import com.google.android.gms.internal.ads.zzcgo;
import com.google.android.gms.internal.ads.zzcgp;
import com.google.android.gms.internal.ads.zzcgq;
import com.google.android.gms.internal.ads.zzcgr;
import com.google.android.gms.internal.ads.zzcgt;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public final class zzcgs {
    private static final Object zzb;
    @GuardedBy(value="lock")
    private static boolean zzc;
    @GuardedBy(value="lock")
    private static boolean zzd;
    private static final Clock zze;
    private static final Set<String> zzf;
    private final List<String> zzg;
    public static final /* synthetic */ int zza;

    public zzcgs() {
        this(null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public zzcgs(@Nullable String object) {
        if (!zzcgs.zzj()) {
            object = new Object();
        } else {
            object = UUID.randomUUID();
            object = ((UUID)object).toString();
            String[] stringArray = new String[1];
            object = String.valueOf(object);
            String string = "network_request_";
            object = ((String)object).length() != 0 ? string.concat((String)object) : new Object(string);
            stringArray[0] = object;
            object = Arrays.asList(stringArray);
        }
        this.zzg = object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zza(HttpURLConnection httpURLConnection, @Nullable byte[] byArray) {
        if (!zzcgs.zzj()) {
            return;
        }
        HashMap<String, List<String>> hashMap = httpURLConnection.getRequestProperties() == null ? null : new HashMap<String, List<String>>(httpURLConnection.getRequestProperties());
        String string = new String(httpURLConnection.getURL().toString());
        String string2 = new String(httpURLConnection.getRequestMethod());
        this.zzn(string, string2, hashMap, byArray);
    }

    public final void zzb(String string, String string2, @Nullable Map<String, ?> map, @Nullable byte[] byArray) {
        if (!zzcgs.zzj()) {
            return;
        }
        this.zzn(string, "GET", map, byArray);
    }

    private final void zzn(String string, String string2, @Nullable Map<String, ?> map, @Nullable byte[] byArray) {
        zzcgn zzcgn2 = new zzcgn(string, string2, map, byArray);
        this.zzr("onNetworkRequest", zzcgn2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzc(HttpURLConnection object, int n) {
        if (!zzcgs.zzj()) {
            return;
        }
        HashMap<String, List<String>> hashMap = ((URLConnection)object).getHeaderFields() == null ? null : new HashMap<String, List<String>>(((URLConnection)object).getHeaderFields());
        this.zzo(hashMap, n);
        if (n >= 200 && n < 300) {
            return;
        }
        try {
            object = ((HttpURLConnection)object).getResponseMessage();
        }
        catch (IOException iOException) {
            object = String.valueOf(iOException.getMessage());
            String string = "Can not get error message from error HttpURLConnection\n";
            object = ((String)object).length() != 0 ? string.concat((String)object) : new String(string);
            zzcgt.zzi((String)object);
            object = null;
        }
        this.zzp((String)object);
    }

    public final void zzd(@Nullable Map<String, ?> map, int n) {
        if (!zzcgs.zzj()) {
            return;
        }
        this.zzo(map, n);
        if (n < 200 || n >= 300) {
            this.zzp(null);
            return;
        }
    }

    private final void zzo(@Nullable Map<String, ?> map, int n) {
        zzcgo zzcgo2 = new zzcgo(n, map);
        this.zzr("onNetworkResponse", zzcgo2);
    }

    public final void zze(@Nullable String string) {
        if (!zzcgs.zzj()) {
            return;
        }
        if (string == null) {
            return;
        }
        this.zzf(string.getBytes());
    }

    public final void zzf(byte[] byArray) {
        zzcgp zzcgp2 = new zzcgp(byArray);
        this.zzr("onNetworkResponseBody", zzcgp2);
    }

    private final void zzp(@Nullable String string) {
        zzcgq zzcgq2 = new zzcgq(string);
        this.zzr("onNetworkRequestError", zzcgq2);
    }

    private static void zzq(JsonWriter jsonWriter, @Nullable Map<String, ?> object) throws IOException {
        if (object == null) {
            return;
        }
        jsonWriter.name("headers").beginArray();
        for (Map.Entry entry : object.entrySet()) {
            String string = (String)entry.getKey();
            if (zzf.contains(string)) continue;
            if (entry.getValue() instanceof List) {
                for (Object object2 : (List)entry.getValue()) {
                    object2 = (String)object2;
                    jsonWriter.beginObject();
                    jsonWriter.name("name").value(string);
                    jsonWriter.name("value").value(object2);
                    jsonWriter.endObject();
                }
                continue;
            }
            if (entry.getValue() instanceof String) {
                jsonWriter.beginObject();
                jsonWriter.name("name").value(string);
                jsonWriter.name("value").value((String)entry.getValue());
                jsonWriter.endObject();
                continue;
            }
            zzcgt.zzf("Connection headers should be either Map<String, String> or Map<String, List<String>>");
            break;
        }
        jsonWriter.endArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzr(String string, zzcgr zzcgr2) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
        try {
            boolean bl;
            jsonWriter.beginObject();
            jsonWriter.name("timestamp").value(zze.currentTimeMillis());
            jsonWriter.name("event").value(string);
            jsonWriter.name("components").beginArray();
            Iterator<String> iterator = ((zzcgs)((Object)iterator)).zzg.iterator();
            while (bl = iterator.hasNext()) {
                jsonWriter.value((String)iterator.next());
            }
            jsonWriter.endArray();
            zzcgr2.zza(jsonWriter);
            jsonWriter.endObject();
            jsonWriter.flush();
            jsonWriter.close();
        }
        catch (IOException iOException) {
            zzcgt.zzg("unable to log", iOException);
        }
        zzcgs.zzs(stringWriter.toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    private static synchronized void zzs(String string) {
        zzcgt.zzh("GMA Debug BEGIN");
        int n = 0;
        while (true) {
            if (n >= string.length()) {
                zzcgt.zzh("GMA Debug FINISH");
                return;
            }
            int n2 = n + 4000;
            String string2 = String.valueOf(string.substring(n, Math.min(n2, string.length())));
            String string3 = "GMA Debug CONTENT ";
            string2 = string2.length() != 0 ? string3.concat(string2) : new String(string3);
            zzcgt.zzh(string2);
            n = n2;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void zzg() {
        Object object = zzb;
        synchronized (object) {
            zzc = false;
            zzd = false;
            String string = "Ad debug logging enablement is out of date.";
            zzcgt.zzi(string);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void zzh(boolean bl) {
        Object object = zzb;
        synchronized (object) {
            zzc = true;
            zzd = bl;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean zzi() {
        Object object = zzb;
        synchronized (object) {
            return zzc;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean zzj() {
        Object object = zzb;
        synchronized (object) {
            boolean bl = zzc;
            if (!bl) return false;
            bl = zzd;
            if (!bl) return false;
            return true;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public static boolean zzk(Context context) {
        if (Build.VERSION.SDK_INT < 17) {
            return false;
        }
        if (!zzbkv.zza.zze().booleanValue()) {
            return false;
        }
        try {
            int n = Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"development_settings_enabled", (int)0);
            return n != 0;
        }
        catch (Exception exception) {
            zzcgt.zzj("Fail to determine debug setting.", exception);
            return false;
        }
    }

    static final /* synthetic */ void zzl(int n, Map map, JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("params").beginObject();
        jsonWriter.name("firstline").beginObject();
        jsonWriter.name("code").value((long)n);
        jsonWriter.endObject();
        zzcgs.zzq(jsonWriter, map);
        jsonWriter.endObject();
    }

    static final /* synthetic */ void zzm(String string, String string2, Map map, byte[] byArray, JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("params").beginObject();
        jsonWriter.name("firstline").beginObject();
        jsonWriter.name("uri").value(string);
        jsonWriter.name("verb").value(string2);
        jsonWriter.endObject();
        zzcgs.zzq(jsonWriter, map);
        if (byArray != null) {
            jsonWriter.name("body").value(Base64Utils.encode((byte[])byArray));
        }
        jsonWriter.endObject();
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        zzb = hashSet;
        zzc = false;
        zzd = false;
        zze = DefaultClock.getInstance();
        hashSet = new HashSet<String>(Arrays.asList(new String[0]));
        zzf = hashSet;
    }
}

