/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.ads.AdapterResponseInfo;
import com.google.android.gms.internal.ads.zzbfm;
import com.google.android.gms.internal.ads.zzbgq;
import com.google.android.gms.internal.ads.zzbiw;
import com.google.android.gms.internal.ads.zzblj;
import com.google.android.gms.internal.ads.zzciz;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class ResponseInfo {
    @Nullable
    private final zzbiw zza;
    private final List<AdapterResponseInfo> zzb;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RecentlyNullable
    public String getMediationAdapterClassName() {
        try {
            zzbiw this_ = ((ResponseInfo)((Object)this_)).zza;
            if (this_ == null) return null;
        }
        catch (RemoteException remoteException) {
            zzciz.zzh("Could not forward getMediationAdapterClassName to ResponseInfo.", remoteException);
            return null;
        }
        return this_.zze();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RecentlyNullable
    public String getResponseId() {
        try {
            zzbiw this_ = ((ResponseInfo)((Object)this_)).zza;
            if (this_ == null) return null;
        }
        catch (RemoteException remoteException) {
            zzciz.zzh("Could not forward getResponseId to ResponseInfo.", remoteException);
            return null;
        }
        return this_.zzf();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RecentlyNonNull
    public String toString() {
        try {
            return ((ResponseInfo)this).zzc().toString(2);
        }
        catch (JSONException jSONException) {
            return "Error forming toString output.";
        }
    }

    @NonNull
    public List<AdapterResponseInfo> getAdapterResponses() {
        return this.zzb;
    }

    @Nullable
    public static ResponseInfo zza(@Nullable zzbiw zzbiw2) {
        if (zzbiw2 != null) {
            ResponseInfo responseInfo = new ResponseInfo(zzbiw2);
            return responseInfo;
        }
        return null;
    }

    @NonNull
    public static ResponseInfo zzb(@Nullable zzbiw zzbiw2) {
        ResponseInfo responseInfo = new ResponseInfo(zzbiw2);
        return responseInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    @RecentlyNonNull
    public final JSONObject zzc() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        String string = ((ResponseInfo)((Object)iterator)).getResponseId();
        if (string == null) {
            jSONObject.put("Response ID", (Object)"null");
        } else {
            jSONObject.put("Response ID", (Object)string);
        }
        if ((string = ((ResponseInfo)((Object)iterator)).getMediationAdapterClassName()) == null) {
            jSONObject.put("Mediation Adapter Class Name", (Object)"null");
        } else {
            jSONObject.put("Mediation Adapter Class Name", (Object)string);
        }
        string = new JSONArray();
        Iterator<AdapterResponseInfo> iterator = ((ResponseInfo)((Object)iterator)).zzb.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                jSONObject.put("Adapter Responses", (Object)string);
                return jSONObject;
            }
            string.put((Object)((AdapterResponseInfo)iterator.next()).zzb());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResponseInfo(@Nullable zzbiw object) {
        block4: {
            this.zza = object;
            object = new ArrayList();
            this.zzb = object;
            object = zzblj.zzge;
            if (((Boolean)zzbgq.zzc().zzb(object)).booleanValue() && (object = this.zza) != null) {
                try {
                    if ((object = object.zzg()) == null) break block4;
                    object = object.iterator();
                }
                catch (RemoteException remoteException) {
                    zzciz.zzh("Could not forward getAdapterResponseInfo to ResponseInfo.", remoteException);
                    return;
                }
                while (object.hasNext()) {
                    AdapterResponseInfo adapterResponseInfo = AdapterResponseInfo.zza((zzbfm)((Object)object.next()));
                    if (adapterResponseInfo == null) continue;
                    this.zzb.add(adapterResponseInfo);
                }
            }
        }
    }
}

