/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.RemoteException;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdInspectorError;
import com.google.android.gms.ads.OnAdInspectorClosedListener;
import com.google.android.gms.ads.RequestConfiguration;
import com.google.android.gms.ads.initialization.AdapterStatus;
import com.google.android.gms.ads.initialization.InitializationStatus;
import com.google.android.gms.ads.initialization.OnInitializationCompleteListener;
import com.google.android.gms.ads.mediation.rtb.RtbAdapter;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzaok;
import com.google.android.gms.internal.ads.zzbgg;
import com.google.android.gms.internal.ads.zzbgm;
import com.google.android.gms.internal.ads.zzbgo;
import com.google.android.gms.internal.ads.zzbgq;
import com.google.android.gms.internal.ads.zzbib;
import com.google.android.gms.internal.ads.zzbin;
import com.google.android.gms.internal.ads.zzbjj;
import com.google.android.gms.internal.ads.zzbjk;
import com.google.android.gms.internal.ads.zzbjn;
import com.google.android.gms.internal.ads.zzbjp;
import com.google.android.gms.internal.ads.zzbkk;
import com.google.android.gms.internal.ads.zzblj;
import com.google.android.gms.internal.ads.zzbtn;
import com.google.android.gms.internal.ads.zzbtu;
import com.google.android.gms.internal.ads.zzbtv;
import com.google.android.gms.internal.ads.zzbtw;
import com.google.android.gms.internal.ads.zzbxa;
import com.google.android.gms.internal.ads.zzbxe;
import com.google.android.gms.internal.ads.zzbxh;
import com.google.android.gms.internal.ads.zzccj;
import com.google.android.gms.internal.ads.zzcht;
import com.google.android.gms.internal.ads.zzcis;
import com.google.android.gms.internal.ads.zzciz;
import com.google.android.gms.internal.ads.zzfqr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public final class zzbjq {
    @GuardedBy(value="InternalMobileAds.class")
    private static zzbjq zza;
    private final ArrayList<OnInitializationCompleteListener> zzb;
    private final Object zzc;
    @GuardedBy(value="lock")
    private zzbib zzd;
    private boolean zze;
    private boolean zzf;
    @Nullable
    private OnAdInspectorClosedListener zzg;
    @NonNull
    private RequestConfiguration zzh;
    private InitializationStatus zzi;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final float zza() {
        Object object = ((zzbjq)((Object)zzbib2)).zzc;
        synchronized (object) {
            zzbib zzbib2 = ((zzbjq)((Object)zzbib2)).zzd;
            if (zzbib2 == null) {
                return 1.0f;
            }
            try {
                return zzbib2.zze();
            }
            catch (RemoteException remoteException) {
                String string = "Unable to get app volume.";
                zzciz.zzh(string, remoteException);
                return 1.0f;
            }
        }
    }

    static /* bridge */ /* synthetic */ OnAdInspectorClosedListener zzb(zzbjq zzbjq2) {
        return zzbjq2.zzg;
    }

    @NonNull
    public final RequestConfiguration zzc() {
        return this.zzh;
    }

    static /* bridge */ /* synthetic */ InitializationStatus zzd(zzbjq zzbjq2, List list) {
        return zzbjq.zzx(list);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final InitializationStatus zze() {
        Object object = this.zzc;
        synchronized (object) {
            InitializationStatus initializationStatus;
            zzbib zzbib2 = this.zzd;
            boolean bl = zzbib2 != null;
            Preconditions.checkState((boolean)bl, (Object)"MobileAds.initialize() must be called prior to getting initialization status.");
            try {
                initializationStatus = this.zzi;
                if (initializationStatus == null) return zzbjq.zzx(this.zzd.zzg());
            }
            catch (RemoteException remoteException) {
                String string = "Unable to get Initialization status.";
                zzciz.zzg(string);
                return new zzbjj(this);
            }
            return initializationStatus;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static zzbjq zzf() {
        Class<zzbjq> clazz = zzbjq.class;
        synchronized (clazz) {
            zzbjq zzbjq2 = zza;
            if (zzbjq2 != null) return zza;
            zza = zzbjq2 = new zzbjq();
            return zza;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String zzg() {
        Object object = ((zzbjq)this).zzc;
        synchronized (object) {
            zzbib zzbib2 = ((zzbjq)this).zzd;
            boolean bl = zzbib2 != null;
            Preconditions.checkState((boolean)bl, (Object)"MobileAds.initialize() must be called prior to getting version string.");
            try {
                return zzfqr.zzc(((zzbjq)this).zzd.zzf());
            }
            catch (RemoteException remoteException) {
                String string = "Unable to get version string.";
                zzciz.zzh(string, remoteException);
                return "";
            }
        }
    }

    static /* bridge */ /* synthetic */ ArrayList zzh(zzbjq zzbjq2) {
        return zzbjq2.zzb;
    }

    static /* bridge */ /* synthetic */ void zzi(zzbjq zzbjq2, boolean bl) {
        zzbjq2.zzf = true;
    }

    static /* bridge */ /* synthetic */ void zzj(zzbjq zzbjq2, boolean bl) {
        zzbjq2.zze = false;
    }

    private zzbjq() {
        ArrayList arrayList = new ArrayList();
        this.zzc = arrayList;
        this.zze = false;
        this.zzf = false;
        this.zzg = null;
        arrayList = new ArrayList();
        this.zzh = ((RequestConfiguration.Builder)((Object)arrayList)).build();
        arrayList = new ArrayList();
        this.zzb = arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzk(Context context) {
        Object object = ((zzbjq)((Object)string)).zzc;
        synchronized (object) {
            ((zzbjq)((Object)string)).zzv(context);
            try {
                ((zzbjq)((Object)string)).zzd.zzi();
            }
            catch (RemoteException remoteException) {
                String string = "Unable to disable mediation adapter initialization.";
                zzciz.zzg(string);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzl(Context object, @Nullable String object2, @Nullable OnInitializationCompleteListener onInitializationCompleteListener) {
        object2 = ((zzbjq)object3).zzc;
        synchronized (object2) {
            block14: {
                boolean bl = ((zzbjq)object3).zze;
                if (bl) {
                    if (onInitializationCompleteListener != null) {
                        zzbjq.zzf().zzb.add(onInitializationCompleteListener);
                    }
                    return;
                }
                bl = ((zzbjq)object3).zzf;
                if (bl) {
                    if (onInitializationCompleteListener != null) {
                        onInitializationCompleteListener.onInitializationComplete(((zzbjq)object3).zze());
                    }
                    return;
                }
                ((zzbjq)object3).zze = true;
                if (onInitializationCompleteListener != null) {
                    zzbjq.zzf().zzb.add(onInitializationCompleteListener);
                }
                if (object == null) {
                    Object object3 = new IllegalArgumentException("Context cannot be null.");
                    throw object3;
                }
                try {
                    zzaok zzaok2;
                    zzbxa.zza().zzb((Context)object, null);
                    super.zzv((Context)object);
                    if (onInitializationCompleteListener != null) {
                        zzbib zzbib2 = ((zzbjq)object3).zzd;
                        zzaok2 = new zzbjp((zzbjq)object3, null);
                        zzbib2.zzr((zzbtu)zzaok2);
                    }
                    zzbib zzbib3 = ((zzbjq)object3).zzd;
                    zzaok2 = new zzbxe();
                    zzbib3.zzn((zzbxh)zzaok2);
                    ((zzbjq)object3).zzd.zzj();
                    ((zzbjq)object3).zzd.zzk(null, ObjectWrapper.wrap(null));
                    int n = ((zzbjq)object3).zzh.getTagForChildDirectedTreatment();
                    if (n != -1 || (n = ((zzbjq)object3).zzh.getTagForUnderAgeOfConsent()) != -1) {
                        super.zzw(((zzbjq)object3).zzh);
                    }
                    zzblj.zzc(object);
                    object = zzblj.zzdP;
                    boolean bl2 = (Boolean)zzbgq.zzc().zzb(object);
                    if (bl2 || (bl2 = ((zzbjq)object3).zzg().endsWith("0"))) break block14;
                    Object object4 = "Google Mobile Ads SDK initialization functionality unavailable for this session. Ad requests can be made at any time.";
                    zzciz.zzg((String)object4);
                    ((zzbjq)object3).zzi = object4 = new zzbjj((zzbjq)object3);
                    if (onInitializationCompleteListener != null) {
                        object4 = zzcis.zza;
                        zzbjk zzbjk2 = new zzbjk((zzbjq)object3, onInitializationCompleteListener);
                        object4.post((Runnable)zzbjk2);
                    }
                }
                catch (RemoteException remoteException) {
                    object = "MobileAdsSettingManager initialization failed";
                    zzciz.zzk((String)object, remoteException);
                }
            }
            return;
        }
    }

    final /* synthetic */ void zzm(OnInitializationCompleteListener onInitializationCompleteListener) {
        onInitializationCompleteListener.onInitializationComplete(this.zzi);
    }

    @GuardedBy(value="lock")
    private final void zzv(Context context) {
        if (this.zzd == null) {
            zzbgm zzbgm2 = zzbgo.zza();
            zzbgg zzbgg2 = new zzbgg(zzbgm2, context);
            this.zzd = (zzbib)zzbgg2.zzd(context, false);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzn(Context object, OnAdInspectorClosedListener onAdInspectorClosedListener) {
        Object object2 = ((zzbjq)object3).zzc;
        synchronized (object2) {
            block5: {
                Object object3;
                ((zzbjq)object3).zzv((Context)object);
                zzbjq.zzf().zzg = onAdInspectorClosedListener;
                try {
                    object3 = ((zzbjq)object3).zzd;
                    object = new zzbjn(null);
                    object3.zzl((zzbin)object);
                }
                catch (RemoteException remoteException) {
                    object3 = "Unable to open the ad inspector.";
                    zzciz.zzg((String)object3);
                    if (onAdInspectorClosedListener == null) break block5;
                    object3 = new AdInspectorError(0, "Ad inspector had an internal error.", "com.google.android.gms.ads");
                    onAdInspectorClosedListener.onAdInspectorClosed((AdInspectorError)object3);
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzo(Context object, String string) {
        Object object2 = this.zzc;
        synchronized (object2) {
            zzbib zzbib2 = this.zzd;
            boolean bl = zzbib2 != null;
            Preconditions.checkState((boolean)bl, (Object)"MobileAds.initialize() must be called prior to opening debug menu.");
            try {
                this.zzd.zzm(ObjectWrapper.wrap((Object)object), string);
            }
            catch (RemoteException remoteException) {
                object = "Unable to open debug menu.";
                zzciz.zzh((String)object, remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzp(Class<? extends RtbAdapter> object) {
        Object object2 = this.zzc;
        synchronized (object2) {
            try {
                this.zzd.zzh(((Class)object).getCanonicalName());
            }
            catch (RemoteException remoteException) {
                object = "Unable to register RtbAdapter";
                zzciz.zzh((String)object, remoteException);
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzq(@NonNull WebView object) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        Object object2 = ((zzbjq)object2).zzc;
        synchronized (object2) {
            if (object == null) {
                object = "The webview to be registered cannot be null.";
                zzciz.zzg((String)object);
                return;
            }
            zzcht zzcht2 = zzccj.zza(object.getContext());
            if (zzcht2 == null) {
                object = "Internal error, query info generator is null.";
                zzciz.zzj((String)object);
                return;
            }
            try {
                zzcht2.zzg(ObjectWrapper.wrap((Object)object));
            }
            catch (RemoteException remoteException) {
                zzciz.zzh("", remoteException);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzr(boolean bl) {
        Object object = this.zzc;
        synchronized (object) {
            zzbib zzbib2 = this.zzd;
            boolean bl2 = zzbib2 != null;
            Preconditions.checkState((boolean)bl2, (Object)"MobileAds.initialize() must be called prior to setting app muted state.");
            try {
                this.zzd.zzo(bl);
            }
            catch (RemoteException remoteException) {
                String string = "Unable to set app mute state.";
                zzciz.zzh(string, remoteException);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzs(float f) {
        boolean bl = !(f < 0.0f) ? f <= 1.0f : false;
        Preconditions.checkArgument((boolean)bl, (Object)"The app volume must be a value between 0 and 1 inclusive.");
        Object object = this.zzc;
        synchronized (object) {
            zzbib zzbib2 = this.zzd;
            boolean bl2 = zzbib2 != null;
            Preconditions.checkState((boolean)bl2, (Object)"MobileAds.initialize() must be called prior to setting the app volume.");
            try {
                this.zzd.zzp(f);
            }
            catch (RemoteException remoteException) {
                String string = "Unable to set app volume.";
                zzciz.zzh(string, remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzt(@NonNull RequestConfiguration requestConfiguration) {
        boolean bl = requestConfiguration != null;
        Preconditions.checkArgument((boolean)bl, (Object)"Null passed to setRequestConfiguration.");
        Object object = this.zzc;
        synchronized (object) {
            int n;
            RequestConfiguration requestConfiguration2 = this.zzh;
            this.zzh = requestConfiguration;
            zzbib zzbib2 = this.zzd;
            if (zzbib2 == null) {
                return;
            }
            int n2 = requestConfiguration2.getTagForChildDirectedTreatment();
            if (n2 == (n = requestConfiguration.getTagForChildDirectedTreatment())) {
                int n3 = requestConfiguration2.getTagForUnderAgeOfConsent();
                if (n3 == (n2 = requestConfiguration.getTagForUnderAgeOfConsent())) return;
            }
            this.zzw(requestConfiguration);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @GuardedBy(value="lock")
    private final void zzw(@NonNull RequestConfiguration requestConfiguration) {
        try {
            zzbib zzbib2 = ((zzbjq)((Object)zzbib2)).zzd;
            zzbkk zzbkk2 = new zzbkk(requestConfiguration);
            zzbib2.zzs(zzbkk2);
            return;
        }
        catch (RemoteException remoteException) {
            zzciz.zzh("Unable to set request configuration parcel.", remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean zzu() {
        Object object = ((zzbjq)((Object)zzbib2)).zzc;
        synchronized (object) {
            zzbib zzbib2 = ((zzbjq)((Object)zzbib2)).zzd;
            if (zzbib2 == null) {
                return false;
            }
            try {
                return zzbib2.zzt();
            }
            catch (RemoteException remoteException) {
                String string = "Unable to get app mute state.";
                zzciz.zzh(string, remoteException);
                return false;
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static final InitializationStatus zzx(List<zzbtn> object) {
        HashMap<String, AdapterStatus> hashMap = new HashMap<String, AdapterStatus>();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            void var0_3;
            zzbtn zzbtn2 = (zzbtn)((Object)iterator.next());
            String string = zzbtn2.zza;
            if (zzbtn2.zzb) {
                AdapterStatus.State state = AdapterStatus.State.READY;
            } else {
                AdapterStatus.State state = AdapterStatus.State.NOT_READY;
            }
            zzbtv zzbtv2 = new zzbtv((AdapterStatus.State)var0_3, zzbtn2.zzd, zzbtn2.zzc);
            hashMap.put(string, zzbtv2);
        }
        return new zzbtw(hashMap);
    }
}

