/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.gms.ads.h5.OnH5AdsEventListener;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzbgm;
import com.google.android.gms.internal.ads.zzbgo;
import com.google.android.gms.internal.ads.zzbgq;
import com.google.android.gms.internal.ads.zzblb;
import com.google.android.gms.internal.ads.zzblj;
import com.google.android.gms.internal.ads.zzbsr;
import com.google.android.gms.internal.ads.zzbxe;
import com.google.android.gms.internal.ads.zzciz;

@RequiresApi(api=21)
public final class zzbsv {
    private final Context zza;
    private final OnH5AdsEventListener zzb;
    @Nullable
    private zzbsr zzc;

    /*
     * Enabled aggressive block sorting
     */
    public zzbsv(Context context, OnH5AdsEventListener onH5AdsEventListener) {
        boolean bl = Build.VERSION.SDK_INT >= 21;
        Preconditions.checkState((boolean)bl, (Object)"Android version must be Lollipop or higher");
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)onH5AdsEventListener);
        this.zza = context;
        this.zzb = onH5AdsEventListener;
        zzblj.zzc(context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void zza() {
        zzblb<Boolean> zzblb2 = zzblj.zzgU;
        if (!zzbgq.zzc().zzb(zzblb2).booleanValue()) {
            return;
        }
        ((zzbsv)((Object)zzbsr2)).zzd();
        zzbsr zzbsr2 = ((zzbsv)((Object)zzbsr2)).zzc;
        if (zzbsr2 == null) return;
        try {
            zzbsr2.zze();
            return;
        }
        catch (RemoteException remoteException) {
            zzciz.zzl("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    private final void zzd() {
        if (this.zzc != null) {
            return;
        }
        zzbgm zzbgm2 = zzbgo.zza();
        Context context = this.zza;
        zzbxe zzbxe2 = new zzbxe();
        this.zzc = zzbgm2.zzk(context, zzbxe2, this.zzb);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean zzb(String string) {
        if (!zzbsv.zzc(string)) {
            return false;
        }
        ((zzbsv)((Object)zzbsr2)).zzd();
        zzbsr zzbsr2 = ((zzbsv)((Object)zzbsr2)).zzc;
        if (zzbsr2 == null) return false;
        try {
            zzbsr2.zzf(string);
            return true;
        }
        catch (RemoteException remoteException) {
            zzciz.zzl("#007 Could not call remote method.", remoteException);
            return true;
        }
    }

    public static final boolean zzc(String string) {
        zzblb<Boolean> zzblb2 = zzblj.zzgU;
        if (!zzbgq.zzc().zzb(zzblb2).booleanValue()) {
            return false;
        }
        Preconditions.checkNotNull((Object)string);
        int n = string.length();
        zzblb<Integer> zzblb3 = zzblj.zzgW;
        if (n > zzbgq.zzc().zzb(zzblb3)) {
            zzciz.zze("H5 GMSG exceeds max length");
            return false;
        }
        return "gmsg".equals((string = Uri.parse((String)string)).getScheme()) && "mobileads.google.com".equals(string.getHost()) && "/h5ads".equals(string.getPath());
    }
}

