/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.ads.mediation.zzb;
import com.google.ads.mediation.zzc;
import com.google.ads.mediation.zze;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.BaseAdView;
import com.google.android.gms.ads.internal.client.zzay;
import com.google.android.gms.ads.internal.client.zzdq;
import com.google.android.gms.ads.internal.util.client.zzf;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.google.android.gms.ads.mediation.MediationInterstitialAdapter;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.ads.mediation.MediationNativeAdapter;
import com.google.android.gms.ads.mediation.MediationNativeListener;
import com.google.android.gms.ads.mediation.NativeMediationAdRequest;
import com.google.android.gms.ads.mediation.OnImmersiveModeUpdatedListener;
import com.google.android.gms.ads.mediation.zza;
import java.util.Set;

public abstract class AbstractAdViewAdapter
implements MediationBannerAdapter,
MediationInterstitialAdapter,
MediationNativeAdapter,
OnImmersiveModeUpdatedListener,
zza {
    @NonNull
    public static final String AD_UNIT_ID_PARAMETER = "pubid";
    @NonNull
    protected AdView mAdView;
    @NonNull
    protected InterstitialAd mInterstitialAd;
    private AdLoader adLoader;

    @NonNull
    protected abstract Bundle buildExtrasBundle(@NonNull Bundle var1, @NonNull Bundle var2);

    @Override
    @NonNull
    public View getBannerView() {
        return this.mAdView;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    AdLoader.Builder newAdLoader(Context context, String adUnitID) {
        void var2_2;
        void var1_1;
        return new AdLoader.Builder((Context)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    AdRequest buildAdRequest(Context context, MediationAdRequest mediationAdRequest, Bundle extras, Bundle serverParameters) {
        void var4_5;
        void var3_4;
        void var2_3;
        AdRequest.Builder builder = new AdRequest.Builder();
        Set<String> set = var2_3.getKeywords();
        if (set != null) {
            set = set.iterator();
            while (set.hasNext()) {
                builder.addKeyword((String)set.next());
            }
        }
        if (var2_3.isTesting()) {
            void var1_1;
            zzay.zzb();
            builder.zza(zzf.zzz((Context)var1_1));
        }
        if (var2_3.taggedForChildDirectedTreatment() != -1) {
            boolean bl = var2_3.taggedForChildDirectedTreatment() == 1;
            builder.zzc(bl);
        }
        builder.zzb(var2_3.isDesignedForFamilies());
        AbstractAdViewAdapter abstractAdViewAdapter = abstractAdViewAdapter.buildExtrasBundle((Bundle)var3_4, (Bundle)var4_5);
        builder.addNetworkExtrasBundle(AdMobAdapter.class, (Bundle)abstractAdViewAdapter);
        return builder.build();
    }

    @VisibleForTesting
    InterstitialAd getInterstitialAd() {
        return this.mInterstitialAd;
    }

    @NonNull
    public String getAdUnitId(@NonNull Bundle serverParameters) {
        return serverParameters.getString(AD_UNIT_ID_PARAMETER);
    }

    @Override
    public void onDestroy() {
        AdView adView = this.mAdView;
        if (adView != null) {
            adView.destroy();
            this.mAdView = null;
        }
        if (this.mInterstitialAd != null) {
            this.mInterstitialAd = null;
        }
        if (this.adLoader != null) {
            this.adLoader = null;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onImmersiveModeUpdated(boolean immersiveModeEnabled) {
        InterstitialAd this_ = ((AbstractAdViewAdapter)((Object)this_)).mInterstitialAd;
        if (this_ != null) {
            void var1_1;
            this_.setImmersiveMode((boolean)var1_1);
            return;
        }
    }

    @Override
    public void onPause() {
        Object this_ = this_.mAdView;
        if (this_ != null) {
            ((BaseAdView)((Object)this_)).pause();
            return;
        }
    }

    @Override
    public void onResume() {
        Object this_ = this_.mAdView;
        if (this_ != null) {
            ((BaseAdView)((Object)this_)).resume();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void requestBannerAd(@NonNull Context context, @NonNull MediationBannerListener bannerListener, @NonNull Bundle serverParameters, @NonNull AdSize adSize, @NonNull MediationAdRequest mediationAdRequest, @NonNull Bundle extras) {
        void var6_6;
        void var5_5;
        void var2_2;
        void var3_3;
        void var4_4;
        void var1_1;
        this.mAdView = new AdView((Context)var1_1);
        this.mAdView.setAdSize(new AdSize(var4_4.getWidth(), var4_4.getHeight()));
        this.mAdView.setAdUnitId(this.getAdUnitId((Bundle)var3_3));
        this.mAdView.setAdListener(new zzb(this, (MediationBannerListener)var2_2));
        this.mAdView.loadAd(this.buildAdRequest((Context)var1_1, (MediationAdRequest)var5_5, (Bundle)var6_6, (Bundle)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void requestInterstitialAd(@NonNull Context context, @NonNull MediationInterstitialListener interstitialListener, @NonNull Bundle serverParameters, @NonNull MediationAdRequest mediationAdRequest, @NonNull Bundle extras) {
        void var2_2;
        void var5_5;
        void var4_4;
        void var3_3;
        void var1_1;
        void v0 = var1_1;
        InterstitialAd.load((Context)v0, this.getAdUnitId((Bundle)var3_3), this.buildAdRequest((Context)v0, (MediationAdRequest)var4_4, (Bundle)var5_5, (Bundle)var3_3), new zzc(this, (MediationInterstitialListener)var2_2));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public void requestNativeAd(@NonNull Context context, @NonNull MediationNativeListener listener, @NonNull Bundle serverParameters, @NonNull NativeMediationAdRequest mediationAdRequest, @NonNull Bundle extras) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var1_1;
        zze zze2;
        zze zze3 = new zze(this, (MediationNativeListener)((Object)zze2));
        AdLoader.Builder builder = this.newAdLoader((Context)var1_1, var3_3.getString(AD_UNIT_ID_PARAMETER)).withAdListener(zze3);
        builder.zzc(var4_4.getNativeAdOptions());
        builder.withNativeAdOptions(var4_4.getNativeAdRequestOptions());
        if (var4_4.isUnifiedNativeAdRequested()) {
            builder.zzb(zze3);
        }
        if (var4_4.zzb()) {
            for (String string : var4_4.zza().keySet()) {
                zze2 = true != (Boolean)var4_4.zza().get(string) ? null : zze3;
                builder.zza(string, zze3, zze2);
            }
        }
        this.adLoader = builder.build();
        this.adLoader.loadAd(this.buildAdRequest((Context)var1_1, (MediationAdRequest)var4_4, (Bundle)var5_5, (Bundle)var3_3));
    }

    @Override
    public void showInterstitial() {
        InterstitialAd this_ = ((AbstractAdViewAdapter)((Object)this_)).mInterstitialAd;
        if (this_ != null) {
            this_.show(null);
            return;
        }
    }

    @Override
    @Nullable
    public zzdq getVideoController() {
        Object this_ = this_.mAdView;
        if (this_ != null) {
            return ((AdView)((Object)this_)).zza().zza();
        }
        return null;
    }
}

