/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.net.Uri;
import android.os.RemoteException;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.util.client.zzm;
import com.google.android.gms.ads.query.UpdateClickUrlCallback;
import com.google.android.gms.ads.query.UpdateImpressionUrlsCallback;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzbvx;
import com.google.android.gms.internal.ads.zzbvy;
import com.google.android.gms.internal.ads.zzbvz;
import com.google.android.gms.internal.ads.zzbwa;
import com.google.android.gms.internal.ads.zzbwb;
import com.google.android.gms.internal.ads.zzbwc;
import com.google.android.gms.internal.ads.zzbwe;
import com.google.android.gms.internal.ads.zzcbg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public final class zzbwd {
    @Nonnull
    private final View zza;
    @Nullable
    private final Map zzb;
    @Nullable
    private final zzcbg zzc;

    public zzbwd(zzbwc zzbwc2) {
        this.zza = zzbwc.zza(zzbwc2);
        this.zzb = zzbwc.zzd(zzbwc2);
        this.zzc = zzbvx.zza(zzbwc.zza(zzbwc2).getContext());
        if (this.zzc == null || this.zzb.isEmpty()) {
            return;
        }
        try {
            this.zzc.zzg(new zzbwe(ObjectWrapper.wrap((Object)this.zza).asBinder(), ObjectWrapper.wrap((Object)this.zzb).asBinder()));
            return;
        }
        catch (RemoteException remoteException) {
            zzm.zzg("Failed to call remote method.");
            return;
        }
    }

    public final void zza(List list) {
        if (list == null || list.isEmpty()) {
            zzm.zzj("No click urls were passed to recordClick");
            return;
        }
        if (this.zzc == null) {
            zzm.zzj("Failed to get internal reporting info generator in recordClick.");
        }
        try {
            zzcbg zzcbg2 = this.zzc;
            IObjectWrapper iObjectWrapper = ObjectWrapper.wrap((Object)this.zza);
            zzcbg2.zzh(list, iObjectWrapper, new zzbwb(this, list));
            return;
        }
        catch (RemoteException remoteException) {
            zzm.zzg("RemoteException recording click: ".concat(((Object)((Object)remoteException)).toString()));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzb(List list) {
        if (list == null || list.isEmpty()) {
            zzm.zzj("No impression urls were passed to recordImpression");
            return;
        }
        zzcbg zzcbg2 = this.zzc;
        if (zzcbg2 == null) {
            zzm.zzj("Failed to get internal reporting info generator from recordImpression.");
            return;
        }
        try {
            IObjectWrapper iObjectWrapper = ObjectWrapper.wrap((Object)this.zza);
            zzcbg2.zzi(list, iObjectWrapper, new zzbwa(this, list));
            return;
        }
        catch (RemoteException remoteException) {
            zzm.zzg("RemoteException recording impression urls: ".concat(((Object)((Object)remoteException)).toString()));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzc(MotionEvent motionEvent) {
        zzcbg zzcbg2;
        zzcbg2 = ((zzbwd)((Object)zzcbg2)).zzc;
        if (zzcbg2 == null) {
            zzm.zze("Failed to get internal reporting info generator.");
            return;
        }
        try {
            zzcbg2.zzk(ObjectWrapper.wrap((Object)motionEvent));
            return;
        }
        catch (RemoteException remoteException) {
            zzm.zzg("Failed to call remote method.");
            return;
        }
    }

    public final void zzd(Uri uri, UpdateClickUrlCallback updateClickUrlCallback) {
        if (this.zzc == null) {
            updateClickUrlCallback.onFailure("Failed to get internal reporting info generator.");
        }
        try {
            zzcbg zzcbg2 = this.zzc;
            ArrayList<Uri> arrayList = new ArrayList<Uri>(Arrays.asList(uri));
            uri = ObjectWrapper.wrap((Object)this.zza);
            zzcbg2.zzl(arrayList, (IObjectWrapper)uri, new zzbvz(this, updateClickUrlCallback));
            return;
        }
        catch (RemoteException remoteException) {
            updateClickUrlCallback.onFailure("Internal error: ".concat(((Object)((Object)remoteException)).toString()));
            return;
        }
    }

    public final void zze(List list, UpdateImpressionUrlsCallback updateImpressionUrlsCallback) {
        if (this.zzc == null) {
            updateImpressionUrlsCallback.onFailure("Failed to get internal reporting info generator.");
        }
        try {
            zzcbg zzcbg2 = this.zzc;
            IObjectWrapper iObjectWrapper = ObjectWrapper.wrap((Object)this.zza);
            zzcbg2.zzm(list, iObjectWrapper, new zzbvy(this, updateImpressionUrlsCallback));
            return;
        }
        catch (RemoteException remoteException) {
            updateImpressionUrlsCallback.onFailure("Internal error: ".concat(((Object)((Object)remoteException)).toString()));
            return;
        }
    }
}

