/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.appopen;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.AdLoadCallback;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.ResponseInfo;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import com.google.android.gms.ads.appopen.zza;
import com.google.android.gms.ads.appopen.zzb;
import com.google.android.gms.ads.appopen.zzc;
import com.google.android.gms.ads.internal.client.zzba;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzazx;
import com.google.android.gms.internal.ads.zzbbn;
import com.google.android.gms.internal.ads.zzbbw;
import com.google.android.gms.internal.ads.zzbdq;

public abstract class AppOpenAd {
    public static final int APP_OPEN_AD_ORIENTATION_PORTRAIT = 1;
    public static final int APP_OPEN_AD_ORIENTATION_LANDSCAPE = 2;

    @Nullable
    public abstract FullScreenContentCallback getFullScreenContentCallback();

    @Nullable
    public abstract OnPaidEventListener getOnPaidEventListener();

    @NonNull
    public abstract ResponseInfo getResponseInfo();

    @NonNull
    public abstract String getAdUnitId();

    /*
     * WARNING - void declaration
     */
    public static void load(@NonNull Context context, @NonNull String adUnitId, @NonNull AdRequest adRequest, @NonNull AppOpenAdLoadCallback loadCallback) {
        void var3_3;
        Context context2;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull((Object)context, (Object)"Context cannot be null.");
        Preconditions.checkNotNull((Object)var1_1, (Object)"adUnitId cannot be null.");
        Preconditions.checkNotNull((Object)var2_2, (Object)"AdRequest cannot be null.");
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbbw.zza(context2);
        if (((Boolean)zzbdq.zzd.zze()).booleanValue()) {
            zzbbn zzbbn2 = zzbbw.zzkl;
            if (((Boolean)zzba.zzc().zza(zzbbn2)).booleanValue()) {
                com.google.android.gms.ads.internal.util.client.zzb.zzb.execute(new zza(context2, (String)var1_1, (AdRequest)var2_2, (AppOpenAdLoadCallback)var3_3));
                return;
            }
        }
        new zzazx(context2, (String)var1_1, var2_2.zza(), 3, (AppOpenAdLoadCallback)var3_3).zza();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static void load(@NonNull Context context, @NonNull String adUnitId, @NonNull AdRequest adRequest, @AppOpenAdOrientation int orientation, @NonNull AppOpenAdLoadCallback loadCallback) {
        void var4_4;
        void var3_3;
        Context context2;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull((Object)context, (Object)"Context cannot be null.");
        Preconditions.checkNotNull((Object)var1_1, (Object)"adUnitId cannot be null.");
        Preconditions.checkNotNull((Object)var2_2, (Object)"AdRequest cannot be null.");
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbbw.zza(context2);
        if (((Boolean)zzbdq.zzd.zze()).booleanValue()) {
            zzbbn zzbbn2 = zzbbw.zzkl;
            if (((Boolean)zzba.zzc().zza(zzbbn2)).booleanValue()) {
                com.google.android.gms.ads.internal.util.client.zzb.zzb.execute(new zzb(context2, (String)var1_1, (AdRequest)var2_2, (int)var3_3, (AppOpenAdLoadCallback)var4_4));
                return;
            }
        }
        new zzazx(context2, (String)var1_1, var2_2.zza(), (int)var3_3, (AppOpenAdLoadCallback)var4_4).zza();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static void load(@NonNull Context context, @NonNull String adUnitId, @NonNull AdManagerAdRequest adManagerAdRequest, @AppOpenAdOrientation int orientation, @NonNull AppOpenAdLoadCallback loadCallback) {
        void var4_4;
        void var3_3;
        Context context2;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull((Object)context, (Object)"Context cannot be null.");
        Preconditions.checkNotNull((Object)var1_1, (Object)"adUnitId cannot be null.");
        Preconditions.checkNotNull((Object)var2_2, (Object)"AdManagerAdRequest cannot be null.");
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbbw.zza(context2);
        if (((Boolean)zzbdq.zzd.zze()).booleanValue()) {
            zzbbn zzbbn2 = zzbbw.zzkl;
            if (((Boolean)zzba.zzc().zza(zzbbn2)).booleanValue()) {
                com.google.android.gms.ads.internal.util.client.zzb.zzb.execute(new zzc(context2, (String)var1_1, (AdManagerAdRequest)var2_2, (int)var3_3, (AppOpenAdLoadCallback)var4_4));
                return;
            }
        }
        new zzazx(context2, (String)var1_1, var2_2.zza(), (int)var3_3, (AppOpenAdLoadCallback)var4_4).zza();
    }

    public abstract void setFullScreenContentCallback(@Nullable FullScreenContentCallback var1);

    public abstract void setImmersiveMode(boolean var1);

    public abstract void setOnPaidEventListener(@Nullable OnPaidEventListener var1);

    public abstract void show(@NonNull Activity var1);

    public static abstract class AppOpenAdLoadCallback
    extends AdLoadCallback<AppOpenAd> {
    }

    public static @interface AppOpenAdOrientation {
    }
}

