/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.net.Uri;
import android.os.RemoteException;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.util.client.zzm;
import com.google.android.gms.ads.query.UpdateClickUrlCallback;
import com.google.android.gms.ads.query.UpdateImpressionUrlsCallback;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzbte;
import com.google.android.gms.internal.ads.zzbtf;
import com.google.android.gms.internal.ads.zzbtg;
import com.google.android.gms.internal.ads.zzbth;
import com.google.android.gms.internal.ads.zzbti;
import com.google.android.gms.internal.ads.zzbtj;
import com.google.android.gms.internal.ads.zzbtl;
import com.google.android.gms.internal.ads.zzbym;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public final class zzbtk {
    @Nonnull
    private final View zza;
    @Nullable
    private final Map zzb;
    @Nullable
    private final zzbym zzc;

    public zzbtk(zzbtj zzbtj2) {
        this.zza = zzbtj.zza(zzbtj2);
        this.zzb = zzbtj.zzd(zzbtj2);
        this.zzc = zzbte.zza(zzbtj.zza(zzbtj2).getContext());
        if (this.zzc == null || this.zzb.isEmpty()) {
            return;
        }
        try {
            this.zzc.zzg(new zzbtl(ObjectWrapper.wrap((Object)this.zza).asBinder(), ObjectWrapper.wrap((Object)this.zzb).asBinder()));
            return;
        }
        catch (RemoteException remoteException) {
            zzm.zzg("Failed to call remote method.");
            return;
        }
    }

    public final void zza(List list) {
        if (list == null || list.isEmpty()) {
            zzm.zzj("No click urls were passed to recordClick");
            return;
        }
        if (this.zzc == null) {
            zzm.zzj("Failed to get internal reporting info generator in recordClick.");
        }
        try {
            zzbym zzbym2 = this.zzc;
            IObjectWrapper iObjectWrapper = ObjectWrapper.wrap((Object)this.zza);
            zzbym2.zzh(list, iObjectWrapper, new zzbti(this, list));
            return;
        }
        catch (RemoteException remoteException) {
            zzm.zzg("RemoteException recording click: ".concat(((Object)((Object)remoteException)).toString()));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzb(List list) {
        if (list == null || list.isEmpty()) {
            zzm.zzj("No impression urls were passed to recordImpression");
            return;
        }
        zzbym zzbym2 = this.zzc;
        if (zzbym2 == null) {
            zzm.zzj("Failed to get internal reporting info generator from recordImpression.");
            return;
        }
        try {
            IObjectWrapper iObjectWrapper = ObjectWrapper.wrap((Object)this.zza);
            zzbym2.zzi(list, iObjectWrapper, new zzbth(this, list));
            return;
        }
        catch (RemoteException remoteException) {
            zzm.zzg("RemoteException recording impression urls: ".concat(((Object)((Object)remoteException)).toString()));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzc(MotionEvent motionEvent) {
        zzbym zzbym2;
        zzbym2 = ((zzbtk)((Object)zzbym2)).zzc;
        if (zzbym2 == null) {
            zzm.zze("Failed to get internal reporting info generator.");
            return;
        }
        try {
            zzbym2.zzk(ObjectWrapper.wrap((Object)motionEvent));
            return;
        }
        catch (RemoteException remoteException) {
            zzm.zzg("Failed to call remote method.");
            return;
        }
    }

    public final void zzd(Uri uri, UpdateClickUrlCallback updateClickUrlCallback) {
        if (this.zzc == null) {
            updateClickUrlCallback.onFailure("Failed to get internal reporting info generator.");
        }
        try {
            zzbym zzbym2 = this.zzc;
            ArrayList<Uri> arrayList = new ArrayList<Uri>(Arrays.asList(uri));
            uri = ObjectWrapper.wrap((Object)this.zza);
            zzbym2.zzl(arrayList, (IObjectWrapper)uri, new zzbtg(this, updateClickUrlCallback));
            return;
        }
        catch (RemoteException remoteException) {
            updateClickUrlCallback.onFailure("Internal error: ".concat(((Object)((Object)remoteException)).toString()));
            return;
        }
    }

    public final void zze(List list, UpdateImpressionUrlsCallback updateImpressionUrlsCallback) {
        if (this.zzc == null) {
            updateImpressionUrlsCallback.onFailure("Failed to get internal reporting info generator.");
        }
        try {
            zzbym zzbym2 = this.zzc;
            IObjectWrapper iObjectWrapper = ObjectWrapper.wrap((Object)this.zza);
            zzbym2.zzm(list, iObjectWrapper, new zzbtf(this, updateImpressionUrlsCallback));
            return;
        }
        catch (RemoteException remoteException) {
            updateImpressionUrlsCallback.onFailure("Internal error: ".concat(((Object)((Object)remoteException)).toString()));
            return;
        }
    }
}

