/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.util;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.work.Configuration;
import androidx.work.Constraints;
import androidx.work.Data;
import androidx.work.NetworkType;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import com.google.android.apps.common.proguard.UsedByReflection;
import com.google.android.gms.ads.internal.offline.buffering.OfflineNotificationPoster;
import com.google.android.gms.ads.internal.offline.buffering.OfflinePingSender;
import com.google.android.gms.ads.internal.offline.buffering.zza;
import com.google.android.gms.ads.internal.util.client.zzo;
import com.google.android.gms.ads.internal.util.zzbq;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;

@KeepForSdk
public class WorkManagerUtil
extends zzbq {
    @UsedByReflection(value="This class must be instantiated reflectively so that the default class loader can be used.")
    public WorkManagerUtil() {
    }

    private static void zzb(Context context) {
        try {
            WorkManager.initialize((Context)context.getApplicationContext(), (Configuration)new Configuration.Builder().build());
            return;
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
    }

    @Override
    public final void zze(@NonNull IObjectWrapper iObjectWrapper) {
        WorkManagerUtil workManagerUtil = (Context)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        WorkManagerUtil.zzb((Context)workManagerUtil);
        try {
            workManagerUtil = WorkManager.getInstance((Context)workManagerUtil);
        }
        catch (IllegalStateException illegalStateException) {
            zzo.zzk("Failed to instantiate WorkManager.", illegalStateException);
            return;
        }
        workManagerUtil.cancelAllWorkByTag("offline_ping_sender_work");
        workManagerUtil.enqueue((WorkRequest)((OneTimeWorkRequest)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(OfflinePingSender.class).setConstraints(new Constraints.Builder().setRequiredNetworkType(NetworkType.CONNECTED).build())).addTag("offline_ping_sender_work")).build()));
    }

    @Override
    public final boolean zzf(@NonNull IObjectWrapper iObjectWrapper, @NonNull String string, @NonNull String string2) {
        String string3 = "";
        return this.zzg(iObjectWrapper, new zza(string, string2, string3));
    }

    @Override
    public final boolean zzg(IObjectWrapper iObjectWrapper, zza zza2) {
        WorkManagerUtil workManagerUtil = (Context)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        WorkManagerUtil.zzb((Context)workManagerUtil);
        iObjectWrapper = new Data.Builder().putString("uri", zza2.zza).putString("gws_query_id", zza2.zzb).putString("image_url", zza2.zzc).build();
        iObjectWrapper = (OneTimeWorkRequest)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(OfflineNotificationPoster.class).setConstraints(new Constraints.Builder().setRequiredNetworkType(NetworkType.CONNECTED).build())).setInputData((Data)iObjectWrapper)).addTag("offline_notification_work")).build();
        try {
            workManagerUtil = WorkManager.getInstance((Context)workManagerUtil);
        }
        catch (IllegalStateException illegalStateException) {
            zzo.zzk("Failed to instantiate WorkManager.", illegalStateException);
            return false;
        }
        workManagerUtil.enqueue((WorkRequest)iObjectWrapper);
        return true;
    }
}

