/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.view.View;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAdView;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.ads.mediation.MediationNativeAdapter;
import com.google.android.gms.ads.mediation.MediationNativeListener;
import com.google.android.gms.ads.mediation.NativeAppInstallAdMapper;
import com.google.android.gms.ads.mediation.NativeContentAdMapper;
import com.google.android.gms.ads.mediation.NativeMediationAdRequest;
import com.google.android.gms.ads.reward.RewardItem;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdAdapter;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdListener;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzlm;
import java.util.Date;
import java.util.Set;

@zzig
public abstract class AbstractAdViewAdapter
implements MediationBannerAdapter,
MediationNativeAdapter,
MediationRewardedVideoAdAdapter,
zzlm {
    public static final String AD_UNIT_ID_PARAMETER = "pubid";
    protected AdView zzaS;
    protected InterstitialAd zzaT;
    private AdLoader zzaU;
    private Context zzaV;
    private InterstitialAd zzaW;
    private MediationRewardedVideoAdListener zzaX;
    final RewardedVideoAdListener zzaY = new RewardedVideoAdListener(){

        @Override
        public void onRewardedVideoAdLoaded() {
            AbstractAdViewAdapter.this.zzaX.onAdLoaded(AbstractAdViewAdapter.this);
        }

        @Override
        public void onRewardedVideoAdOpened() {
            AbstractAdViewAdapter.this.zzaX.onAdOpened(AbstractAdViewAdapter.this);
        }

        @Override
        public void onRewardedVideoStarted() {
            AbstractAdViewAdapter.this.zzaX.onVideoStarted(AbstractAdViewAdapter.this);
        }

        @Override
        public void onRewardedVideoAdClosed() {
            AbstractAdViewAdapter.this.zzaX.onAdClosed(AbstractAdViewAdapter.this);
            AbstractAdViewAdapter.this.zzaW = null;
        }

        @Override
        public void onRewarded(RewardItem rewardItem) {
            AbstractAdViewAdapter.this.zzaX.onRewarded(AbstractAdViewAdapter.this, rewardItem);
        }

        @Override
        public void onRewardedVideoAdLeftApplication() {
            AbstractAdViewAdapter.this.zzaX.onAdLeftApplication(AbstractAdViewAdapter.this);
        }

        @Override
        public void onRewardedVideoAdFailedToLoad(int n) {
            AbstractAdViewAdapter.this.zzaX.onAdFailedToLoad(AbstractAdViewAdapter.this, n);
        }
    };

    protected abstract Bundle zza(Bundle var1, Bundle var2);

    AdRequest zza(Context context, MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle2) {
        String string;
        Location location;
        Set<String> set;
        int n;
        AdRequest.Builder builder = new AdRequest.Builder();
        Date date = mediationAdRequest.getBirthday();
        if (date != null) {
            builder.setBirthday(date);
        }
        if ((n = mediationAdRequest.getGender()) != 0) {
            builder.setGender(n);
        }
        if ((set = mediationAdRequest.getKeywords()) != null) {
            location = set.iterator();
            while (location.hasNext()) {
                string = (String)location.next();
                builder.addKeyword(string);
            }
        }
        if ((location = mediationAdRequest.getLocation()) != null) {
            builder.setLocation(location);
        }
        if (mediationAdRequest.isTesting()) {
            builder.addTestDevice(zzm.zzdQ().zzP(context));
        }
        if (mediationAdRequest.taggedForChildDirectedTreatment() != -1) {
            builder.tagForChildDirectedTreatment(mediationAdRequest.taggedForChildDirectedTreatment() == 1);
        }
        builder.setIsDesignedForFamilies(mediationAdRequest.isDesignedForFamilies());
        string = this.zza(bundle, bundle2);
        builder.addNetworkExtrasBundle(AdMobAdapter.class, (Bundle)string);
        return builder.build();
    }

    @Override
    public void onDestroy() {
        if (this.zzaS != null) {
            this.zzaS.destroy();
            this.zzaS = null;
        }
        if (this.zzaT != null) {
            this.zzaT = null;
        }
        if (this.zzaU != null) {
            this.zzaU = null;
        }
        if (this.zzaW != null) {
            this.zzaW = null;
        }
    }

    @Override
    public void onPause() {
        if (this.zzaS != null) {
            this.zzaS.pause();
        }
    }

    @Override
    public void onResume() {
        if (this.zzaS != null) {
            this.zzaS.resume();
        }
    }

    public String getAdUnitId(Bundle bundle) {
        return bundle.getString(AD_UNIT_ID_PARAMETER);
    }

    @Override
    public void requestBannerAd(Context context, MediationBannerListener mediationBannerListener, Bundle bundle, AdSize adSize, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zzaS = new AdView(context);
        this.zzaS.setAdSize(new AdSize(adSize.getWidth(), adSize.getHeight()));
        this.zzaS.setAdUnitId(this.getAdUnitId(bundle));
        this.zzaS.setAdListener(new zzc(this, mediationBannerListener));
        this.zzaS.loadAd(this.zza(context, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public View getBannerView() {
        return this.zzaS;
    }

    @Override
    public void requestInterstitialAd(Context context, MediationInterstitialListener mediationInterstitialListener, Bundle bundle, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zzaT = new InterstitialAd(context);
        this.zzaT.setAdUnitId(this.getAdUnitId(bundle));
        this.zzaT.setAdListener(new zzd(this, mediationInterstitialListener));
        this.zzaT.loadAd(this.zza(context, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public void showInterstitial() {
        this.zzaT.show();
    }

    @Override
    public Bundle getInterstitialAdapterInfo() {
        return new MediationAdapter.zza().zzZ(1).zzki();
    }

    @Override
    public void requestNativeAd(Context context, MediationNativeListener mediationNativeListener, Bundle bundle, NativeMediationAdRequest nativeMediationAdRequest, Bundle bundle2) {
        zze zze2 = new zze(this, mediationNativeListener);
        AdLoader.Builder builder = this.zza(context, bundle.getString(AD_UNIT_ID_PARAMETER)).withAdListener(zze2);
        NativeAdOptions nativeAdOptions = nativeMediationAdRequest.getNativeAdOptions();
        if (nativeAdOptions != null) {
            builder.withNativeAdOptions(nativeAdOptions);
        }
        if (nativeMediationAdRequest.isAppInstallAdRequested()) {
            builder.forAppInstallAd(zze2);
        }
        if (nativeMediationAdRequest.isContentAdRequested()) {
            builder.forContentAd(zze2);
        }
        this.zzaU = builder.build();
        this.zzaU.loadAd(this.zza(context, nativeMediationAdRequest, bundle2, bundle));
    }

    AdLoader.Builder zza(Context context, String string) {
        return new AdLoader.Builder(context, string);
    }

    @Override
    public void initialize(Context context, MediationAdRequest mediationAdRequest, String string, MediationRewardedVideoAdListener mediationRewardedVideoAdListener, Bundle bundle, Bundle bundle2) {
        this.zzaV = context.getApplicationContext();
        this.zzaX = mediationRewardedVideoAdListener;
        this.zzaX.onInitializationSucceeded(this);
    }

    @Override
    public void loadAd(MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle2) {
        if (this.zzaV == null || this.zzaX == null) {
            com.google.android.gms.ads.internal.util.client.zzb.e("AdMobAdapter.loadAd called before initialize.");
            return;
        }
        this.zzaW = new InterstitialAd(this.zzaV);
        this.zzaW.zzc(true);
        this.zzaW.setAdUnitId(this.getAdUnitId(bundle));
        this.zzaW.setRewardedVideoAdListener(this.zzaY);
        this.zzaW.loadAd(this.zza(this.zzaV, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public void showVideo() {
        this.zzaW.show();
    }

    @Override
    public boolean isInitialized() {
        return this.zzaX != null;
    }

    static class zzb
    extends NativeContentAdMapper {
        private final NativeContentAd zzbb;

        public zzb(NativeContentAd nativeContentAd) {
            this.zzbb = nativeContentAd;
            this.setHeadline(nativeContentAd.getHeadline().toString());
            this.setImages(nativeContentAd.getImages());
            this.setBody(nativeContentAd.getBody().toString());
            this.setLogo(nativeContentAd.getLogo());
            this.setCallToAction(nativeContentAd.getCallToAction().toString());
            this.setAdvertiser(nativeContentAd.getAdvertiser().toString());
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
        }

        @Override
        public void trackView(View view) {
            if (view instanceof NativeAdView) {
                ((NativeAdView)view).setNativeAd(this.zzbb);
            }
        }
    }

    static class zza
    extends NativeAppInstallAdMapper {
        private final NativeAppInstallAd zzba;

        public zza(NativeAppInstallAd nativeAppInstallAd) {
            this.zzba = nativeAppInstallAd;
            this.setHeadline(nativeAppInstallAd.getHeadline().toString());
            this.setImages(nativeAppInstallAd.getImages());
            this.setBody(nativeAppInstallAd.getBody().toString());
            this.setIcon(nativeAppInstallAd.getIcon());
            this.setCallToAction(nativeAppInstallAd.getCallToAction().toString());
            this.setStarRating(nativeAppInstallAd.getStarRating());
            this.setStore(nativeAppInstallAd.getStore().toString());
            this.setPrice(nativeAppInstallAd.getPrice().toString());
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
        }

        @Override
        public void trackView(View view) {
            if (view instanceof NativeAdView) {
                ((NativeAdView)view).setNativeAd(this.zzba);
            }
        }
    }

    static final class zze
    extends AdListener
    implements NativeAppInstallAd.OnAppInstallAdLoadedListener,
    NativeContentAd.OnContentAdLoadedListener,
    com.google.android.gms.ads.internal.client.zza {
        final AbstractAdViewAdapter zzbc;
        final MediationNativeListener zzbf;

        public zze(AbstractAdViewAdapter abstractAdViewAdapter, MediationNativeListener mediationNativeListener) {
            this.zzbc = abstractAdViewAdapter;
            this.zzbf = mediationNativeListener;
        }

        @Override
        public void onAdLoaded() {
        }

        @Override
        public void onAdFailedToLoad(int n) {
            this.zzbf.onAdFailedToLoad(this.zzbc, n);
        }

        @Override
        public void onAdOpened() {
            this.zzbf.onAdOpened(this.zzbc);
        }

        @Override
        public void onAdClosed() {
            this.zzbf.onAdClosed(this.zzbc);
        }

        @Override
        public void onAdLeftApplication() {
            this.zzbf.onAdLeftApplication(this.zzbc);
        }

        @Override
        public void onAdClicked() {
            this.zzbf.onAdClicked(this.zzbc);
        }

        @Override
        public void onAppInstallAdLoaded(NativeAppInstallAd nativeAppInstallAd) {
            this.zzbf.onAdLoaded(this.zzbc, new zza(nativeAppInstallAd));
        }

        @Override
        public void onContentAdLoaded(NativeContentAd nativeContentAd) {
            this.zzbf.onAdLoaded(this.zzbc, new zzb(nativeContentAd));
        }
    }

    static final class zzd
    extends AdListener
    implements com.google.android.gms.ads.internal.client.zza {
        final AbstractAdViewAdapter zzbc;
        final MediationInterstitialListener zzbe;

        public zzd(AbstractAdViewAdapter abstractAdViewAdapter, MediationInterstitialListener mediationInterstitialListener) {
            this.zzbc = abstractAdViewAdapter;
            this.zzbe = mediationInterstitialListener;
        }

        @Override
        public void onAdLoaded() {
            this.zzbe.onAdLoaded(this.zzbc);
        }

        @Override
        public void onAdFailedToLoad(int n) {
            this.zzbe.onAdFailedToLoad(this.zzbc, n);
        }

        @Override
        public void onAdOpened() {
            this.zzbe.onAdOpened(this.zzbc);
        }

        @Override
        public void onAdClosed() {
            this.zzbe.onAdClosed(this.zzbc);
        }

        @Override
        public void onAdLeftApplication() {
            this.zzbe.onAdLeftApplication(this.zzbc);
        }

        @Override
        public void onAdClicked() {
            this.zzbe.onAdClicked(this.zzbc);
        }
    }

    static final class zzc
    extends AdListener
    implements com.google.android.gms.ads.internal.client.zza {
        final AbstractAdViewAdapter zzbc;
        final MediationBannerListener zzbd;

        public zzc(AbstractAdViewAdapter abstractAdViewAdapter, MediationBannerListener mediationBannerListener) {
            this.zzbc = abstractAdViewAdapter;
            this.zzbd = mediationBannerListener;
        }

        @Override
        public void onAdLoaded() {
            this.zzbd.onAdLoaded(this.zzbc);
        }

        @Override
        public void onAdFailedToLoad(int n) {
            this.zzbd.onAdFailedToLoad(this.zzbc, n);
        }

        @Override
        public void onAdOpened() {
            this.zzbd.onAdOpened(this.zzbc);
        }

        @Override
        public void onAdClosed() {
            this.zzbd.onAdClosed(this.zzbc);
        }

        @Override
        public void onAdLeftApplication() {
            this.zzbd.onAdLeftApplication(this.zzbc);
        }

        @Override
        public void onAdClicked() {
            this.zzbd.onAdClicked(this.zzbc);
        }
    }
}

